/*
 * Decompiled with CFR 0.152.
 */
package travelers.util.helper;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import travelers.TravelersConstants;
import travelers.util.helper.obj.IGenericProperties;
import travelers.util.helper.obj.TravelerRegistryObject;

public class PlatformHelper {
    public static final LinkedHashSet<TravelerRegistryObject<?>> registryMap = new LinkedHashSet();
    private static boolean locked;
    public static final IGenericProperties properties;

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        TravelersConstants.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public static <T> Supplier<T> register(Registry<T> registry, ResourceLocation id, Supplier<T> supplier) {
        if (locked) {
            TravelersConstants.LOGGER.debug("Your registering {} after registry event was thrown", (Object)id);
            return null;
        }
        supplier = Suppliers.memoize(supplier);
        if (properties.getPlatformName().equalsIgnoreCase("fabric")) {
            properties.register(registry, id, supplier);
        } else {
            registryMap.add(new TravelerRegistryObject<T>(registry, id, supplier));
        }
        return supplier;
    }

    public static void lock() {
        locked = true;
    }

    static {
        properties = PlatformHelper.load(IGenericProperties.class);
    }
}

