/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal;

import com.google.common.base.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import travelers.server.animal.ModelType;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.other.TravelersAnimalAnimationModule;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.animal.obj.TravelersItemInterface;
import travelers.server.animal.obj.TravelersMoveAnalysis;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.util.helper.PlatformHelper;

public class TravelersAnimal<T extends SmartAnimalBase> {
    private final TravelersAnimalAttributes<T> animalAttributes;
    private TravelersItemInterface<T> items;
    private ModelType modelType = ModelType.AZURE;
    private Supplier<EntityType<? extends Entity>> entityType;

    public TravelersAnimal(TravelersAnimalAttributes<T> animalAttributes) {
        this.animalAttributes = animalAttributes;
        if (animalAttributes.getEntityBaseProperties().getLocator() != null) {
            animalAttributes.getEntityBaseProperties().getLocator().setModId(animalAttributes.getModId());
        }
    }

    public void animate(SmartAnimalBase base, TravelersMoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
    }

    public void animateServer(SmartAnimalBase base, TravelersMoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
    }

    public void setItemInterface(TravelersItemInterface<T> itemInterface) {
        this.items = itemInterface;
    }

    public AttributeSupplier.Builder createAnimalAttributes() {
        return SmartAnimalBase.createMobAttributes().add(Attributes.MAX_HEALTH, this.getAnimalAttributes().getEntityAttributeProperties().getMaxHealth()).add(Attributes.WATER_MOVEMENT_EFFICIENCY, this.getAnimalAttributes().getEntityAttributeProperties().getWaterEfficiency()).add(Attributes.ATTACK_DAMAGE, this.getAnimalAttributes().getEntityAttributeProperties().getAttackDamage()).add(Attributes.ATTACK_SPEED, this.getAnimalAttributes().getEntityAttributeProperties().getAttackSpeed()).add(Attributes.MOVEMENT_SPEED, this.getAnimalAttributes().getEntityAttributeProperties().getMovementSpeed()).add(Attributes.FOLLOW_RANGE, this.getAnimalAttributes().getEntityAttributeProperties().getTrackingRange()).add(Attributes.FLYING_SPEED, this.getAnimalAttributes().getEntityAttributeProperties().getFlyingSpeed());
    }

    public final Supplier<EntityType<?>> buildType() {
        if (this.entityType != null) {
            return this.entityType;
        }
        return () -> {
            EntityAttributeProperties<T> entityAttributes = this.animalAttributes.getEntityAttributeProperties();
            EntityType.Builder builder = EntityType.Builder.of(entityAttributes.getEntityFactory(), (MobCategory)entityAttributes.getCategory()).sized((float)entityAttributes.getDimensions()[0], (float)entityAttributes.getDimensions()[1]);
            if (entityAttributes.isSpawnFar()) {
                builder.canSpawnFarFromPlayer();
            }
            builder.clientTrackingRange((int)entityAttributes.getTrackingRange());
            if (entityAttributes.getEyeHeight() != -1.0) {
                builder.eyeHeight((float)entityAttributes.getEyeHeight());
            }
            this.extraTypeArguments(builder, this.animalAttributes);
            builder.spawnDimensionsScale((float)entityAttributes.getDimensions()[1]);
            builder.clientTrackingRange((int)entityAttributes.getTrackingRange());
            if (PlatformHelper.properties.getPlatformName().equalsIgnoreCase("fabric")) {
                return builder.build(null);
            }
            return builder.build(this.animalAttributes.getModId() + ":" + this.animalAttributes.getAnimalName());
        };
    }

    protected void extraTypeArguments(EntityType.Builder<T> builder, TravelersAnimalAttributes<T> animalAttributes) {
    }

    public TravelersAnimalAttributes<T> getAnimalAttributes() {
        return this.animalAttributes;
    }

    public TravelersItemInterface<T> getItems() {
        return this.items;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public Supplier<EntityType<? extends Entity>> getEntityType() {
        return this.entityType;
    }

    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public void setEntityType(Supplier<EntityType<? extends Entity>> entityType) {
        this.entityType = entityType;
    }
}

