/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.NotNull;
import travelers.TravelersConstants;
import travelers.client.render.animation.entity.TravelersAnimationMap;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.TravelersAnimalRegistry;
import travelers.server.animal.entity.other.IPartHaver;
import travelers.server.animal.entity.other.TravelersAnimalAnimationModule;
import travelers.server.animal.entity.other.TravelersBodyRotationControl;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.vanilla.EmptyMoveControl;
import travelers.server.animal.entity.pathingsystem.vanilla.EmptyNavigation;
import travelers.server.animal.entity.task.TravelerTaskController;
import travelers.server.animal.obj.IAnimalHolder;
import travelers.server.animal.obj.TravelersMoveAnalysis;
import travelers.server.entity.AnimalEntityPart;

public abstract class SmartAnimalBase
extends PathfinderMob
implements IAnimalHolder {
    protected final TravelersMoveAnalysis moveAnalysis;
    private final Map<TravelersPathType, Float> pathfindingMalus = Maps.newEnumMap(TravelersPathType.class);
    private final TravelersAnimal<?> animal;
    private final HashMap<String, AnimalEntityPart> subEntities = new HashMap();
    protected TravelersMoveControl moveController;
    protected TravelersPathNavigation navigationController;
    protected boolean freezeAnimator;
    private TravelerTaskController taskController;
    private TravelerTaskController combatController;
    private TravelersAnimalAnimationModule animationModule;
    private float previousYaw = 0.0f;
    private double curSpeed = 0.0;

    public SmartAnimalBase(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        ResourceLocation id = EntityType.getKey(entityType);
        this.animal = TravelersAnimalRegistry.getAnimalFromType(id.getNamespace(), entityType);
        if (this.animal == null) {
            throw new RuntimeException("No Animal Found for " + String.valueOf(entityType));
        }
        if (this.animal.getAnimalAttributes().getEntityAttributeProperties().isPersistent()) {
            this.setPersistenceRequired();
        }
        this.moveControl = new EmptyMoveControl((Mob)this);
        this.moveAnalysis = new TravelersMoveAnalysis(this, 2);
        this.navigationController = this.createNavigationController(level);
        if (!level.isClientSide) {
            this.addTasksToController(this.getTaskController(), this.getCombatTargeting());
        }
    }

    @NotNull
    protected BodyRotationControl createBodyControl() {
        return new TravelersBodyRotationControl(this);
    }

    public float getSpeed() {
        double speed = 0.0;
        double baseSpeed = this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getMovementSpeed();
        float scale = this.getScale();
        if (scale != 1.0f) {
            baseSpeed /= (double)scale;
        }
        float currentYaw = this.getYRot();
        float turningAmount = Math.abs(currentYaw - this.previousYaw);
        turningAmount = (turningAmount + 180.0f) % 360.0f - 180.0f;
        if ((turningAmount = Math.abs(turningAmount)) > 5.0f) {
            float turnSlowdown = Math.min(1.0f, turningAmount / 90.0f);
            baseSpeed *= (double)(1.0f - 0.3f * turnSlowdown);
        }
        if (this.isRunning()) {
            speed = Mth.lerp((double)0.1, (double)this.curSpeed, (double)(baseSpeed * this.animal.getAnimalAttributes().getEntityAttributeProperties().getRunningSpeedMultiplier()));
        } else if (this.isInWater()) {
            speed = Mth.lerp((double)0.1, (double)this.curSpeed, (double)(baseSpeed * this.animal.getAnimalAttributes().getEntityAttributeProperties().getSwimmingSpeedMultiplier()));
        } else if (this.getNavigationController().isInProgress()) {
            speed = Mth.lerp((double)0.1, (double)this.curSpeed, (double)baseSpeed);
        }
        this.previousYaw = currentYaw;
        this.curSpeed = speed;
        return (float)speed;
    }

    public boolean isRunning() {
        return !(!this.isAggressive() && !this.isPanicking() || this.isInWater() && !this.canRunInWater());
    }

    protected abstract boolean canRunInWater();

    protected abstract TravelersPathNavigation createNavigationController(Level var1);

    public float getWalkTargetValue(@NotNull BlockPos pos, @NotNull LevelReader level) {
        return this.isAnimal() ? (level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK) ? 10.0f : level.getPathfindingCostFromLightLevels(pos)) : super.getWalkTargetValue(pos, level);
    }

    public void addSubEntity(String string, AnimalEntityPart entityPart) {
        if (!(this instanceof IPartHaver)) {
            TravelersConstants.LOGGER.error("You added a subentity to an entity that doesn't implement IPartHaver<?>");
            return;
        }
        this.subEntities.put(string, entityPart);
    }

    public void setId(int id) {
        super.setId(id);
        if (this instanceof IPartHaver) {
            for (AnimalEntityPart value : this.subEntities.values()) {
                value.setId(++id);
            }
        }
    }

    public void tick() {
        super.tick();
        this.moveAnalysis.update();
        if (this.level().isClientSide) {
            this.clientTick();
        }
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
    }

    private void clientTick() {
        if (!this.freezeAnimator) {
            this.animal.animate(this, this.moveAnalysis, this.getAnimationModule());
        } else {
            this.freezeAnimator = false;
        }
        TravelersAnimationMap.tick(this);
    }

    public boolean isAnimal() {
        return false;
    }

    public final void setPathfindingMalus(@NotNull PathType pathType, float malus) {
    }

    public void setPathfindingMalus(TravelersPathType pathType, float malus) {
        this.pathfindingMalus.put(pathType, Float.valueOf(malus));
    }

    public float getPathfindingMalus(TravelersPathType pathType) {
        Float f = this.pathfindingMalus.get((Object)pathType);
        return f == null ? pathType.getMalus() : f.floatValue();
    }

    protected final void registerGoals() {
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        return new EmptyNavigation((Mob)this, this.level());
    }

    public void aiStep() {
        super.aiStep();
    }

    protected void customServerAiStep() {
        this.getTaskController().tickController();
        this.getCombatTargeting().tickController();
        if (this.moveController != null) {
            this.moveController.tick();
        }
        if (this.navigationController != null) {
            this.navigationController.tick();
        }
        if (!this.freezeAnimator) {
            this.animal.animateServer(this, this.moveAnalysis, this.getAnimationModule());
        } else {
            this.freezeAnimator = false;
        }
    }

    public void stopInPlace() {
        this.getNavigationController().stop();
        this.setXxa(0.0f);
        this.setYya(0.0f);
        this.setSpeed(0.0f);
    }

    public boolean avoidsLight() {
        return false;
    }

    public TravelerTaskController getTaskController() {
        if (this.taskController == null) {
            this.taskController = new TravelerTaskController();
        }
        return this.taskController;
    }

    public TravelerTaskController getCombatTargeting() {
        if (this.combatController == null) {
            this.combatController = new TravelerTaskController();
        }
        return this.combatController;
    }

    public double jumpHeight() {
        return this.maxUpStep();
    }

    public boolean canMove() {
        return true;
    }

    public boolean isAmphibian() {
        return false;
    }

    @Override
    public TravelersAnimal<?> getAnimal() {
        return this.animal;
    }

    public float getTurnMultiplier() {
        return 1.0f;
    }

    public float getScale() {
        return 1.0f;
    }

    public TravelersAnimalAnimationModule getAnimationModule() {
        if (this.animationModule == null) {
            this.animationModule = new TravelersAnimalAnimationModule(this);
        }
        return this.animationModule;
    }

    public float getRenderScale() {
        return (float)this.getAnimal().getAnimalAttributes().getEntityBaseProperties().getRenderScale();
    }

    public double climbHeight() {
        return 10.0;
    }

    public TravelersMoveAnalysis getMoveAnalysis() {
        return this.moveAnalysis;
    }

    public HashMap<String, AnimalEntityPart> getSubEntities() {
        return this.subEntities;
    }

    public TravelersMoveControl getMoveController() {
        return this.moveController;
    }

    public void setMoveController(TravelersMoveControl moveController) {
        this.moveController = moveController;
    }

    public TravelersPathNavigation getNavigationController() {
        return this.navigationController;
    }

    public void setNavigationController(TravelersPathNavigation navigationController) {
        this.navigationController = navigationController;
    }

    public void setFreezeAnimator(boolean freezeAnimator) {
        this.freezeAnimator = freezeAnimator;
    }
}

