/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.control;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.control.Control;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersMoveControl
implements Control {
    protected final float maxTurn;
    protected final float turnSmoothRate;
    protected final SmartAnimalBase mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected double speedModifier;
    protected Operation operation = Operation.WAIT;

    public TravelersMoveControl(SmartAnimalBase pMob, TravelersAnimal<?> animal) {
        this.mob = pMob;
        this.maxTurn = (float)animal.getAnimalAttributes().getEntityBaseProperties().getMaxTurnRate();
        this.turnSmoothRate = (float)animal.getAnimalAttributes().getEntityBaseProperties().getTurnSmoothRate();
    }

    public void setWantedPosition(double pX, double pY, double pZ, double pSpeed) {
        this.wantedX = pX;
        this.wantedY = pY;
        this.wantedZ = pZ;
        this.speedModifier = pSpeed;
        if (this.operation != Operation.JUMPING) {
            this.operation = Operation.MOVE_TO;
        }
    }

    public void tick() {
        switch (this.operation.ordinal()) {
            case 1: {
                this.handleMoveTo();
                break;
            }
            case 2: {
                this.handleJumping();
                break;
            }
            default: {
                this.mob.setZza(0.0f);
            }
        }
    }

    protected void handleMoveTo() {
        double dZ;
        double dY;
        this.operation = Operation.WAIT;
        double dX = this.wantedX - this.mob.getX();
        double distanceSquared = dX * dX + (dY = this.wantedY - this.mob.getY()) * dY + (dZ = this.wantedZ - this.mob.getZ()) * dZ;
        if (distanceSquared < 2.500000277905201E-7) {
            this.mob.setZza(0.0f);
            return;
        }
        float targetAngle = (float)(Mth.atan2((double)dZ, (double)dX) * 180.0 / Math.PI) - 90.0f;
        this.mob.setYRot(this.rotlerp(this.mob.getYRot(), targetAngle, this.getTurnSpeed()));
        this.mob.setSpeed((float)(this.speedModifier * (double)this.mob.getSpeed()));
        if (this.shouldJump(dY, dX, dZ)) {
            this.mob.getLookControl().setLookAt(this.wantedX, this.wantedY, this.wantedZ);
            this.mob.getJumpControl().jump();
            this.operation = Operation.JUMPING;
        }
    }

    protected void handleJumping() {
        if (this.mob.getLookControl().isLookingAtTarget()) {
            this.mob.setSpeed((float)(this.speedModifier * (double)this.mob.getSpeed()));
        }
        if (this.mob.onGround()) {
            this.operation = Operation.WAIT;
        }
    }

    protected boolean shouldJump(double dY, double dX, double dZ) {
        double distanceTo = this.mob.distanceToSqr(this.mob.getX() + dX, this.mob.getY(), this.mob.getZ() + dZ);
        if (distanceTo < (double)(this.mob.getBbWidth() * 1.1f)) {
            boolean collides;
            boolean bl = collides = !this.mob.level().noBlockCollision((Entity)this.mob, this.mob.getBoundingBox().expandTowards(0.0, dY, 0.0));
            if (collides) {
                return false;
            }
            return dY > (double)this.mob.maxUpStep() && dY <= this.mob.jumpHeight();
        }
        return false;
    }

    protected float rotlerp(float from, float to, float rate) {
        float delta = Mth.wrapDegrees((float)(to - from));
        return from + delta * Mth.clamp((float)rate, (float)0.0f, (float)1.0f);
    }

    protected float getTurnSpeed() {
        float TURN = this.maxTurn;
        float multiplier = this.mob.getTurnMultiplier();
        if (multiplier > 0.0f && multiplier != 1.0f) {
            TURN *= multiplier;
        }
        return TURN;
    }

    protected static enum Operation {
        WAIT,
        MOVE_TO,
        JUMPING;

    }
}

