/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.world;

import com.google.common.base.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import travelers.server.world.obj.BiomeHolder;
import travelers.util.helper.PlatformHelper;

public abstract class TravelersBiomeModifications {
    private final String modid;

    public TravelersBiomeModifications(String modID) {
        this.modid = modID;
    }

    public abstract void init();

    public boolean addSpawn(String spawnName, BiomeHolder holder, MobCategory mobCategory, Supplier<EntityType<? extends Entity>> entityType, int weight, int minGroupSize, int maxGroupSize) {
        if (mobCategory == MobCategory.MISC) {
            return false;
        }
        PlatformHelper.properties.getBiomeModificator().addSpawn(this.modid, spawnName, holder, mobCategory, entityType, weight, minGroupSize, maxGroupSize);
        return true;
    }

    public boolean addFeature(String featureName, BiomeHolder targetBiomes, ResourceKey<PlacedFeature> placedFeature, GenerationStep.Decoration generationStep) {
        PlatformHelper.properties.getBiomeModificator().addFeature(this.modid, featureName, targetBiomes, placedFeature, generationStep);
        return true;
    }
}

