/*
 * Decompiled with CFR 0.152.
 */
package travelers.world;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import travelers.server.world.TravelersBiomeModificator;
import travelers.server.world.obj.BiomeHolder;
import travelers.server.world.obj.TravelersFeatureModification;
import travelers.server.world.obj.TravelersSpawnModification;

public class NeoTravelersBiomeModificator
extends TravelersBiomeModificator {
    private static final HashMap<String, ArrayList<TravelersSpawnModification>> SPAWN_MODIFICATIONS = new HashMap();
    private static final HashMap<String, ArrayList<TravelersFeatureModification>> FEATURE_MODIFICATIONS = new HashMap();

    @Override
    public void addSpawn(String modid, String spawnName, BiomeHolder targetBiomes, MobCategory mobCategory, Supplier<EntityType<? extends Entity>> entityType, int weight, int minGroupSize, int maxGroupSize) {
        if (DatagenModLoader.isRunningDataGen()) {
            SPAWN_MODIFICATIONS.putIfAbsent(modid, new ArrayList());
            SPAWN_MODIFICATIONS.get(modid).add(new TravelersSpawnModification(targetBiomes, spawnName, mobCategory, entityType, weight, minGroupSize, maxGroupSize));
        }
    }

    @Override
    public void addFeature(String modid, String featureName, BiomeHolder targetBiomes, ResourceKey<PlacedFeature> placedFeature, GenerationStep.Decoration generationStep) {
        if (DatagenModLoader.isRunningDataGen()) {
            FEATURE_MODIFICATIONS.putIfAbsent(modid, new ArrayList());
            FEATURE_MODIFICATIONS.get(modid).add(new TravelersFeatureModification(targetBiomes, featureName, placedFeature, generationStep));
        }
    }

    public static void bootstrap(String modId, BootstrapContext<BiomeModifier> context) {
        ArrayList<TravelersFeatureModification> featureList;
        HolderGetter features = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        ArrayList<TravelersSpawnModification> spawnList = SPAWN_MODIFICATIONS.get(modId);
        if (spawnList != null) {
            for (TravelersSpawnModification modification : spawnList) {
                HolderSet biomeTags = NeoTravelersBiomeModificator.getTags((HolderGetter<Biome>)biomes, modification.targetBiomes());
                context.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)modification.name())), (Object)new BiomeModifiers.AddSpawnsBiomeModifier(biomeTags, Collections.singletonList(new MobSpawnSettings.SpawnerData((EntityType)modification.entityType().get(), modification.weight(), modification.minGroupSize(), modification.maxGroupSize()))));
            }
            SPAWN_MODIFICATIONS.remove(modId);
        }
        if ((featureList = FEATURE_MODIFICATIONS.get(modId)) != null) {
            for (TravelersFeatureModification modification : featureList) {
                HolderSet biomeTags = NeoTravelersBiomeModificator.getTags((HolderGetter<Biome>)biomes, modification.targetBiomes());
                context.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)modification.name())), (Object)new BiomeModifiers.AddFeaturesBiomeModifier(biomeTags, (HolderSet)Holder.direct((Object)features.getOrThrow(modification.placedFeature())), modification.generationStep()));
            }
            FEATURE_MODIFICATIONS.remove(modId);
        }
    }

    private static HolderSet getTags(HolderGetter<Biome> biomes, BiomeHolder biomeHolder) {
        HolderSet.Named biomeTags;
        if (biomeHolder.getBiomeTag() != null) {
            biomeTags = biomes.getOrThrow(biomeHolder.getBiomeTag());
        } else {
            ArrayList<Holder.Reference> holders = new ArrayList<Holder.Reference>();
            for (ResourceKey<Biome> biomeTag : biomeHolder.getBiomeTags()) {
                holders.add(biomes.getOrThrow(biomeTag));
            }
            biomeTags = HolderSet.direct(holders);
        }
        return biomeTags;
    }
}

