/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.client;

import banduty.stoneycore.event.custom.RenderOverlayAndAdditionsEvents;
import banduty.stoneycore.items.armor.SCAccessoryItem;
import banduty.stoneycore.util.DyeUtil;
import banduty.stoneycore.util.data.itemdata.INBTKeys;
import banduty.stoneycore.util.data.itemdata.SCTags;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.patterns.PatternHelper;
import banduty.stoneycore.util.render.SCRenderLayers;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.accessories.api.client.SimpleAccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class SCAccessoryItemRenderer
implements SimpleAccessoryRenderer {
    private static final class_4668.class_5942 RENDER_TYPE_ENTITY_TRANSLUCENT_EMISSIVE_SHADER = new class_4668.class_5942(class_757::method_42595);
    private static final class_4668.class_4685 TRANSLUCENT_TRANSPARENCY = new class_4668.class_4685("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final class_4668.class_4686 COLOR_MASK = new class_4668.class_4686(true, true);
    private static final Function<class_2960, class_1921> RENDER_TYPE_FUNCTION = class_156.method_34866(texture -> {
        class_4668.class_4683 textureState = new class_4668.class_4683(texture, false, false);
        return class_1921.method_24049((String)"sc_glowing_layer", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(RENDER_TYPE_ENTITY_TRANSLUCENT_EMISSIVE_SHADER).method_34577((class_4668.class_5939)textureState).method_23615(TRANSLUCENT_TRANSPARENCY).method_23616(COLOR_MASK).method_23617(false));
    });

    public <M extends class_1309> void render(class_1799 stack, SlotReference reference, class_4587 matrices, class_583<M> model, class_4597 multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof SCAccessoryItem)) {
            return;
        }
        SCAccessoryItem scAccessoryItem = (SCAccessoryItem)class_17922;
        Optional<class_572<class_1309>> optionalModel = scAccessoryItem.getModels(stack).base();
        if (NBTDataHelper.get(stack, INBTKeys.VISOR_OPEN, Boolean.valueOf(false)).booleanValue()) {
            optionalModel = scAccessoryItem.getModels(stack).visorOpen();
        }
        if (optionalModel.isEmpty()) {
            return;
        }
        class_572<class_1309> accessoryModel = optionalModel.get();
        if (model instanceof class_572) {
            class_572 bipedEntityModel = (class_572)model;
            bipedEntityModel.method_2818(accessoryModel);
        }
        if (scAccessoryItem.getRenderSettings(stack).customAngles()) {
            accessoryModel.method_17087(reference.entity(), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        class_4588 baseConsumer = multiBufferSource.getBuffer(class_1921.method_25448((class_2960)scAccessoryItem.getTexturePath(stack)));
        float[] color = DyeUtil.getFloatDyeColor(stack);
        accessoryModel.method_2828(matrices, baseConsumer, light, class_4608.field_21444, color[0], color[1], color[2], 1.0f);
        this.renderEmissiveTexture(scAccessoryItem, stack, matrices, multiBufferSource, accessoryModel, color);
        this.renderOverlayAndAdditions(reference.entity(), stack, matrices, multiBufferSource, light, accessoryModel);
        if (stack.method_31573(SCTags.BANNER_COMPATIBLE.getTag())) {
            this.renderBannerPatterns(stack, matrices, multiBufferSource, light, accessoryModel);
        }
    }

    private void renderEmissiveTexture(SCAccessoryItem scAccessoryItem, class_1799 stack, class_4587 matrices, class_4597 multiBufferSource, class_572<class_1309> model, float[] color) {
        Optional<class_2960> emissiveTexture;
        if (scAccessoryItem.getEmissiveTexturePath(stack).isPresent() && (emissiveTexture = scAccessoryItem.getEmissiveTexturePath(stack)).isPresent()) {
            class_4588 emissiveConsumer = multiBufferSource.getBuffer(RENDER_TYPE_FUNCTION.apply(emissiveTexture.get()));
            model.method_2828(matrices, emissiveConsumer, 0xF00000, class_4608.field_21444, color[0], color[1], color[2], 1.0f);
        }
    }

    private void renderOverlayAndAdditions(class_1309 entity, class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, class_572<class_1309> model) {
        ((RenderOverlayAndAdditionsEvents)RenderOverlayAndAdditionsEvents.EVENT.invoker()).onRenderOverlayAndAdditionsEvents(entity, stack, matrices, vertexConsumers, light, model);
    }

    @Environment(value=EnvType.CLIENT)
    private void renderBannerPatterns(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, class_572<class_1309> model) {
        List<class_3545<class_2960, class_1767>> bannerPatterns = PatternHelper.getBannerPatterns(stack);
        if (!bannerPatterns.isEmpty()) {
            for (class_3545<class_2960, class_1767> patternPair : bannerPatterns) {
                class_2960 pattern = (class_2960)patternPair.method_15442();
                class_1767 dyeColor = (class_1767)patternPair.method_15441();
                float[] rgb = dyeColor.method_7787();
                class_4588 patternConsumer = vertexConsumers.getBuffer(SCRenderLayers.getArmorTranslucentNoCull(pattern));
                model.method_2828(matrices, patternConsumer, light, class_4608.field_21444, rgb[0], rgb[1], rgb[2], 1.0f);
            }
        }
    }

    public <M extends class_1309> void align(class_1799 itemStack, SlotReference slotReference, class_583<M> entityModel, class_4587 matrixStack) {
    }
}

