/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.config;

import blue.endless.jankson.Comment;
import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.Config;
import io.wispforest.owo.config.annotation.Modmenu;
import io.wispforest.owo.config.annotation.Nest;
import io.wispforest.owo.config.annotation.RangeConstraint;
import io.wispforest.owo.config.annotation.SectionHeader;
import io.wispforest.owo.config.annotation.Sync;

@Modmenu(modId="stoneycore")
@Config(name="stoneycore", wrapperName="StoneyCoreConfig")
public class SCConfigs {
    @Nest
    @SectionHeader(value="combatOptions")
    public CombatOptions combatOptions = new CombatOptions();
    @Nest
    @SectionHeader(value="visualOptions")
    public VisualOptions visualOptions = new VisualOptions();
    @Nest
    @SectionHeader(value="technicalOptions")
    public TechnicalOptions technicalOptions = new TechnicalOptions();
    @Nest
    @SectionHeader(value="landOptions")
    public LandOptions landOptions = new LandOptions();

    public static class CombatOptions {
        @Comment(value="Realistic Combat")
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        public boolean getRealisticCombat = true;
        @Comment(value="Time (In Ticks) to Toggle Visor")
        @RangeConstraint(min=0.0, max=99999.0)
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        public int getToggleVisorTime = 10;
        @Comment(value="Parry")
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        public boolean getParry = true;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Max Base Stamina (0 or less disables)")
        public float maxBaseStamina = 20.0f;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Stamina Recovery Formula")
        public String staminaRecoveryFormula = "10 - (foodLevel + health) / 5";
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Blocking Stamina Constant")
        public double blockingStaminaConstant = 0.01;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="On Block Stamina Constant")
        public double onBlockStaminaConstant = 0.03;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="On Parry Stamina Constant")
        public double onParryStaminaConstant = 0.025;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Sprinting Stamina Constant")
        public double sprintingStaminaConstant = 0.04;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Jumping Stamina Constant")
        public double jumpingStaminaConstant = 0.01;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Swimming Stamina Constant")
        public double swimmingStaminaConstant = 0.02;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Attack Stamina Constant")
        public double attackStaminaConstant = 0.02;
        @Comment(value="Stamina Time to Replenish after Using")
        @RangeConstraint(min=0.0, max=99999.0)
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        public int getStaminaRecoverTime = 60;
    }

    public static class VisualOptions {
        @Comment(value="Damage Indicator")
        public boolean getDamageIndicator = false;
        @Comment(value="Visored Helmet Overlay")
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        public boolean getVisoredHelmet = true;
        @Comment(value="Visored Helmet Overlay Alpha in Creative")
        @RangeConstraint(min=0.0, max=1.0)
        public float getVisoredHelmetAlpha = 0.4f;
        @Comment(value="Low Stamina Indicator")
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        public boolean getLowStaminaIndicator = true;
        @Comment(value="Noise Effect in Low Stamina Indicator")
        public boolean getNoiseEffect = true;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Muzzles Smoke Particles Time Active (In Seconds)")
        public int getMuzzlesSmokeParticlesTime = 60;
        @Comment(value="Stamina Bar Y Offset")
        @Sync(value=Option.SyncMode.NONE)
        public int getStaminaBarYOffset = 0;
        @Sync(value=Option.SyncMode.NONE)
        @Comment(value="Hex Color Too/Far Close")
        public int hexColorTooFarClose = 0xFFFFFF;
        @Sync(value=Option.SyncMode.NONE)
        @Comment(value="Hex Color Effective")
        public int hexColorEffective = 13352291;
        @Sync(value=Option.SyncMode.NONE)
        @Comment(value="Hex Color Critical")
        public int hexColorCritical = 0xFF4949;
        @Sync(value=Option.SyncMode.NONE)
        @Comment(value="Hex Color Maximum")
        public int hexColorMaximum = 0xFFFFFF;
        @Sync(value=Option.SyncMode.NONE)
        @Comment(value="Player waves arms when in land under siege and not participant")
        public boolean armWave = true;
        @Sync(value=Option.SyncMode.NONE)
        @Comment(value="Claim Outline Render Hex Color")
        public int claimOutlineColor = 0xFFFF80;
    }

    public static class TechnicalOptions {
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Max Work for Claim Worker per tick\nLower numbers will make the claim slower,\nbut it will \"increase\" the performance.\n")
        public int maxWorkPerTick = 5000;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Max Land Expand Radius")
        public int maxLandExpandRadius = -1;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Break or Remove Blocks on destroy with siege engines\nBreak = False\nRemove = True\n")
        public boolean breakOrRemoveSiegeDestroy = false;
    }

    public static class LandOptions {
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Remove radius claim on defender death")
        public boolean removeClaimedSiege = true;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        @Comment(value="Hunger inside a Siege")
        public boolean hungerSiege = true;
    }
}

