/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.event;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.lands.LandType;
import banduty.stoneycore.lands.LandTypeRegistry;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandManager;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.siege.SiegeManager;
import java.util.Optional;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1807;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3965;

public class UseBlockHandler
implements UseBlockCallback {
    public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        Land land;
        if (!(world instanceof class_3218)) {
            return class_1269.field_5811;
        }
        class_3218 serverWorld = (class_3218)world;
        if (serverWorld.method_27983() == class_1937.field_25180) {
            return class_1269.field_5811;
        }
        class_2338 blockPos = hit.method_17777();
        class_2680 state = serverWorld.method_8320(blockPos);
        LandState stateManager = LandState.get(serverWorld);
        boolean claimed = stateManager.isClaimed(blockPos);
        Optional<Land> maybeLand = stateManager.getLandAt(blockPos);
        boolean isCoreBlock = LandTypeRegistry.getAll().stream().anyMatch(type -> type.coreBlock() == state.method_26204());
        if (SiegeManager.isPlayerInLandUnderSiege(serverWorld, player) && !SiegeManager.getPlayerSiege(serverWorld, player.method_5667()).map(siege -> !siege.disabledPlayers.contains(player.method_5667())).orElse(false).booleanValue() && !isCoreBlock) {
            return class_1269.field_5814;
        }
        if (maybeLand.isPresent() && !maybeLand.get().getOwnerUUID().equals(player.method_5667()) && !maybeLand.get().isAlly(player.method_5667()) && !player.method_7337()) {
            if (state.method_26204().method_9564().method_31709()) {
                return class_1269.field_5811;
            }
            return class_1269.field_5814;
        }
        if (!isCoreBlock) {
            return class_1269.field_5811;
        }
        if (maybeLand.isPresent() && (land = maybeLand.get()).getOwnerUUID().equals(player.method_5667()) && (SiegeManager.isLandDefenseSiege(serverWorld, land) || SiegeManager.isLandAttackingSiege(serverWorld, land)) && player.method_6047().method_31574(class_1802.field_8539)) {
            return SiegeManager.surrender(serverWorld, player, land);
        }
        Optional<LandType> landTypeOpt = LandTypeRegistry.getByBlock(state.method_26204());
        if (!claimed && player.method_6047().method_31573(class_3489.field_15556)) {
            if (landTypeOpt.isEmpty()) {
                throw new IllegalArgumentException("LandType is empty");
            }
            return LandManager.createLand((class_3222)player, blockPos, landTypeOpt.get());
        }
        if (maybeLand.isEmpty() || !maybeLand.get().getOwnerUUID().equals(player.method_5667()) || !player.method_6118(class_1304.field_6169).method_31574(maybeLand.get().getLandType().coreItem())) {
            return class_1269.field_5811;
        }
        Land land2 = maybeLand.get();
        if (landTypeOpt.isPresent()) {
            long saved;
            double maxAllowedRadius;
            if (player.method_5998(hand).method_7909() instanceof class_1807) {
                land2.setName(player.method_5998(hand).method_7964().getString());
                player.method_7353((class_2561)class_2561.method_43470((String)land2.getName()), true);
                player.method_5998(hand).method_7934(1);
                return class_1269.field_5811;
            }
            int available = this.countItem(player, landTypeOpt.get());
            long needed = land2.getNeededExpandItemAmount();
            int maxRadius = StoneyCore.getConfig().technicalOptions.maxLandExpandRadius();
            double d = maxAllowedRadius = maxRadius < 0 ? Double.MAX_VALUE : (double)(maxRadius + land2.getLandType().baseRadius());
            if ((double)land2.getRadius() >= maxAllowedRadius) {
                player.method_7353((class_2561)class_2561.method_43471((String)("text.land." + landTypeOpt.get().id().method_12836() + ".at_max_radius")), true);
                return class_1269.field_5811;
            }
            if (available <= 0 && (saved = land2.getExpandItemStored()) < needed) {
                player.method_7353((class_2561)class_2561.method_43469((String)("text.land." + landTypeOpt.get().id().method_12836() + ".stored_needed"), (Object[])new Object[]{saved, needed}), true);
                return class_1269.field_5811;
            }
            this.removeItems(player, available, landTypeOpt.get());
            land2.depositExpandItem(player, serverWorld, available);
        }
        return class_1269.field_5811;
    }

    private int countItem(class_1657 player, LandType landType) {
        int total = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            class_1792 item = stack.method_7909();
            Integer value = landType.itemsToExpand().get(item);
            if (value == null) continue;
            total += stack.method_7947() * value;
        }
        return total;
    }

    private void removeItems(class_1657 player, long amountNeeded, LandType landType) {
        for (class_1799 stack : player.method_31548().field_7547) {
            if (amountNeeded <= 0L) break;
            class_1792 item = stack.method_7909();
            Integer value = landType.itemsToExpand().get(item);
            if (value == null || value <= 0) continue;
            int count = stack.method_7947();
            int maxUsable = (int)Math.min((double)count, Math.ceil((double)amountNeeded / (double)value.intValue()));
            stack.method_7934(maxUsable);
            amountNeeded -= (long)maxUsable * (long)value.intValue();
        }
    }
}

