/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.lands;

import banduty.stoneycore.lands.LandType;
import banduty.stoneycore.util.definitionsloader.LandDefinitionsLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;

public class LandTypeRegistry {
    private static final Map<class_2960, LandType> TYPES = new LinkedHashMap<class_2960, LandType>();
    private static final Map<class_2960, LandDefinitionsLoader.LandValues> OVERRIDES = new HashMap<class_2960, LandDefinitionsLoader.LandValues>();

    public static LandType register(class_2960 id, class_2248 coreBlock, class_1792 coreItem, int baseRadius, Map<class_1792, Integer> itemsToExpand, String expandFormula, LandType.TerrainType terrainType, int maxAllies) {
        if (TYPES.containsKey(id)) {
            throw new IllegalArgumentException("LandType with id " + String.valueOf(id) + " is already registered!");
        }
        boolean blockAlreadyUsed = TYPES.values().stream().anyMatch(type -> type.coreBlock() == coreBlock);
        if (blockAlreadyUsed) {
            throw new IllegalArgumentException("A LandType with core block " + String.valueOf(coreBlock) + " is already registered!");
        }
        LandType type2 = new LandType(id, coreBlock, coreItem, baseRadius, itemsToExpand, expandFormula, terrainType, maxAllies);
        TYPES.put(id, type2);
        return type2;
    }

    public static void applyOverride(class_2960 id, LandDefinitionsLoader.LandValues values) {
        OVERRIDES.put(id, values);
    }

    public static void clearOverrides() {
        OVERRIDES.clear();
    }

    public static Optional<LandType> getById(class_2960 id) {
        LandType type = TYPES.get(id);
        if (type == null) {
            return Optional.empty();
        }
        LandDefinitionsLoader.LandValues override = OVERRIDES.get(id);
        if (override != null) {
            return Optional.of(new LandType(type.id(), type.coreBlock(), type.coreItem(), override.baseRadius() <= 0 ? type.baseRadius() : override.baseRadius(), override.itemsToExpand().isEmpty() ? type.itemsToExpand() : override.itemsToExpand(), override.expandFormula().isEmpty() ? type.expandFormula() : override.expandFormula(), type.terrainType(), override.maxAllies()));
        }
        return Optional.of(type);
    }

    public static Optional<LandType> getByBlock(class_2248 block) {
        return TYPES.values().stream().filter(type -> type.coreBlock() == block).findFirst().flatMap(type -> LandTypeRegistry.getById(type.id()));
    }

    public static Collection<LandType> getAll() {
        return TYPES.keySet().stream().map(id -> LandTypeRegistry.getById(id).orElse(null)).filter(Objects::nonNull).toList();
    }
}

