/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.mixin;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.util.SCDamageCalculator;
import banduty.stoneycore.util.data.itemdata.INBTKeys;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.data.playerdata.IEntityDataSaver;
import banduty.stoneycore.util.data.playerdata.StaminaData;
import banduty.stoneycore.util.definitionsloader.ArmorDefinitionsLoader;
import banduty.stoneycore.util.definitionsloader.WeaponDefinitionsLoader;
import banduty.stoneycore.util.render.TextureData;
import banduty.stoneycore.util.weaponutil.SCWeaponUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.bettercombat.logic.PlayerAttackProperties;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public class InGameHudMixin {
    @Unique
    private static final class_2960 TOO_FAR_CLOSE = new class_2960("stoneycore", "textures/overlay/too_far_close.png");
    @Unique
    private static final class_2960 STAMINA = new class_2960("stoneycore", "textures/overlay/stamina_bar.png");
    @Unique
    private static final class_2960 STAMINA_OVERLAY = new class_2960("stoneycore", "textures/overlay/stamina_bar_overlay.png");
    @Unique
    private static final class_2960 STAMINA_EMPTY = new class_2960("stoneycore", "textures/overlay/stamina_bar_empty.png");
    @Unique
    private static final class_2960 STAMINA_BLOCKED = new class_2960("stoneycore", "textures/overlay/stamina_bar_blocked.png");
    @Unique
    private static final int STAMINA_UNIT_SIZE = 8;
    @Unique
    private static final int EMPTY_STAMINA_WIDTH = 9;
    @Unique
    private static final int EMPTY_STAMINA_HEIGHT = 9;
    @Unique
    private static final int STAMINA_BAR_WIDTH = 9;
    @Unique
    private static final int STAMINA_BAR_HEIGHT = 9;

    @Inject(method={"renderCrosshair"}, at={@At(value="HEAD")}, cancellable=true)
    private void stoneycore$renderCrosshair(class_332 context, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null || player.method_37908() == null) {
            return;
        }
        class_1799 mainHandStack = player.method_6047();
        class_1792 item = mainHandStack.method_7909();
        if (!WeaponDefinitionsLoader.isMelee(item)) {
            return;
        }
        class_243 playerPos = player.method_19538();
        double distance = client.field_1692 == null ? 9999.0 : playerPos.method_1022(client.field_1692.method_19538());
        WeaponDefinitionsLoader.DefinitionData weaponData = WeaponDefinitionsLoader.getData(item);
        SCDamageCalculator.DamageType damageType = this.determineDamageType(mainHandStack, weaponData, (PlayerAttackProperties)player);
        this.renderCrosshair(item, context, distance, damageType);
        ci.cancel();
    }

    @Unique
    private SCDamageCalculator.DamageType determineDamageType(class_1799 mainHandStack, WeaponDefinitionsLoader.DefinitionData weaponData, PlayerAttackProperties player) {
        class_1792 item = mainHandStack.method_7909();
        boolean isBludgeoning = NBTDataHelper.get(mainHandStack, INBTKeys.BLUDGEONING, Boolean.valueOf(false));
        boolean isPiercing = InGameHudMixin.isPiercing(player, item);
        boolean bludgeoningToPiercing = SCWeaponUtil.getDamageValues(SCDamageCalculator.DamageType.SLASHING, item) == 0.0 && SCWeaponUtil.getDamageValues(SCDamageCalculator.DamageType.PIERCING, item) > 0.0 && SCWeaponUtil.getDamageValues(SCDamageCalculator.DamageType.BLUDGEONING, item) > 0.0;
        SCDamageCalculator.DamageType onlyType = weaponData.melee().onlyDamageType();
        if (isBludgeoning || onlyType == SCDamageCalculator.DamageType.BLUDGEONING) {
            return SCDamageCalculator.DamageType.BLUDGEONING;
        }
        if (isPiercing || bludgeoningToPiercing || onlyType == SCDamageCalculator.DamageType.PIERCING) {
            return SCDamageCalculator.DamageType.PIERCING;
        }
        return SCDamageCalculator.DamageType.SLASHING;
    }

    @Unique
    private static boolean isPiercing(PlayerAttackProperties player, class_1792 item) {
        int comboCount = player.getComboCount();
        WeaponDefinitionsLoader.DefinitionData attributeData = WeaponDefinitionsLoader.getData(item);
        int[] piercingAnimations = attributeData.melee().piercingAnimation();
        int animation = attributeData.melee().animation();
        if (animation > 0) {
            for (int piercingAnimation : piercingAnimations) {
                if (comboCount % animation != piercingAnimation - 1) continue;
                return true;
            }
            return piercingAnimations.length == animation;
        }
        return false;
    }

    @Unique
    private void renderCrosshair(class_1792 item, class_332 context, double distance, SCDamageCalculator.DamageType damageType) {
        class_310 client = class_310.method_1551();
        int centerX = client.method_22683().method_4486() / 2;
        int centerY = client.method_22683().method_4502() / 2;
        class_2960[] textures = new class_2960[]{TOO_FAR_CLOSE, InGameHudMixin.getCrosshair(damageType, "effective"), InGameHudMixin.getCrosshair(damageType, "critical"), InGameHudMixin.getCrosshair(damageType, "effective"), InGameHudMixin.getCrosshair(damageType, "maximum")};
        for (int i = 0; i < textures.length; ++i) {
            double radius = SCWeaponUtil.getRadius(item, i) + 0.25;
            if (!(distance <= radius)) continue;
            this.renderCrosshairTexture(context, textures[i], centerX, centerY, this.getColorForIndex(i));
            return;
        }
        this.renderCrosshairTexture(context, TOO_FAR_CLOSE, centerX, centerY, StoneyCore.getConfig().visualOptions.hexColorTooFarClose());
    }

    @Unique
    private void renderCrosshairTexture(class_332 ctx, class_2960 tex, int centerX, int centerY, int hexColor) {
        TextureData texData = this.getTextureData(tex);
        float[] rgb = this.hexToRGB(hexColor);
        RenderSystem.setShaderTexture((int)0, (class_2960)tex);
        RenderSystem.setShaderColor((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)1.0f);
        ctx.method_25290(tex, centerX - texData.offsetX(), centerY - texData.offsetY(), 0.0f, 0.0f, texData.width(), texData.height(), texData.width(), texData.height());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Unique
    private int getColorForIndex(int i) {
        return switch (i) {
            case 0 -> StoneyCore.getConfig().visualOptions.hexColorTooFarClose();
            case 1, 3 -> StoneyCore.getConfig().visualOptions.hexColorEffective();
            case 2 -> StoneyCore.getConfig().visualOptions.hexColorCritical();
            case 4 -> StoneyCore.getConfig().visualOptions.hexColorMaximum();
            default -> 0xFFFFFF;
        };
    }

    @Unique
    private float[] hexToRGB(int hex) {
        return new float[]{(float)(hex >> 16 & 0xFF) / 255.0f, (float)(hex >> 8 & 0xFF) / 255.0f, (float)(hex & 0xFF) / 255.0f};
    }

    @Unique
    private static class_2960 getCrosshair(SCDamageCalculator.DamageType damageType, String crosshairType) {
        return new class_2960("stoneycore", "textures/overlay/" + damageType.name().toLowerCase() + "_" + crosshairType + ".png");
    }

    @Unique
    private TextureData getTextureData(class_2960 texture) {
        String path = texture.method_12832();
        if (path.contains("critical") || path.contains("effective")) {
            return new TextureData(9, 9, 5, 5);
        }
        if (path.contains("maximum")) {
            return new TextureData(7, 7, 4, 4);
        }
        return new TextureData(1, 1, 1, 1);
    }

    @Inject(method={"renderStatusBars"}, at={@At(value="HEAD")})
    private void stoneycore$renderStaminaBar(class_332 context, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null || player.method_7325() || !this.ableStaminaOverlay((class_1657)player)) {
            return;
        }
        double maxStamina = player.method_26825((class_1320)StoneyCore.MAX_STAMINA.get());
        if (maxStamina <= 0.0) {
            return;
        }
        int staminaBarX = client.method_22683().method_4486() / 2;
        int staminaBarY = this.getStaminaBarYPosition(player);
        double stamina = StaminaData.getStamina((class_1309)player);
        boolean isStaminaBlocked = StaminaData.isStaminaBlocked((IEntityDataSaver)player);
        this.renderStaminaBar(context, staminaBarX, staminaBarY, stamina, isStaminaBlocked);
    }

    @Unique
    private boolean ableStaminaOverlay(class_1657 player) {
        if (player == null) {
            return false;
        }
        boolean hasSCWeapon = WeaponDefinitionsLoader.isMelee(player.method_6047());
        for (class_1799 stack : player.method_5661()) {
            if (!ArmorDefinitionsLoader.containsItem(stack.method_7909())) continue;
            return true;
        }
        return hasSCWeapon;
    }

    @Unique
    private int getStaminaBarYPosition(class_746 player) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return 0;
        }
        int windowHeight = client.method_22683().method_4502();
        return player.method_5669() < player.method_5748() ? windowHeight - 59 : windowHeight - 49;
    }

    @Unique
    private void renderStaminaBar(class_332 drawContext, int staminaBarX, int staminaBarY, double stamina, boolean isStaminaBlocked) {
        int yOffset = StoneyCore.getConfig().visualOptions.getStaminaBarYOffset();
        int baseY = staminaBarY - yOffset;
        for (int i = 0; i < 10; ++i) {
            int x = staminaBarX + 82 - i * 8;
            this.renderStaminaUnit(drawContext, x, baseY, STAMINA_EMPTY, 9, 9);
        }
        float[][] rowColors = new float[][]{{1.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.5f, 1.0f}, {1.0f, 0.0f, 1.0f}, {1.0f, 0.5f, 0.0f}, {0.5f, 0.0f, 0.5f}, {1.0f, 1.0f, 1.0f}};
        int maxUnitsPerRow = 10;
        int rows = (int)Math.ceil(stamina / 2.0 / (double)maxUnitsPerRow);
        for (int row = 0; row < rows; ++row) {
            int unitIndex;
            float[] color = rowColors[Math.min(row, rowColors.length - 1)];
            for (int i = 0; i < maxUnitsPerRow && !((double)(unitIndex = (row * maxUnitsPerRow + i) * 2) >= stamina); ++i) {
                if (!isStaminaBlocked) {
                    drawContext.method_51422(color[0], color[1], color[2], 1.0f);
                }
                int x = staminaBarX + 82 - i * 8;
                class_2960 texture = isStaminaBlocked ? STAMINA_BLOCKED : STAMINA;
                RenderSystem.setShaderTexture((int)0, (class_2960)texture);
                this.renderStaminaUnit(drawContext, x, baseY, texture, 9, 9);
                drawContext.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                if (isStaminaBlocked) continue;
                this.renderStaminaUnit(drawContext, x, baseY, STAMINA_OVERLAY, 9, 9);
            }
        }
    }

    @Unique
    private void renderStaminaUnit(class_332 drawContext, int x, int y, class_2960 texture, int width, int height) {
        drawContext.method_25290(texture, x, y, 0.0f, 0.0f, width, height, width, height);
    }
}

