/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.mixin;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.event.custom.PlayerNameTagEvents;
import banduty.stoneycore.util.EntityDamageUtil;
import banduty.stoneycore.util.WeightUtil;
import banduty.stoneycore.util.data.itemdata.SCTags;
import banduty.stoneycore.util.data.playerdata.StaminaData;
import banduty.stoneycore.util.definitionsloader.WeaponDefinitionsLoader;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin {
    @Unique
    private final class_1657 playerEntity = (class_1657)this;
    @Unique
    private static final float SHIELD_DISABLE_CHANCE_BASE = 0.25f;
    @Unique
    private static final float SHIELD_DISABLE_CHANCE_SPRINT_BONUS = 0.75f;
    @Unique
    private static final int SHIELD_COOLDOWN_TICKS = 100;
    @Unique
    private static final int VANILLA_SHIELD_COOLDOWN_TICKS = 60;

    @ModifyArg(method={"getDisplayName"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Team;decorateName(Lnet/minecraft/scoreboard/AbstractTeam;Lnet/minecraft/text/Text;)Lnet/minecraft/text/MutableText;"))
    private class_2561 stoneycore$addTags(class_2561 baseName) {
        class_1657 class_16572 = this.playerEntity;
        if (!(class_16572 instanceof class_3222)) {
            return baseName;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        List<PlayerNameTagEvents.TagEntry> tags = ((PlayerNameTagEvents)PlayerNameTagEvents.EVENT.invoker()).collectTags(serverPlayer);
        class_5250 result = class_2561.method_43473();
        for (PlayerNameTagEvents.TagEntry entry : tags) {
            if (entry.text().getString().isEmpty()) continue;
            result = result.method_10852(entry.text()).method_10852((class_2561)class_2561.method_43470((String)" "));
        }
        return result.method_10852(baseName);
    }

    @Inject(method={"damageShield"}, at={@At(value="HEAD")}, cancellable=true)
    private void stoneycore$onDamageShield(float amount, CallbackInfo ci) {
        if (this.playerEntity.method_37908().method_8608()) {
            return;
        }
        if (this.playerEntity.method_6030().method_31573(SCTags.WEAPONS_SHIELD.getTag())) {
            int i = 1 + class_3532.method_15375((float)amount);
            this.playerEntity.method_6030().method_7956(i, (class_1309)this.playerEntity, player -> player.method_20236(this.playerEntity.method_6058()));
            this.playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this.playerEntity.method_6030().method_7909()));
            ci.cancel();
            StaminaData.removeStamina((class_1309)this.playerEntity, StoneyCore.getConfig().combatOptions.onBlockStaminaConstant() * WeightUtil.getCachedWeight((class_1309)this.playerEntity));
        }
    }

    @Inject(method={"disableShield"}, at={@At(value="HEAD")}, cancellable=true)
    public void stoneycore$disableShield(boolean sprinting, CallbackInfo ci) {
        class_1799 activeItem = this.playerEntity.method_6030();
        class_1937 world = this.playerEntity.method_37908();
        float disableChance = 0.25f + (float)class_1890.method_8234((class_1309)this.playerEntity) * 0.05f;
        if (sprinting) {
            disableChance += 0.75f;
        }
        if (this.playerEntity.method_6051().method_43057() < disableChance) {
            if (!this.playerEntity.method_7337()) {
                int cooldownTicks = activeItem.method_31573(SCTags.WEAPONS_SHIELD.getTag()) ? 100 : 60;
                this.playerEntity.method_7357().method_7906(activeItem.method_7909(), cooldownTicks);
            }
            this.playerEntity.method_6021();
            world.method_8421((class_1297)this.playerEntity, (byte)30);
            ci.cancel();
        }
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE", ordinal=0), ordinal=0)
    private float stoneycore$modifyDamage(float f, class_1297 target) {
        class_1309 living;
        if (!(target instanceof class_1309) || (living = (class_1309)target).method_37908().method_8608()) {
            return f;
        }
        class_1799 weaponStack = EntityDamageUtil.getWeaponStack((class_1297)this.playerEntity);
        if (!WeaponDefinitionsLoader.isMelee(weaponStack)) {
            return f;
        }
        float weaponDamage = 0.0f;
        class_1792 class_17922 = weaponStack.method_7909();
        if (class_17922 instanceof class_1829) {
            class_1829 swordItem = (class_1829)class_17922;
            weaponDamage = swordItem.method_8020();
        } else {
            class_17922 = weaponStack.method_7909();
            if (class_17922 instanceof class_1766) {
                class_1766 miningToolItem = (class_1766)class_17922;
                weaponDamage = miningToolItem.method_26366();
            }
        }
        double extra = EntityDamageUtil.onDamage(living, (class_1309)this.playerEntity, weaponStack);
        return f + (float)extra - weaponDamage - 1.0f;
    }
}

