/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.definitionsloader;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.util.SCDamageCalculator;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3414;
import net.minecraft.class_3695;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class WeaponDefinitionsLoader
implements IdentifiableResourceReloadListener {
    private static final Map<class_2960, DefinitionData> DEFINITIONS = new ConcurrentHashMap<class_2960, DefinitionData>();
    private static final class_2960 RELOAD_LISTENER_ID = new class_2960("stoneycore", "weapon_definitions_loader");

    public class_2960 getFabricId() {
        return RELOAD_LISTENER_ID;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 resourceManager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {
            DEFINITIONS.clear();
            Map resources = resourceManager.method_14488("definitions/weapon", id -> id.method_12832().endsWith(".json"));
            resources.forEach((id, resource) -> {
                try (InputStream stream = resource.method_14482();){
                    JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(stream));
                    DataResult result = WeaponDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                    result.resultOrPartial(arg_0 -> ((Logger)StoneyCore.LOGGER).error(arg_0)).ifPresent(weaponDef -> {
                        class_2960 weaponId = class_2960.method_43902((String)id.method_12836(), (String)id.method_12832().substring("definitions/weapon/".length(), id.method_12832().length() - 5));
                        EnumSet<Usage> usage = EnumSet.noneOf(Usage.class);
                        MeleeData meleeData = null;
                        RangedData rangedData = null;
                        AmmoData ammoData = null;
                        if (weaponDef.melee != null) {
                            usage.add(Usage.MELEE);
                            meleeData = weaponDef.melee;
                        }
                        if (weaponDef.ranged != null) {
                            usage.add(Usage.RANGED);
                            rangedData = weaponDef.ranged;
                        }
                        if (weaponDef.ammo != null) {
                            usage.add(Usage.AMMO);
                            ammoData = weaponDef.ammo;
                        }
                        DEFINITIONS.put(weaponId, new DefinitionData(usage, meleeData, rangedData, ammoData));
                    });
                }
                catch (Exception e) {
                    StoneyCore.LOGGER.error("Failed to load definitions data from {}: {}", new Object[]{id, e.getMessage(), e});
                }
            });
        }, prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenRunAsync(() -> {}, applyExecutor);
    }

    public static DefinitionData getData(class_1799 stack) {
        if (stack == null) {
            stack = class_1799.field_8037;
        }
        return WeaponDefinitionsLoader.getData(stack.method_7909());
    }

    public static DefinitionData getData(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return DEFINITIONS.getOrDefault(id, new DefinitionData(EnumSet.noneOf(Usage.class), null, null, null));
    }

    public static boolean containsItem(class_1799 stack) {
        if (stack == null) {
            stack = class_1799.field_8037;
        }
        return WeaponDefinitionsLoader.containsItem(stack.method_7909());
    }

    public static boolean containsItem(class_1792 item) {
        return DEFINITIONS.containsKey(class_7923.field_41178.method_10221((Object)item));
    }

    public static boolean isMelee(class_1799 stack) {
        if (stack == null) {
            stack = class_1799.field_8037;
        }
        return WeaponDefinitionsLoader.isMelee(stack.method_7909());
    }

    public static boolean isRanged(class_1799 stack) {
        if (stack == null) {
            stack = class_1799.field_8037;
        }
        return WeaponDefinitionsLoader.isRanged(stack.method_7909());
    }

    public static boolean isAmmo(class_1799 stack) {
        if (stack == null) {
            stack = class_1799.field_8037;
        }
        return WeaponDefinitionsLoader.isAmmo(stack.method_7909());
    }

    public static boolean isMelee(class_1792 item) {
        DefinitionData data = WeaponDefinitionsLoader.getData(item);
        return data.melee() != null && data.usage().contains((Object)Usage.MELEE);
    }

    public static boolean isRanged(class_1792 item) {
        DefinitionData data = WeaponDefinitionsLoader.getData(item);
        return data.ranged() != null && data.usage().contains((Object)Usage.RANGED);
    }

    public static boolean isAmmo(class_1792 item) {
        DefinitionData data = WeaponDefinitionsLoader.getData(item);
        return data.ammo() != null && data.usage().contains((Object)Usage.AMMO);
    }

    public record DefinitionData(EnumSet<Usage> usage, MeleeData melee, RangedData ranged, AmmoData ammo) {
    }

    public static enum Usage {
        MELEE,
        RANGED,
        AMMO;

    }

    public record MeleeData(Map<String, Float> damage, Map<String, Double> radius, int[] piercingAnimation, int animation, SCDamageCalculator.DamageType onlyDamageType, double deflectChance, double bonusKnockback) {
        public static final Codec<MeleeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT).xmap(map -> {
            HashMap<String, Float> upperCaseMap = new HashMap<String, Float>();
            for (Map.Entry entry : map.entrySet()) {
                upperCaseMap.put(((String)entry.getKey()).toUpperCase(), (Float)entry.getValue());
            }
            return upperCaseMap;
        }, map -> map).optionalFieldOf("damage", Map.of()).forGetter(MeleeData::damage), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE).optionalFieldOf("radius", Map.of()).forGetter(MeleeData::radius), (App)Codec.INT.listOf().xmap(list -> list.stream().mapToInt(i -> i).toArray(), array -> Arrays.stream(array).boxed().toList()).optionalFieldOf("piercingAnimation", (Object)new int[0]).forGetter(MeleeData::piercingAnimation), (App)Codec.INT.optionalFieldOf("animation", (Object)0).forGetter(MeleeData::animation), (App)SCDamageCalculator.DamageType.CODEC.optionalFieldOf("onlyDamageType").forGetter(md -> Optional.ofNullable(md.onlyDamageType)), (App)Codec.DOUBLE.optionalFieldOf("deflectChance", (Object)0.0).forGetter(MeleeData::deflectChance), (App)Codec.DOUBLE.optionalFieldOf("bonusKnockback", (Object)0.0).forGetter(MeleeData::bonusKnockback)).apply((Applicative)instance, (damage, radius, piercingAnimation, animation, onlyDamageType, deflectChance, bonusKnockback) -> new MeleeData((Map<String, Float>)damage, (Map<String, Double>)radius, (int[])piercingAnimation, (int)animation, onlyDamageType.orElse(null), (double)deflectChance, (double)bonusKnockback)));
    }

    public record RangedData(String id, float baseDamage, SCDamageCalculator.DamageType damageType, int maxUseTime, float speed, float divergence, int rechargeTime, boolean needsFlintAndSteel, class_1839 useAction, Map<String, AmmoRequirementData> ammoRequirement, class_3414 soundEvent) {
        private static final Codec<class_1839> USE_ACTION_CODEC = Codec.STRING.xmap(str -> class_1839.valueOf((String)str.toUpperCase()), Enum::name);
        private static final Codec<class_3414> SOUND_EVENT_CODEC = class_2960.field_25139.xmap(arg_0 -> ((class_2378)class_7923.field_41172).method_10223(arg_0), arg_0 -> ((class_2378)class_7923.field_41172).method_10221(arg_0));
        public static final Codec<RangedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("id", (Object)"bow").forGetter(RangedData::id), (App)Codec.FLOAT.optionalFieldOf("baseDamage", (Object)Float.valueOf(0.0f)).forGetter(RangedData::baseDamage), (App)SCDamageCalculator.DamageType.CODEC.optionalFieldOf("damageType").forGetter(rd -> Optional.ofNullable(rd.damageType)), (App)Codec.INT.optionalFieldOf("maxUseTime", (Object)0).forGetter(RangedData::maxUseTime), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(0.0f)).forGetter(RangedData::speed), (App)Codec.FLOAT.optionalFieldOf("divergence", (Object)Float.valueOf(0.0f)).forGetter(RangedData::divergence), (App)Codec.INT.optionalFieldOf("rechargeTime", (Object)0).forGetter(RangedData::rechargeTime), (App)Codec.BOOL.optionalFieldOf("needsFlintAndSteel", (Object)false).forGetter(RangedData::needsFlintAndSteel), (App)USE_ACTION_CODEC.optionalFieldOf("useAction", (Object)class_1839.field_8952).forGetter(RangedData::useAction), (App)Codec.unboundedMap((Codec)Codec.STRING, AmmoRequirementData.CODEC).optionalFieldOf("ammoRequirement", Map.of()).forGetter(RangedData::ammoRequirement), (App)SOUND_EVENT_CODEC.optionalFieldOf("soundEvent").forGetter(rd -> Optional.ofNullable(rd.soundEvent))).apply((Applicative)instance, (id, baseDamage, damageType, maxUseTime, speed, divergence, rechargeTime, needsFlintAndSteel, useAction, ammoRequirement, soundEvent) -> new RangedData((String)id, baseDamage.floatValue(), damageType.orElse(null), (int)maxUseTime, speed.floatValue(), divergence.floatValue(), (int)rechargeTime, (boolean)needsFlintAndSteel, (class_1839)useAction, (Map<String, AmmoRequirementData>)ammoRequirement, soundEvent.orElse(null))));
    }

    public record AmmoData(double deflectChance) {
        public static final Codec<AmmoData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("deflectChance", (Object)0.0).forGetter(AmmoData::deflectChance)).apply((Applicative)instance, AmmoData::new));
    }

    public record WeaponDefinition(MeleeData melee, RangedData ranged, AmmoData ammo) {
        public static final Codec<WeaponDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MeleeData.CODEC.optionalFieldOf("melee").forGetter(wd -> Optional.ofNullable(wd.melee)), (App)RangedData.CODEC.optionalFieldOf("ranged").forGetter(wd -> Optional.ofNullable(wd.ranged)), (App)AmmoData.CODEC.optionalFieldOf("ammo").forGetter(wd -> Optional.ofNullable(wd.ammo))).apply((Applicative)instance, (melee, ranged, ammo) -> new WeaponDefinition(melee.orElse(null), ranged.orElse(null), ammo.orElse(null))));
    }

    public record AmmoRequirementData(HashSet<String> itemIds, int amount) {
        public static final Codec<AmmoRequirementData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().xmap(HashSet::new, ArrayList::new).fieldOf("items").forGetter(AmmoRequirementData::itemIds), (App)Codec.INT.fieldOf("amount").forGetter(AmmoRequirementData::amount)).apply((Applicative)instance, AmmoRequirementData::new));
    }
}

