/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.patterns;

import banduty.stoneycore.util.data.itemdata.INBTKeys;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3545;

public class PatternHelper {
    public static void setBannerPatterns(class_1799 stack, List<class_3545<class_2960, class_1767>> patterns) {
        class_2487 nbt = stack.method_7948();
        class_2499 patternList = new class_2499();
        for (class_3545<class_2960, class_1767> pattern : patterns) {
            patternList.add((Object)class_2519.method_23256((String)((class_2960)pattern.method_15442()).toString()));
        }
        nbt.method_10566("BannerPatterns", (class_2520)patternList);
        class_2499 colorList = new class_2499();
        for (class_3545<class_2960, class_1767> pattern : patterns) {
            float[] components = ((class_1767)pattern.method_15441()).method_7787();
            class_2487 colorTag = new class_2487();
            colorTag.method_10548("R", components[0]);
            colorTag.method_10548("G", components[1]);
            colorTag.method_10548("B", components[2]);
            colorList.add((Object)colorTag);
        }
        nbt.method_10566("BannerColors", (class_2520)colorList);
    }

    public static List<class_3545<class_2960, class_1767>> getBannerPatterns(class_1799 stack) {
        ArrayList<class_3545<class_2960, class_1767>> patterns = new ArrayList<class_3545<class_2960, class_1767>>();
        if (stack.method_7969() != null && stack.method_7969().method_10545("BannerPatterns")) {
            class_2499 patternList = stack.method_7969().method_10554("BannerPatterns", 8);
            class_2499 colorList = stack.method_7969().method_10554("BannerColors", 10);
            for (int i = 0; i < patternList.size(); ++i) {
                class_2960 patternId = class_2960.method_12829((String)patternList.method_10608(i));
                class_2487 colorTag = colorList.method_10602(i);
                float r = colorTag.method_10583("R");
                float g = colorTag.method_10583("G");
                float b = colorTag.method_10583("B");
                class_1767 dyeColor = PatternHelper.findClosestDyeColor(r, g, b);
                patterns.add((class_3545<class_2960, class_1767>)new class_3545((Object)patternId, (Object)dyeColor));
            }
        }
        return patterns;
    }

    private static class_1767 findClosestDyeColor(float r, float g, float b) {
        class_1767 closestColor = class_1767.field_7952;
        float minDistance = Float.MAX_VALUE;
        for (class_1767 color : class_1767.values()) {
            float[] components = color.method_7787();
            float distance = PatternHelper.colorDistance(r, g, b, components[0], components[1], components[2]);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            closestColor = color;
        }
        return closestColor;
    }

    private static float colorDistance(float r1, float g1, float b1, float r2, float g2, float b2) {
        return (r1 - r2) * (r1 - r2) + (g1 - g2) * (g1 - g2) + (b1 - b2) * (b1 - b2);
    }

    public static void setBannerDyeColor(class_1799 stack, class_1767 dyeColor) {
        float[] components = dyeColor.method_7787();
        NBTDataHelper.set(stack, INBTKeys.DYE_COLOR_R, Float.valueOf(components[0]));
        NBTDataHelper.set(stack, INBTKeys.DYE_COLOR_G, Float.valueOf(components[1]));
        NBTDataHelper.set(stack, INBTKeys.DYE_COLOR_B, Float.valueOf(components[2]));
    }

    public static float[] getBannerDyeColor(class_1799 stack) {
        return new float[]{NBTDataHelper.get(stack, INBTKeys.DYE_COLOR_R, Float.valueOf(1.0f)).floatValue(), NBTDataHelper.get(stack, INBTKeys.DYE_COLOR_G, Float.valueOf(1.0f)).floatValue(), NBTDataHelper.get(stack, INBTKeys.DYE_COLOR_B, Float.valueOf(1.0f)).floatValue()};
    }
}

