/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.render;

import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.networking.ModMessages;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class OutlineClaimRenderer {
    public static void renderOutlineClaim(class_3222 player) {
        class_3218 world = player.method_51469();
        Optional<Land> optionalLand = LandState.get(world).getLandByOwner(player.method_5667());
        if (optionalLand.isEmpty()) {
            OutlineClaimRenderer.sendClearPacket(player);
            return;
        }
        boolean shouldRender = false;
        Land land = optionalLand.get();
        if (player.method_6118(class_1304.field_6169).method_31574(land.getLandType().coreItem())) {
            shouldRender = true;
        }
        if (AccessoriesCapability.getOptionally((class_1309)player).isPresent()) {
            for (SlotEntryReference equipped : AccessoriesCapability.get((class_1309)player).getAllEquipped()) {
                class_1799 equippedStack = equipped.stack();
                if (equippedStack.method_7969() == null || !equippedStack.method_7969().method_10577(class_7923.field_41178.method_10221((Object)land.getLandType().coreItem()).method_12832())) continue;
                shouldRender = true;
            }
        }
        if (!shouldRender) {
            OutlineClaimRenderer.sendClearPacket(player);
            return;
        }
        Set<class_2338> claimed = land.getClaimed();
        ArrayList<class_2338> borderPositions = new ArrayList<class_2338>();
        for (class_2338 pos : claimed) {
            if (!OutlineClaimRenderer.isBorderBlock(pos, claimed)) continue;
            borderPositions.add(OutlineClaimRenderer.getAdjustedTopPosition(world, pos));
        }
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(borderPositions.size());
        borderPositions.forEach(arg_0 -> ((class_2540)buf).method_10807(arg_0));
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.OUTLINE_CLAIM_PACKET_ID, (class_2540)buf);
    }

    private static void sendClearPacket(class_3222 player) {
        class_2540 clearBuf = PacketByteBufs.create();
        clearBuf.writeInt(0);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.OUTLINE_CLAIM_PACKET_ID, (class_2540)clearBuf);
    }

    private static class_2338 getAdjustedTopPosition(class_3218 world, class_2338 pos) {
        int minY = world.method_31607();
        class_2338.class_2339 checkPos = world.method_8598(class_2902.class_2903.field_13197, pos).method_25503();
        class_2680 state = world.method_8320((class_2338)checkPos);
        while ((state.method_27852(class_2246.field_10124) || !state.method_26225() && !state.method_27852(class_2246.field_10382)) && checkPos.method_10264() > minY) {
            checkPos.method_10100(0, -1, 0);
            state = world.method_8320((class_2338)checkPos);
        }
        return checkPos.method_10062();
    }

    private static boolean isBorderBlock(class_2338 pos, Set<class_2338> claimed) {
        int x = pos.method_10263();
        int z = pos.method_10260();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0 || claimed.contains(new class_2338(x + dx, pos.method_10264(), z + dz))) continue;
                return true;
            }
        }
        return false;
    }
}

