/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.servertick;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.config.StoneyCoreConfig;
import banduty.stoneycore.util.WeightUtil;
import banduty.stoneycore.util.data.playerdata.IEntityDataSaver;
import banduty.stoneycore.util.data.playerdata.StaminaData;
import banduty.stoneycore.util.definitionsloader.ArmorDefinitionsLoader;
import banduty.stoneycore.util.definitionsloader.WeaponDefinitionsLoader;
import banduty.streq.StrEq;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class StaminaUtil {
    public static void startStaminaTrack(class_1309 entity) {
        boolean skipDrain;
        boolean canRecoverStamina;
        class_1657 player;
        boolean isCreativeOrSpectator;
        double maxStamina = entity.method_26825((class_1320)StoneyCore.MAX_STAMINA.get());
        double currentStamina = StaminaData.getStamina(entity);
        boolean bl = isCreativeOrSpectator = entity instanceof class_1657 && ((player = (class_1657)entity).method_7337() || player.method_7325());
        if (isCreativeOrSpectator || maxStamina <= 0.0) {
            if (currentStamina < maxStamina) {
                StaminaData.setStamina(entity, maxStamina);
            }
            StaminaUtil.removeStaminaEffects(entity);
            StaminaData.setStaminaBlocked((IEntityDataSaver)entity, false);
            StaminaData.setStaminaUseTime((IEntityDataSaver)entity, 0);
            return;
        }
        if (currentStamina > maxStamina) {
            StaminaData.setStamina(entity, maxStamina);
        }
        IEntityDataSaver dataSaver = (IEntityDataSaver)entity;
        boolean wasUsingStamina = StaminaUtil.isUsingStamina(entity);
        if (wasUsingStamina) {
            StaminaData.setStaminaUseTime(dataSaver, StoneyCore.getConfig().combatOptions.getStaminaRecoverTime());
        }
        boolean bl2 = canRecoverStamina = StaminaData.getStaminaUseTime(dataSaver) <= 0;
        if (StaminaData.getStaminaUseTime(dataSaver) > 0) {
            StaminaData.setStaminaUseTime(dataSaver, StaminaData.getStaminaUseTime(dataSaver) - 1);
        }
        boolean bl3 = skipDrain = !StoneyCore.getConfig().combatOptions.getRealisticCombat() || !wasUsingStamina || entity.method_24828() || entity.method_6101();
        if (skipDrain && canRecoverStamina) {
            StaminaUtil.handleStaminaRecovery(entity, currentStamina);
        }
        StaminaUtil.handleStaminaEffects(entity, currentStamina, maxStamina);
    }

    private static void handleStaminaRecovery(class_1309 entity, double currentStamina) {
        double d;
        StoneyCoreConfig.CombatOptions_ config = StoneyCore.getConfig().combatOptions;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            d = player.method_7344().method_7586();
        } else {
            d = 20.0;
        }
        double foodLevel = d;
        double health = entity.method_6032();
        Map<String, Double> vars = Map.of("foodLevel", foodLevel, "health", health);
        int recoveryRate = Math.max(1, (int)StrEq.evaluate((String)config.staminaRecoveryFormula(), vars));
        if (entity.field_6012 % recoveryRate != 0) {
            return;
        }
        double maxStamina = entity.method_26825((class_1320)StoneyCore.MAX_STAMINA.get());
        if (currentStamina < maxStamina && (foodLevel > 0.0 || !config.getRealisticCombat())) {
            StaminaData.addStamina(entity, 0.1);
        }
    }

    private static void handleStaminaEffects(class_1309 entity, double currentStamina, double maxStamina) {
        IEntityDataSaver dataSaver = (IEntityDataSaver)entity;
        double level1 = maxStamina * 0.3;
        double level2 = maxStamina * 0.15;
        if (currentStamina < level1 && currentStamina > level2) {
            StaminaUtil.applyStaminaEffects(entity, 0, 0);
        } else if (currentStamina <= 0.0) {
            StaminaData.setStaminaBlocked(dataSaver, true);
            StaminaUtil.applyStaminaEffects(entity, 3, 3);
        } else if (StaminaData.isStaminaBlocked(dataSaver) && currentStamina >= level2) {
            StaminaData.setStaminaBlocked(dataSaver, false);
            StaminaUtil.removeStaminaEffects(entity);
        } else if (currentStamina >= level1) {
            StaminaUtil.removeStaminaEffects(entity);
        }
    }

    private static boolean isUsingStamina(class_1309 entity) {
        IEntityDataSaver dataSaver = (IEntityDataSaver)entity;
        if (StaminaData.isStaminaBlocked(dataSaver)) {
            return false;
        }
        boolean usingStamina = false;
        StoneyCoreConfig.CombatOptions_ config = StoneyCore.getConfig().combatOptions;
        if (StaminaUtil.isSCWeapon(entity.method_6047()) && entity.method_6039()) {
            StaminaData.removeStamina(entity, config.blockingStaminaConstant() * WeightUtil.getCachedWeight(entity) / 20.0);
            usingStamina = true;
        }
        if (!StaminaUtil.isWearingSCArmor(entity)) {
            return usingStamina;
        }
        if (entity.method_5624()) {
            StaminaData.removeStamina(entity, config.sprintingStaminaConstant() * WeightUtil.getCachedWeight(entity) / 20.0);
            usingStamina = true;
        }
        if (entity.method_5681()) {
            StaminaData.removeStamina(entity, config.swimmingStaminaConstant() * WeightUtil.getCachedWeight(entity) / 40.0);
            usingStamina = true;
        }
        return usingStamina;
    }

    private static void applyStaminaEffects(class_1309 entity, int fatigueLevel, int slownessLevel) {
        entity.method_6092(new class_1293(class_1294.field_5901, -1, fatigueLevel, false, false, false));
        entity.method_6092(new class_1293(class_1294.field_5909, -1, slownessLevel, false, false, false));
    }

    private static void removeStaminaEffects(class_1309 entity) {
        entity.method_6016(class_1294.field_5901);
        entity.method_6016(class_1294.field_5909);
    }

    private static boolean isSCWeapon(class_1799 stack) {
        return WeaponDefinitionsLoader.isMelee(stack.method_7909());
    }

    private static boolean isWearingSCArmor(class_1309 entity) {
        for (class_1799 armorStack : entity.method_5661()) {
            if (!ArmorDefinitionsLoader.containsItem(armorStack.method_7909())) continue;
            return true;
        }
        return false;
    }
}

