/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.weaponutil;

import banduty.stoneycore.util.SCDamageCalculator;
import banduty.stoneycore.util.data.itemdata.INBTKeys;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.definitionsloader.WeaponDefinitionsLoader;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_5712;

public final class SCWeaponUtil {
    private static final double BACKSTAB_ANGLE_THRESHOLD = -0.5;
    private static final double RADIUS_TOLERANCE = 0.25;

    private SCWeaponUtil() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static double getDamageValues(SCDamageCalculator.DamageType key, class_1792 item) {
        WeaponDefinitionsLoader.DefinitionData attributeData = WeaponDefinitionsLoader.getData(item);
        Map<String, Float> damageValues = attributeData.melee().damage();
        return damageValues.getOrDefault(key.name(), Float.valueOf(0.0f)).floatValue();
    }

    public static SCDamageCalculator.DamageType calculateDamageType(class_1799 stack, int comboCount) {
        boolean bludgeoningToPiercing = SCWeaponUtil.getDamageValues(SCDamageCalculator.DamageType.SLASHING, stack.method_7909()) == 0.0 && SCWeaponUtil.getDamageValues(SCDamageCalculator.DamageType.PIERCING, stack.method_7909()) > 0.0 && SCWeaponUtil.getDamageValues(SCDamageCalculator.DamageType.BLUDGEONING, stack.method_7909()) > 0.0;
        boolean isBludgeoning = NBTDataHelper.get(stack, INBTKeys.BLUDGEONING, Boolean.valueOf(false));
        boolean isPiercing = SCWeaponUtil.isPiercingWeapon(stack.method_7909(), comboCount);
        if (isBludgeoning ^ bludgeoningToPiercing || WeaponDefinitionsLoader.getData(stack).melee().onlyDamageType() == SCDamageCalculator.DamageType.BLUDGEONING) {
            return SCDamageCalculator.DamageType.BLUDGEONING;
        }
        if (isPiercing || bludgeoningToPiercing) {
            return SCDamageCalculator.DamageType.PIERCING;
        }
        return SCDamageCalculator.DamageType.SLASHING;
    }

    private static boolean isPiercingWeapon(class_1792 item, int comboCount) {
        return WeaponDefinitionsLoader.getData(item).melee().animation() > 0 && SCWeaponUtil.isComboCountPiercing(item, comboCount) || WeaponDefinitionsLoader.getData(item).melee().onlyDamageType() == SCDamageCalculator.DamageType.PIERCING;
    }

    private static boolean isComboCountPiercing(class_1792 item, int comboCount) {
        WeaponDefinitionsLoader.DefinitionData attributeData = WeaponDefinitionsLoader.getData(item);
        int[] piercingAnimations = attributeData.melee().piercingAnimation();
        int animation = attributeData.melee().animation();
        boolean piercing = false;
        if (animation > 0) {
            for (int piercingAnimation : piercingAnimations) {
                if (comboCount % animation != piercingAnimation - 1) continue;
                piercing = true;
                break;
            }
            if (piercingAnimations.length == animation) {
                piercing = true;
            }
        }
        return piercing;
    }

    public static double adjustDamageForBackstab(class_1309 target, class_243 playerPos, double damage) {
        class_243 attackDirection;
        class_243 targetFacing = target.method_5828(1.0f).method_1029();
        boolean isBehind = targetFacing.method_1026(attackDirection = playerPos.method_1020(target.method_19538()).method_1029()) < -0.5;
        return isBehind ? damage * 2.0 : damage;
    }

    public static double getMaxDistance(class_1792 item) {
        return SCWeaponUtil.getRadius(item, 4);
    }

    public static double getRadius(class_1792 item, int index) {
        WeaponDefinitionsLoader.DefinitionData attributeData = WeaponDefinitionsLoader.getData(item);
        Map<String, Double> radiusValues = attributeData.melee().radius();
        return radiusValues.getOrDefault(switch (index) {
            case 0 -> "level_0";
            case 1 -> "level_1";
            case 2 -> "level_2";
            case 3 -> "level_3";
            case 4 -> "level_4";
            default -> throw new IllegalArgumentException("Invalid index: " + index);
        }, 0.0);
    }

    public static double calculateDamage(class_1792 item, double distance, SCDamageCalculator.DamageType key) {
        for (int i = 0; i <= 4; ++i) {
            double radius = SCWeaponUtil.getRadius(item, i);
            if (!(distance < radius + 0.25)) continue;
            double attackDamage = SCWeaponUtil.getDamageValues(key, item);
            float percentage = SCWeaponUtil.calculatePercentageForIndex(i);
            return attackDamage * (double)percentage;
        }
        return 0.0;
    }

    private static float calculatePercentageForIndex(int index) {
        return switch (index) {
            case 4 -> 0.33333334f;
            case 1, 3 -> 0.6666667f;
            case 2 -> 1.0f;
            default -> 0.0f;
        };
    }

    public static void replantCrop(class_1937 world, class_2338 pos, class_2302 cropBlock, class_1657 player, class_1799 stack, class_1268 hand) {
        class_1799 seedStack = new class_1799((class_1935)cropBlock.method_8389());
        if (!seedStack.method_7960()) {
            world.method_8652(pos, cropBlock.method_9564(), 3);
            world.method_33596((class_1297)player, class_5712.field_28164, pos);
            if (!player.method_31549().field_7477) {
                seedStack.method_7934(1);
            }
        }
        stack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
    }
}

