/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.commands.land;

import banduty.stoneycore.commands.SCCommandsHandler;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandState;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class Name {
    public static LiteralArgumentBuilder<class_2168> registerName() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"name").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"owner", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            for (class_3222 player : ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571()) {
                UUID uuid = player.method_5667();
                if (!LandState.get(world).getLandByOwner(uuid).isPresent()) continue;
                builder.suggest(player.method_7334().getName());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> Name.setName((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"owner"), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"remove").executes(ctx -> Name.removeName((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"owner")))));
    }

    private static int setName(class_2168 src, String ownerName, String newName) {
        UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
        if (ownerUUID == null) {
            return SCCommandsHandler.error(src, "Unknown owner " + ownerName);
        }
        class_3218 world = src.method_9225();
        LandState state = LandState.get(world);
        Optional<Land> landOpt = state.getLandByOwner(ownerUUID);
        if (landOpt.isEmpty()) {
            return SCCommandsHandler.error(src, ownerName + " doesn\u2019t own a Land");
        }
        Land land = landOpt.get();
        land.setName(newName);
        src.method_9226(() -> class_2561.method_43470((String)("Land name for " + ownerName + " set to '" + newName + "'")), true);
        return 1;
    }

    private static int removeName(class_2168 src, String ownerName) {
        UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
        if (ownerUUID == null) {
            return SCCommandsHandler.error(src, "Unknown owner " + ownerName);
        }
        class_3218 world = src.method_9225();
        LandState state = LandState.get(world);
        Optional<Land> landOpt = state.getLandByOwner(ownerUUID);
        if (landOpt.isEmpty()) {
            return SCCommandsHandler.error(src, ownerName + " doesn\u2019t own a Land");
        }
        Land land = landOpt.get();
        land.setName("");
        src.method_9226(() -> class_2561.method_43470((String)("Land name for " + ownerName + " removed")), true);
        return 1;
    }
}

