/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.commands.land;

import banduty.stoneycore.commands.SCCommandsHandler;
import banduty.stoneycore.event.StartTickHandler;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandState;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class Radius {
    public static LiteralArgumentBuilder<class_2168> registerRadius() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"radius").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"owner", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            for (class_3222 player : ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571()) {
                UUID uuid = player.method_5667();
                if (!LandState.get(world).getLandByOwner(uuid).isPresent()) continue;
                builder.suggest(player.method_7334().getName());
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3218 world = src.method_9225();
            String ownerName = StringArgumentType.getString((CommandContext)ctx, (String)"owner");
            UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
            if (ownerUUID == null) {
                return SCCommandsHandler.error(src, "Unknown owner " + ownerName);
            }
            LandState state = LandState.get(world);
            Optional<Land> landOpt = state.getLandByOwner(ownerUUID);
            if (landOpt.isEmpty()) {
                return SCCommandsHandler.error(src, ownerName + " doesn\u2019t own a Land");
            }
            Land land = landOpt.get();
            src.method_9226(() -> class_2561.method_43470((String)(ownerName + "\u2019s Land is " + land.getRadius() + " blocks")), false);
            return 1;
        })).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3218 world = src.method_9225();
            String ownerName = StringArgumentType.getString((CommandContext)ctx, (String)"owner");
            int radius = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius");
            if (radius <= 0) {
                return SCCommandsHandler.error(src, "Radius should be a number higher than 0");
            }
            UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
            if (ownerUUID == null) {
                return SCCommandsHandler.error(src, "Unknown owner " + ownerName);
            }
            LandState state = LandState.get(world);
            Optional<Land> landOpt = state.getLandByOwner(ownerUUID);
            if (landOpt.isEmpty()) {
                return SCCommandsHandler.error(src, ownerName + " doesn\u2019t own a Land");
            }
            Land oldLand = landOpt.get();
            int current = oldLand.getRadius();
            if (current == radius) {
                src.method_9226(() -> class_2561.method_43470((String)("Radius already set to " + radius)), false);
                return 0;
            }
            Land land = oldLand.copy();
            land.initializeClaim(world, radius, StartTickHandler.CLAIM_TASKS);
            state.removeLand(oldLand);
            state.addLand(land);
            state.method_80();
            src.method_9226(() -> class_2561.method_43470((String)("Radius set to " + radius + " for " + ownerName)), true);
            return 1;
        })))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3218 world = src.method_9225();
            String ownerName = StringArgumentType.getString((CommandContext)ctx, (String)"owner");
            int toAdd = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius");
            if (toAdd <= 0) {
                return SCCommandsHandler.error(src, "Radius should be a number higher than 0");
            }
            UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
            if (ownerUUID == null) {
                return SCCommandsHandler.error(src, "Unknown owner " + ownerName);
            }
            LandState state = LandState.get(world);
            Optional<Land> landOpt = state.getLandByOwner(ownerUUID);
            if (landOpt.isEmpty()) {
                return SCCommandsHandler.error(src, ownerName + " doesn\u2019t own a Land");
            }
            Land land = landOpt.get().copy();
            int newRadius = land.getRadius() + toAdd;
            if (newRadius <= 0) {
                return SCCommandsHandler.error(src, "Radius should be a number higher than 0");
            }
            land.initializeClaim(world, newRadius, StartTickHandler.CLAIM_TASKS);
            state.removeLand(landOpt.get());
            state.addLand(land);
            state.method_80();
            src.method_9226(() -> class_2561.method_43470((String)("Radius increased to " + newRadius + " for " + ownerName)), true);
            return 1;
        })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3218 world = src.method_9225();
            String ownerName = StringArgumentType.getString((CommandContext)ctx, (String)"owner");
            int toRemove = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius");
            if (toRemove <= 0) {
                return SCCommandsHandler.error(src, "Radius should be a number higher than 0");
            }
            UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
            if (ownerUUID == null) {
                return SCCommandsHandler.error(src, "Unknown owner " + ownerName);
            }
            LandState state = LandState.get(world);
            Optional<Land> landOpt = state.getLandByOwner(ownerUUID);
            if (landOpt.isEmpty()) {
                return SCCommandsHandler.error(src, ownerName + " doesn\u2019t own a Land");
            }
            Land land = landOpt.get();
            int newRadius = land.getRadius() - toRemove;
            if (newRadius <= 0) {
                return SCCommandsHandler.error(src, "Radius should be a number higher than 0");
            }
            land.setRadius(newRadius, world);
            state.method_80();
            src.method_9226(() -> class_2561.method_43470((String)("Radius decreased to " + newRadius + " for " + ownerName)), true);
            return 1;
        }))));
    }
}

