/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.commands.land;

import banduty.stoneycore.commands.SCCommandsHandler;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.siege.SiegeManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class SiegeCommand {
    public static LiteralArgumentBuilder<class_2168> registerSiege() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"siege").then(class_2170.method_9247((String)"start").then(class_2170.method_9244((String)"owner", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            for (class_3222 player : ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571()) {
                UUID uuid = player.method_5667();
                if (!LandState.get(world).getLandByOwner(uuid).isPresent()) continue;
                builder.suggest(player.method_7334().getName());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (class_3222 player : ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571()) {
                builder.suggest(player.method_7334().getName());
            }
            return builder.buildFuture();
        }).executes(ctx -> SiegeCommand.start((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"owner"), StringArgumentType.getString((CommandContext)ctx, (String)"target"))))))).then(class_2170.method_9247((String)"cancel").then(class_2170.method_9244((String)"owner", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            for (class_3222 player : ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571()) {
                UUID uuid = player.method_5667();
                if (!LandState.get(world).getLandByOwner(uuid).isPresent()) continue;
                builder.suggest(player.method_7334().getName());
            }
            return builder.buildFuture();
        }).executes(ctx -> SiegeCommand.cancel((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"owner")))));
    }

    private static int start(class_2168 src, String ownerName, String targetName) {
        UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
        if (ownerUUID == null) {
            return SCCommandsHandler.error(src, "Unknown owner " + ownerName);
        }
        class_3218 world = src.method_9225();
        UUID targetUUID = SCCommandsHandler.getUUID(src, targetName);
        if (targetUUID == null) {
            return SCCommandsHandler.error(src, "Unknown target " + targetName);
        }
        LandState state = LandState.get(world);
        Optional<Land> ownerLandOpt = state.getLandByOwner(ownerUUID);
        Optional<Land> targetLandOpt = state.getLandByOwner(targetUUID);
        if (ownerLandOpt.isEmpty()) {
            return SCCommandsHandler.error(src, ownerName + " doesn\u2019t own a Land");
        }
        if (targetLandOpt.isEmpty()) {
            return SCCommandsHandler.error(src, targetName + " doesn\u2019t own a Land");
        }
        SiegeManager.startSiege(world, ownerUUID, targetUUID);
        src.method_9226(() -> class_2561.method_43470((String)("Siege started by " + ownerName + " against " + targetName)), true);
        return 1;
    }

    private static int cancel(class_2168 src, String ownerName) {
        class_3222 player;
        UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
        if (ownerUUID == null) {
            return SCCommandsHandler.error(src, "Unknown owner " + ownerName);
        }
        class_3218 world = src.method_9225();
        LandState state = LandState.get(world);
        Optional<Land> ownerLandOpt = state.getLandByOwner(ownerUUID);
        if (ownerLandOpt.isEmpty()) {
            return SCCommandsHandler.error(src, ownerName + " doesn\u2019t own a Land");
        }
        Land ownerLand = ownerLandOpt.get();
        Optional<SiegeManager.Siege> siegeOpt = SiegeManager.getPlayerSiege(world, ownerUUID);
        if (siegeOpt.isEmpty()) {
            return SCCommandsHandler.error(src, ownerLand.getName().isBlank() ? ownerName + " isn\u2019t in a siege" : ownerLand.getName() + " isn\u2019t in a siege");
        }
        SiegeManager.Siege siege = siegeOpt.get();
        for (UUID participant : siege.attackers) {
            player = world.method_8503().method_3760().method_14602(participant);
            if (player == null) continue;
            SiegeManager.sendTitle(player, (class_2561)class_2561.method_43470((String)"The Siege has been Cancelled"));
        }
        for (UUID participant : siege.defenders) {
            player = world.method_8503().method_3760().method_14602(participant);
            if (player == null) continue;
            SiegeManager.sendTitle(player, (class_2561)class_2561.method_43470((String)"The Siege has been Cancelled"));
        }
        SiegeManager.getSiegesForWorld(world).remove(siege);
        siege.clearBossBars();
        src.method_9226(() -> class_2561.method_43470((String)("Siege involving " + ownerName + " has been cancelled")), true);
        return 1;
    }
}

