/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.entity.custom;

import banduty.stoneycore.entity.custom.siegeentity.RotationAndMovementUtil;
import banduty.stoneycore.items.SCItems;
import banduty.stoneycore.items.item.SiegeSpawnerItem;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.networking.ModMessages;
import banduty.stoneycore.siege.SiegeManager;
import banduty.stoneycore.util.definitionsloader.SiegeEngineDefinitionsLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1321;
import net.minecraft.class_1498;
import net.minecraft.class_1542;
import net.minecraft.class_1632;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5146;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSiegeEntity
extends class_1309 {
    private class_1297 owner;
    protected static final class_2940<Float> TRACKED_YAW = class_2945.method_12791(AbstractSiegeEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> TRACKED_PITCH = class_2945.method_12791(AbstractSiegeEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Integer> COOLDOWN = class_2945.method_12791(AbstractSiegeEntity.class, (class_2941)class_2943.field_13327);
    public float lastRiderYaw;
    public float lastRiderPitch;
    public float wheelRotation;
    protected final Set<UUID> playersNotified = new HashSet<UUID>();

    public AbstractSiegeEntity(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
        this.method_5875(false);
        this.method_49477(1.0f);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TRACKED_YAW, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(TRACKED_PITCH, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(COOLDOWN, (Object)0);
    }

    public void setTrackedYaw(float yaw) {
        this.field_6011.method_12778(TRACKED_YAW, (Object)Float.valueOf(this.normalizeYaw(yaw)));
    }

    public float getTrackedYaw() {
        return ((Float)this.field_6011.method_12789(TRACKED_YAW)).floatValue();
    }

    public void setTrackedPitch(float pitch) {
        this.field_6011.method_12778(TRACKED_PITCH, (Object)Float.valueOf(Math.min(10.0f, Math.max(pitch, -20.0f))));
    }

    public float getTrackedPitch() {
        return ((Float)this.field_6011.method_12789(TRACKED_PITCH)).floatValue();
    }

    public void setCooldown(int cooldown) {
        this.field_6011.method_12778(COOLDOWN, (Object)Math.max(0, cooldown));
    }

    public int getCooldown() {
        return (Integer)this.field_6011.method_12789(COOLDOWN);
    }

    public float getWheelRotation() {
        return this.wheelRotation;
    }

    public class_1297 getOwner() {
        return this.owner;
    }

    public void setOwner(class_1297 owner) {
        this.owner = owner;
    }

    public void method_5773() {
        Optional<Land> currentLand;
        class_5146 saddleable;
        super.method_5773();
        RotationAndMovementUtil.updateWheelRotation(this);
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_1297 entity = this.method_31483();
        if (entity instanceof class_5146 && !(saddleable = (class_5146)entity).method_6725()) {
            entity.method_29239();
        }
        if (this.method_31483() != null && SiegeManager.getPlayerSiege(serverWorld, this.getOwnerUUID()).isEmpty() && (currentLand = LandState.get(serverWorld).getLandAt(this.method_24515())).isPresent() && !currentLand.get().getOwnerUUID().equals(this.getOwnerUUID())) {
            SiegeManager.startSiege(serverWorld, this.getOwnerUUID(), currentLand.get().getOwnerUUID());
        }
        RotationAndMovementUtil.updateSiegeVelocity(this);
        this.method_5847(this.getTrackedYaw());
        List players = serverWorld.method_18456();
        for (class_3222 player : players) {
            UUID playerId = player.method_5667();
            if (this.playersNotified.contains(playerId)) continue;
            class_2540 buffer = PacketByteBufs.create();
            buffer.writeFloat(this.method_36454());
            buffer.writeFloat(this.method_36455());
            buffer.writeFloat(this.getWheelRotation());
            ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.SIEGE_YAW_PITCH_S2C_ID, (class_2540)buffer);
            this.playersNotified.add(playerId);
        }
        Set onlinePlayerIds = players.stream().map(class_1297::method_5667).collect(Collectors.toSet());
        this.playersNotified.removeIf(uuid -> !onlinePlayerIds.contains(uuid));
        this.setTrackedYaw(this.method_36454());
        this.method_36456(this.method_36454());
        this.method_5847(this.method_36454());
        this.method_5636(this.method_36454());
        this.lastRiderYaw = this.method_36454();
        this.setTrackedPitch(this.method_36455());
        this.method_36457(this.method_36455());
        this.lastRiderPitch = this.method_36455();
        this.wheelRotation = this.getWheelRotation();
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    private UUID getOwnerUUID() {
        class_1321 tameableEntity;
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_12972;
            return playerEntity.method_5667();
        }
        class_1297 class_12973 = this.method_31483();
        if (class_12973 instanceof class_1321 && (class_12973 = (tameableEntity = (class_1321)class_12973).method_31483()) instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_12973;
            return playerEntity.method_5667();
        }
        return null;
    }

    protected void method_5793(class_1297 passenger) {
        if (passenger.method_37908() instanceof class_3218) {
            float yaw = this.getTrackedYaw();
            this.method_36456(yaw);
            this.method_5847(yaw);
            this.method_5636(yaw);
            this.lastRiderYaw = yaw;
            float pitch = this.getTrackedPitch();
            this.method_36457(pitch);
            this.lastRiderPitch = pitch;
        }
        super.method_5793(passenger);
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        RotationAndMovementUtil.updatePassengerPosition(this, passenger, positionUpdater);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1657) {
            UUID playerId;
            class_3218 serverWorld;
            Optional<SiegeManager.Siege> siegeOpt;
            class_1657 player = (class_1657)attacker;
            class_1937 class_19372 = player.method_37908();
            if (class_19372 instanceof class_3218 && (siegeOpt = SiegeManager.getPlayerSiege(serverWorld = (class_3218)class_19372, playerId = player.method_5667())).isPresent() && siegeOpt.get().isDisabled(playerId)) {
                return false;
            }
            if (player.method_6047().method_7909() instanceof class_1743) {
                return super.method_5643(source, amount);
            }
            if (player.method_6047().method_31574((class_1792)SCItems.SMITHING_HAMMER.get()) && this.getCooldown() == 0 && this.method_6032() < this.method_6063() && (class_19372 = player.method_37908()) instanceof class_3218) {
                serverWorld = (class_3218)class_19372;
                this.method_6033(player.method_7337() ? this.method_6063() : Math.min(this.method_6063(), this.method_6032() + 1.0f));
                if (!player.method_7337()) {
                    player.method_6047().method_7970(1, player.method_6051(), (class_3222)player);
                    if (player.method_6047().method_7919() >= player.method_6047().method_7936()) {
                        player.method_6047().method_7939(0);
                    }
                }
                serverWorld.method_14199((class_2394)class_2398.field_29644, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 5, 0.3, 0.5, 0.3, 0.1);
                return false;
            }
        }
        if (attacker instanceof class_1632) {
            return super.method_5643(source, amount);
        }
        if (attacker instanceof AbstractSiegeEntity) {
            return super.method_5643(source, amount);
        }
        return false;
    }

    public Iterable<class_1799> method_5661() {
        return List.of();
    }

    public class_1799 method_6118(class_1304 slot) {
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
    }

    public class_1306 method_6068() {
        return null;
    }

    public double method_5621() {
        return 1.0;
    }

    public boolean method_49693() {
        return true;
    }

    public abstract boolean method_5818(class_1297 var1);

    public boolean method_5810() {
        return false;
    }

    public boolean method_6034() {
        return false;
    }

    public class_243 method_24829(class_1309 passenger) {
        float yawRadians = (float)Math.toRadians(this.method_43078());
        class_243 offset = this.getPassengerOffset((class_1297)passenger);
        double leftOffset = offset.field_1352;
        double backOffset = offset.field_1350;
        double forwardX = -Math.sin(yawRadians);
        double forwardZ = Math.cos(yawRadians);
        double rightX = Math.cos(yawRadians);
        double rightZ = Math.sin(yawRadians);
        double offsetX = rightX * leftOffset - forwardX * backOffset;
        double offsetZ = rightZ * leftOffset - forwardZ * backOffset;
        double x = this.method_23317() + offsetX;
        double y = this.method_23318() + offset.field_1351;
        double z = this.method_23321() + offsetZ;
        return new class_243(x, y, z);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_3218 serverWorld;
        block13: {
            block12: {
                class_1937 class_19372 = this.method_37908();
                if (!(class_19372 instanceof class_3218)) break block12;
                serverWorld = (class_3218)class_19372;
                if (hand == class_1268.field_5808 && !this.field_6000) break block13;
            }
            return super.method_5688(player, hand);
        }
        UUID playerId = player.method_5667();
        Optional<SiegeManager.Siege> siegeOpt = SiegeManager.getPlayerSiege(serverWorld, playerId);
        if (siegeOpt.isPresent() && siegeOpt.get().isDisabled(playerId)) {
            return class_1269.field_5814;
        }
        LandState stateManager = LandState.get(serverWorld);
        Optional<Land> maybeLand = stateManager.getLandAt(this.method_24515());
        if (maybeLand.isPresent() && !maybeLand.get().getOwnerUUID().equals(player.method_5667()) && !maybeLand.get().isAlly(player.method_5667()) && !player.method_7337()) {
            return class_1269.field_5814;
        }
        class_1799 heldItem = player.method_5998(hand);
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1308) {
            class_1308 mobEntity = (class_1308)class_12972;
            if (heldItem.method_31574(class_1802.field_8868)) {
                mobEntity.method_5848();
                double[] offset = this.calculateHorseDismountOffset((class_1297)mobEntity);
                double dX = this.method_23317() + offset[0];
                double dY = this.method_23318() + 0.5;
                double dZ = this.method_23321() + offset[1];
                mobEntity.method_23327(dX, dY, dZ);
                class_1542 leadEntity = new class_1542(this.method_37908(), dX, dY, dZ, new class_1799((class_1935)class_1802.field_8719));
                this.method_37908().method_8649((class_1297)leadEntity);
                player.method_17356(class_3417.field_14975, class_3419.field_15254, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
            player.method_5804((class_1297)mobEntity);
            return class_1269.field_5812;
        }
        if (this.method_5685().isEmpty()) {
            List nearby = this.method_37908().method_8333((class_1297)player, this.method_5829().method_1014(4.0), entity -> entity instanceof class_1308);
            for (class_1297 entity2 : nearby) {
                class_5146 saddleable;
                class_1321 tameableEntity;
                class_1308 mobEntity;
                if (!this.method_5818(entity2) || !(entity2 instanceof class_1308) || (mobEntity = (class_1308)entity2).method_5933() != player || mobEntity instanceof class_1321 && !(tameableEntity = (class_1321)mobEntity).method_6181() || entity2 instanceof class_5146 && !(saddleable = (class_5146)entity2).method_6725()) continue;
                mobEntity.method_5932(true, false);
                mobEntity.method_5848();
                mobEntity.method_5804((class_1297)this);
                return class_1269.field_5812;
            }
        }
        if (this.method_31483() != null) {
            return class_1269.field_5812;
        }
        if (this.method_5818((class_1297)player) && heldItem.method_7960() && this.getCooldown() == 0 && !player.method_5715()) {
            player.method_5804((class_1297)this);
            return class_1269.field_5812;
        }
        if (this.getCooldown() > 0) {
            player.method_7353((class_2561)class_2561.method_43469((String)("text.siege_engine." + class_7923.field_41177.method_10221((Object)this.method_5864()).method_12836() + ".cooling_down"), (Object[])new Object[]{this.method_5477().getString()}), true);
        }
        return class_1269.field_5812;
    }

    protected double[] calculateHorseDismountOffset(class_1297 passenger) {
        float yawRadians = (float)Math.toRadians(this.method_43078());
        double forwardX = -Math.sin(yawRadians);
        double forwardZ = Math.cos(yawRadians);
        double rightX = Math.cos(yawRadians);
        double rightZ = Math.sin(yawRadians);
        class_243 offset = this.getPassengerOffset(passenger);
        double leftOffset = offset.field_1352;
        double backOffset = offset.field_1350;
        double offsetX = rightX * leftOffset - forwardX * backOffset;
        double offsetZ = rightZ * leftOffset - forwardZ * backOffset;
        return new double[]{offsetX, offsetZ};
    }

    private float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) >= 180.0f) {
            yaw -= 360.0f;
        }
        if (yaw < -180.0f) {
            yaw += 360.0f;
        }
        return yaw;
    }

    public abstract class_243 getPassengerOffset(class_1297 var1);

    public double getVelocity(class_1297 entity) {
        if (entity instanceof class_1498) {
            return SiegeEngineDefinitionsLoader.getData(this.method_5864()).horseSpeed();
        }
        return SiegeEngineDefinitionsLoader.getData(this.method_5864()).playerSpeed();
    }

    public abstract class_243 getPlayerPOV();

    @Nullable
    public class_1799 method_31480() {
        SiegeSpawnerItem siegeSpawnerItem = SiegeSpawnerItem.forEntity(this.method_5864());
        return siegeSpawnerItem == null ? null : new class_1799((class_1935)siegeSpawnerItem);
    }

    public double getKnockback() {
        return SiegeEngineDefinitionsLoader.getData(this.method_5864()).knockback();
    }

    public double getBaseDamage() {
        return SiegeEngineDefinitionsLoader.getData(this.method_5864()).baseDamage();
    }

    public int getBaseReload() {
        return SiegeEngineDefinitionsLoader.getData(this.method_5864()).baseReload();
    }

    public float getProjectileSpeed() {
        return SiegeEngineDefinitionsLoader.getData(this.method_5864()).projectileSpeed();
    }

    public float getAccuracyMultiplier() {
        return SiegeEngineDefinitionsLoader.getData(this.method_5864()).accuracyMultiplier();
    }
}

