/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.lands.util;

import banduty.stoneycore.lands.LandType;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3486;

public class ClaimUtils {
    public static boolean isInvalidClaimColumn(class_3218 world, class_2338 pos, LandType landType) {
        LandType.TerrainType terrain = landType.terrainType();
        if (terrain == LandType.TerrainType.GWL) {
            return false;
        }
        class_2338.class_2339 checkPos = world.method_8598(class_2902.class_2903.field_13197, pos).method_25503();
        class_2680 state = world.method_8320((class_2338)checkPos);
        while ((state.method_27852(class_2246.field_10124) || !state.method_26225() && !state.method_27852(class_2246.field_10382) && !state.method_27852(class_2246.field_10164)) && checkPos.method_10264() > world.method_31607()) {
            checkPos.method_10100(0, -1, 0);
            state = world.method_8320((class_2338)checkPos);
        }
        boolean isWater = state.method_26227().method_15767(class_3486.field_15517);
        boolean isLava = state.method_27852(class_2246.field_10164);
        boolean isGround = !isWater && !isLava;
        return switch (terrain) {
            case LandType.TerrainType.GROUND -> {
                if (!isGround) {
                    yield true;
                }
                yield false;
            }
            case LandType.TerrainType.WATER -> {
                if (!isWater) {
                    yield true;
                }
                yield false;
            }
            case LandType.TerrainType.LAVA -> {
                if (!isLava) {
                    yield true;
                }
                yield false;
            }
            case LandType.TerrainType.GW -> {
                if (!isGround && !isWater) {
                    yield true;
                }
                yield false;
            }
            case LandType.TerrainType.GL -> {
                if (!isGround && !isLava) {
                    yield true;
                }
                yield false;
            }
            case LandType.TerrainType.WL -> {
                if (!isWater && !isLava) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)terrain));
        };
    }

    public static boolean pathContainsInvalidBlock(class_3218 world, class_2338 start, class_2338 end, LandType landType) {
        int x0 = start.method_10263();
        int z0 = start.method_10260();
        int x1 = end.method_10263();
        int z1 = end.method_10260();
        int dx = Math.abs(x1 - x0);
        int dz = Math.abs(z1 - z0);
        int sx = Integer.compare(x1, x0);
        int sz = Integer.compare(z1, z0);
        int err = dx - dz;
        class_2338.class_2339 pos = new class_2338.class_2339();
        while (true) {
            pos.method_10103(x0, 0, z0);
            if (ClaimUtils.isInvalidClaimColumn(world, (class_2338)pos, landType)) {
                return true;
            }
            if (x0 == x1 && z0 == z1) break;
            int e2 = err << 1;
            if (e2 > -dz) {
                err -= dz;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            z0 += sz;
        }
        return false;
    }
}

