/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.lands.util;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.lands.util.ClaimUtils;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandState;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class ClaimWorker {
    private final class_3218 world;
    private final Land land;
    private final Consumer<Boolean> onComplete;
    private final LongArrayFIFOQueue priorityQueue = new LongArrayFIFOQueue();
    private final LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
    private final LongSet invalid = new LongOpenHashSet();
    private final LongArrayList acceptedKeys = new LongArrayList();
    private final Long2ByteOpenHashMap neighborMask = new Long2ByteOpenHashMap();
    private int totalAccepted = 0;
    private final long startTime;
    private int claimsThisPeriod = 0;
    private int logTick = 0;
    private long lastZeroCpsCheckTime;
    private long lastLogTime;
    private int claimsSinceLastZeroCheck = 0;
    private final int requiredTicksForZeroCpsStop;
    private int tickCPS = 0;
    private final int maxWorkPerTick;
    private static final int[][] NEIGHBOR_OFFSETS = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, -1}, {0, 1}, {1, -1}, {1, 0}, {1, 1}};

    public ClaimWorker(class_3218 world, Land land, Iterable<class_2338> candidates, int radius, Consumer<Boolean> onComplete) {
        long currentTickTime;
        long key;
        this.maxWorkPerTick = StoneyCore.getConfig().technicalOptions.maxWorkPerTick();
        this.world = world;
        this.land = land;
        this.onComplete = onComplete;
        this.neighborMask.defaultReturnValue((byte)0);
        for (class_2338 claimedPos : land.getClaimed()) {
            key = claimedPos.method_10063();
            this.priorityQueue.enqueue(key);
            this.updateNeighborMask(key);
        }
        for (class_2338 pos : candidates) {
            key = pos.method_10063();
            if (ClaimUtils.isInvalidClaimColumn(world, class_2338.method_10092((long)key), land.getLandType())) {
                this.invalid.add(key);
                continue;
            }
            if (land.isAlreadyClaimed(key)) continue;
            this.queue.enqueue(key);
        }
        this.requiredTicksForZeroCpsStop = Math.max(1, radius / 100);
        this.startTime = currentTickTime = (long)world.method_8503().method_3780();
        this.lastZeroCpsCheckTime = currentTickTime;
        this.lastLogTime = currentTickTime;
    }

    public boolean tick() {
        int workDone;
        this.acceptedKeys.clear();
        if (this.priorityQueue.isEmpty() && this.queue.isEmpty()) {
            return true;
        }
        long coreKey = this.land.getCorePos().method_10063();
        int initialQueueSize = this.queue.size() + this.priorityQueue.size();
        for (workDone = 0; !(workDone >= this.maxWorkPerTick || this.priorityQueue.isEmpty() && this.queue.isEmpty()); ++workDone) {
            boolean hasNeighbor;
            long key = !this.priorityQueue.isEmpty() ? this.priorityQueue.dequeueLong() : this.queue.dequeueLong();
            if (this.invalid.contains(key)) continue;
            boolean blockedPath = ClaimUtils.pathContainsInvalidBlock(this.world, class_2338.method_10092((long)coreKey), class_2338.method_10092((long)key), this.land.getLandType());
            boolean bl = hasNeighbor = this.totalAccepted == 0 || this.fastHasAcceptedNeighbor(key);
            if (blockedPath && !hasNeighbor) {
                this.queue.enqueue(key);
                continue;
            }
            this.acceptedKeys.add(key);
            this.updateNeighborMask(key);
            ++this.totalAccepted;
            ++this.claimsThisPeriod;
        }
        if (!this.acceptedKeys.isEmpty()) {
            this.land.addClaims((Collection<Long>)this.acceptedKeys);
            this.claimsSinceLastZeroCheck += this.acceptedKeys.size();
            LandState.get(this.world).markClaimed((Collection<Long>)this.acceptedKeys, this.land);
        }
        this.logProgress();
        if (this.priorityQueue.isEmpty() && this.queue.isEmpty() || workDone == 0 && this.queue.size() + this.priorityQueue.size() == initialQueueSize) {
            this.finish();
            return true;
        }
        return false;
    }

    private void logProgress() {
        ++this.logTick;
        long now = this.world.method_8503().method_3780();
        double seconds = (double)(now - this.lastZeroCpsCheckTime) / 20.0;
        if (seconds > 0.0) {
            double cps = (double)this.claimsSinceLastZeroCheck / seconds;
            if (cps != 0.0) {
                this.tickCPS = 0;
            }
            if (cps == 0.0) {
                if (this.tickCPS >= this.requiredTicksForZeroCpsStop * 5000 / StoneyCore.getConfig().technicalOptions.maxWorkPerTick()) {
                    StoneyCore.LOGGER.info("[ClaimWorker] Stopping early due to 0 CPS check.");
                    this.queue.clear();
                    this.priorityQueue.clear();
                } else {
                    ++this.tickCPS;
                }
            } else if (this.logTick >= 10) {
                seconds = (double)(now - this.lastLogTime) / 20.0;
                if (seconds > 0.0) {
                    cps = (double)this.claimsThisPeriod / seconds;
                    StoneyCore.LOGGER.info("[ClaimWorker] Progress: {} claims so far (~{} CPS avg)", (Object)this.totalAccepted, (Object)cps);
                }
                this.claimsThisPeriod = 0;
                this.lastLogTime = now;
                this.logTick = 0;
            }
        }
        this.claimsSinceLastZeroCheck = 0;
        this.lastZeroCpsCheckTime = now;
    }

    private void finish() {
        long elapsed = (long)this.world.method_8503().method_3780() - this.startTime;
        double totalCps = (double)this.totalAccepted / ((double)elapsed / 20.0);
        StoneyCore.LOGGER.info("[ClaimWorker] Finished claiming {} blocks in {} ticks (~{} CPS) for land '{}'.", new Object[]{this.totalAccepted, elapsed, totalCps, this.land.getLandTitle(this.world).getString()});
        this.onComplete.accept(this.totalAccepted > 0);
    }

    private boolean fastHasAcceptedNeighbor(long key) {
        long xyNormalizedKey = class_2338.method_10064((int)class_2338.method_10061((long)key), (int)0, (int)class_2338.method_10083((long)key));
        return this.neighborMask.get(xyNormalizedKey) != 0;
    }

    private void updateNeighborMask(long key) {
        int x = class_2338.method_10061((long)key);
        int z = class_2338.method_10083((long)key);
        for (int i = 0; i < NEIGHBOR_OFFSETS.length; ++i) {
            int nx = x + NEIGHBOR_OFFSETS[i][0];
            int nz = z + NEIGHBOR_OFFSETS[i][1];
            long neighborKey = class_2338.method_10064((int)nx, (int)0, (int)nz);
            this.neighborMask.addTo(neighborKey, (byte)(1 << i));
        }
    }
}

