/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.servertick;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.networking.ModMessages;
import banduty.stoneycore.siege.SiegeManager;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.data.playerdata.IEntityDataSaver;
import banduty.stoneycore.util.data.playerdata.PDKeys;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class LandTracker {
    private static final Map<UUID, class_2338> lastLandCore = new HashMap<UUID, class_2338>();
    private static final Map<UUID, class_2338> lastPlayerPos = new HashMap<UUID, class_2338>();

    public static void trackPlayerLandMovement(class_3222 player) {
        UUID uuid;
        class_2338 lastPos;
        class_2338 currentPos = player.method_24515();
        class_3218 world = player.method_51469();
        LandState landState = LandState.get(world);
        Optional<Land> optionalLand = landState.getLandAt(currentPos);
        player.method_51469().method_18456().forEach(otherPlayer -> {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10797(player.method_5667());
            buf.writeBoolean(optionalLand.isPresent());
            optionalLand.ifPresent(land -> buf.method_10807(land.getCorePos()));
            buf.writeBoolean(SiegeManager.isPlayerInLandUnderSiege(player.method_51469(), (class_1657)player));
            buf.writeBoolean(SiegeManager.getPlayerSiege(player.method_51469(), player.method_5667()).map(siege -> !siege.disabledPlayers.contains(player.method_5667())).orElse(false).booleanValue());
            ServerPlayNetworking.send((class_3222)otherPlayer, (class_2960)ModMessages.LAND_CLIENT_DATA_S2C_ID, (class_2540)buf);
        });
        if (StoneyCore.getConfig().landOptions.hungerSiege() && SiegeManager.isPlayerInLandUnderSiege(player.method_51469(), (class_1657)player)) {
            player.method_6092(new class_1293(class_1294.field_5903, 80, 0, false, false, true));
        }
        if ((lastPos = lastPlayerPos.get(uuid = player.method_5667())) != null && lastPos.equals((Object)currentPos)) {
            return;
        }
        lastPlayerPos.put(uuid, currentPos);
        if (optionalLand.isEmpty()) {
            lastLandCore.put(uuid, null);
            return;
        }
        class_2338 newCore = optionalLand.get().getCorePos();
        class_2338 prevCore = lastLandCore.get(uuid);
        if (!Objects.equals(prevCore, newCore)) {
            lastLandCore.put(uuid, newCore);
            if (newCore != null) {
                if (!NBTDataHelper.get((IEntityDataSaver)player, PDKeys.LAND_EXPANDED, Boolean.valueOf(false)).booleanValue()) {
                    Land land = optionalLand.get();
                    LandTracker.sendTitle(player, land.getLandTitle(world));
                } else {
                    NBTDataHelper.set((IEntityDataSaver)player, PDKeys.LAND_EXPANDED, Boolean.valueOf(false));
                }
            }
        }
    }

    private static void sendTitle(class_3222 player, class_2561 mainTitle) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10805(mainTitle);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.LAND_TITLE_PACKET_ID, (class_2540)buffer);
    }
}

