/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.servertick;

import banduty.stoneycore.util.definitionsloader.WeaponDefinitionsLoader;
import banduty.stoneycore.util.weaponutil.SCWeaponUtil;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import java.util.UUID;
import net.bettercombat.api.AttackHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public class ModifiersUtil {
    private static final UUID ATTACK_RANGE_MODIFIER_ID = UUID.randomUUID();
    private static final UUID RANGE_MODIFIER_ID = UUID.randomUUID();

    public static void updatePlayerReachAttributes(class_3222 player) {
        boolean shouldHaveModifier;
        if (player == null) {
            return;
        }
        AttackHand hand = null;
        if (player instanceof PlayerAttackProperties) {
            PlayerAttackProperties props = (PlayerAttackProperties)player;
            hand = PlayerAttackHelper.getCurrentAttack((class_1657)player, (int)props.getComboCount());
        }
        class_1799 itemStack = player.method_6047();
        if (hand != null) {
            itemStack = hand.itemStack();
        }
        class_1324 attackRangeAttribute = player.method_5996(ReachEntityAttributes.ATTACK_RANGE);
        class_1324 rangeAttribute = player.method_5996(ReachEntityAttributes.REACH);
        boolean bl = shouldHaveModifier = !itemStack.method_7960() && WeaponDefinitionsLoader.isMelee(itemStack);
        if (shouldHaveModifier) {
            double extraReach = SCWeaponUtil.getMaxDistance(itemStack.method_7909());
            ModifiersUtil.updateModifier(attackRangeAttribute, ATTACK_RANGE_MODIFIER_ID, "Stoneycore attack range", extraReach);
            ModifiersUtil.updateModifier(rangeAttribute, RANGE_MODIFIER_ID, "Stoneycore range", extraReach);
        } else {
            ModifiersUtil.removeModifierIfPresent(attackRangeAttribute, ATTACK_RANGE_MODIFIER_ID);
            ModifiersUtil.removeModifierIfPresent(rangeAttribute, RANGE_MODIFIER_ID);
        }
    }

    private static void updateModifier(class_1324 attribute, UUID uuid, String name, double value) {
        if (attribute == null) {
            return;
        }
        class_1322 existingModifier = attribute.method_6199(uuid);
        if (existingModifier == null || existingModifier.method_6186() != value) {
            attribute.method_6200(uuid);
            attribute.method_26835(new class_1322(uuid, name, value, class_1322.class_1323.field_6328));
        }
    }

    private static void removeModifierIfPresent(class_1324 attribute, UUID uuid) {
        if (attribute != null && attribute.method_6199(uuid) != null) {
            attribute.method_6200(uuid);
        }
    }
}

