/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.commands.land;

import banduty.stoneycore.commands.SCCommandsHandler;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandState;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class Ally {
    public static LiteralArgumentBuilder<class_2168> registerAlly() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"ally").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"owner", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            for (class_3222 player : ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571()) {
                UUID uuid = player.method_5667();
                if (!LandState.get(world).getLandByOwner(uuid).isPresent()) continue;
                builder.suggest(player.method_7334().getName());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"newAlly", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Optional<Land> ownerLandOpt;
            class_2168 src = (class_2168)ctx.getSource();
            class_3218 world = src.method_9225();
            String ownerName = StringArgumentType.getString((CommandContext)ctx, (String)"owner");
            UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
            if (ownerUUID != null && (ownerLandOpt = LandState.get(world).getLandByOwner(ownerUUID)).isPresent()) {
                Land ownerLand = ownerLandOpt.get();
                for (class_3222 player : src.method_9211().method_3760().method_14571()) {
                    UUID uuid = player.method_5667();
                    if (uuid.equals(ownerUUID) || ownerLand.isAlly(uuid)) continue;
                    builder.suggest(player.method_7334().getName());
                }
            }
            return builder.buildFuture();
        }).executes(ctx -> Ally.addAlly((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"owner"), StringArgumentType.getString((CommandContext)ctx, (String)"newAlly")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"ally", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Optional<Land> ownerLandOpt;
            class_2168 src = (class_2168)ctx.getSource();
            class_3218 world = src.method_9225();
            String ownerName = StringArgumentType.getString((CommandContext)ctx, (String)"owner");
            UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
            if (ownerUUID != null && (ownerLandOpt = LandState.get(world).getLandByOwner(ownerUUID)).isPresent()) {
                Land ownerLand = ownerLandOpt.get();
                for (UUID allyUUID : ownerLand.getAllies()) {
                    class_3222 allyPlayer = src.method_9211().method_3760().method_14602(allyUUID);
                    if (allyPlayer == null) continue;
                    builder.suggest(allyPlayer.method_7334().getName());
                }
            }
            return builder.buildFuture();
        }).executes(ctx -> Ally.removeAlly((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"owner"), StringArgumentType.getString((CommandContext)ctx, (String)"ally")))))).then(class_2170.method_9247((String)"get").executes(ctx -> Ally.getAlly((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"owner")))));
    }

    private static int addAlly(class_2168 src, String ownerName, String newAllyName) {
        UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
        UUID newAllyUUID = SCCommandsHandler.getUUID(src, newAllyName);
        if (ownerUUID == null) {
            return SCCommandsHandler.error(src, "Unknown owner " + ownerName);
        }
        if (newAllyUUID == null) {
            return SCCommandsHandler.error(src, "Unknown player " + newAllyName);
        }
        class_3218 world = src.method_9225();
        LandState state = LandState.get(world);
        Optional<Land> ownerLandOpt = state.getLandByOwner(ownerUUID);
        if (ownerLandOpt.isEmpty()) {
            return SCCommandsHandler.error(src, ownerName + " doesn\u2019t own a Land");
        }
        if (state.getLandByPlayer(newAllyUUID).isPresent()) {
            return SCCommandsHandler.error(src, newAllyName + " already is part of a Land");
        }
        Land ownerLand = ownerLandOpt.get();
        if (ownerLand.getMaxAllies() > 0 && ownerLand.getAllies().size() >= ownerLand.getMaxAllies()) {
            return SCCommandsHandler.error(src, ownerName + " Land has reached the max amount of allies");
        }
        ownerLand.addAlly(newAllyUUID);
        src.method_9226(() -> class_2561.method_43470((String)(newAllyName + " is now an ally of " + ownerName)), true);
        return 1;
    }

    private static int removeAlly(class_2168 src, String ownerName, String allyName) {
        UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
        UUID oldAllyUUID = SCCommandsHandler.getUUID(src, allyName);
        if (ownerUUID == null) {
            return SCCommandsHandler.error(src, "Unknown owner " + ownerName);
        }
        if (oldAllyUUID == null) {
            return SCCommandsHandler.error(src, "Unknown player " + allyName);
        }
        class_3218 world = src.method_9225();
        LandState state = LandState.get(world);
        Optional<Land> ownerLandOpt = state.getLandByOwner(ownerUUID);
        if (ownerLandOpt.isEmpty()) {
            return SCCommandsHandler.error(src, ownerName + " doesn\u2019t own a Land");
        }
        Land ownerLand = ownerLandOpt.get();
        if (!ownerLand.getAllies().contains(oldAllyUUID)) {
            return SCCommandsHandler.error(src, allyName + " isn\u2019t part of this Land");
        }
        ownerLand.removeAlly(oldAllyUUID);
        src.method_9226(() -> class_2561.method_43470((String)(allyName + " was removed from " + ownerName + "'s allies")), true);
        return 1;
    }

    private static int getAlly(class_2168 src, String ownerName) {
        UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
        if (ownerUUID == null) {
            return SCCommandsHandler.error(src, "Unknown owner " + ownerName);
        }
        class_3218 world = src.method_9225();
        Optional<Land> ownerLandOpt = LandState.get(world).getLandByOwner(ownerUUID);
        if (ownerLandOpt.isEmpty()) {
            return SCCommandsHandler.error(src, ownerName + " doesn\u2019t own a Land");
        }
        Land ownerLand = ownerLandOpt.get();
        if (ownerLand.getAllies().isEmpty()) {
            src.method_9226(() -> class_2561.method_43470((String)(ownerName + " has no allies")), false);
        } else {
            StringBuilder alliesList = new StringBuilder();
            for (UUID allyUUID : ownerLand.getAllies()) {
                String allyName;
                class_3222 allyPlayer = src.method_9211().method_3760().method_14602(allyUUID);
                String string = allyName = allyPlayer != null ? allyPlayer.method_7334().getName() : allyUUID.toString();
                if (!alliesList.isEmpty()) {
                    alliesList.append(", ");
                }
                alliesList.append(allyName);
            }
            src.method_9226(() -> class_2561.method_43470((String)(ownerName + "'s allies: " + String.valueOf(alliesList))), false);
        }
        return 1;
    }
}

