/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.event;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.lands.util.ClaimWorker;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.siege.SiegeManager;
import banduty.stoneycore.util.WeightUtil;
import banduty.stoneycore.util.render.OutlineClaimRenderer;
import banduty.stoneycore.util.servertick.ArmorUtil;
import banduty.stoneycore.util.servertick.LandTracker;
import banduty.stoneycore.util.servertick.MechanicsUtil;
import banduty.stoneycore.util.servertick.ModifiersUtil;
import banduty.stoneycore.util.servertick.StaminaUtil;
import banduty.stoneycore.util.servertick.SwallowTailArrowUtil;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;

public class StartTickHandler
implements ServerTickEvents.StartTick {
    public static final Queue<ClaimWorker> CLAIM_TASKS = new LinkedList<ClaimWorker>();
    private static final UUID POWDER_SNOW_SLOW_ID = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ce");

    public void onStartTick(MinecraftServer server) {
        this.processClaimTasks();
        WeightUtil.clearCache();
        for (class_3222 player : server.method_3760().method_14571()) {
            if (player.method_7325()) continue;
            this.updatePlayerTick(player);
        }
        for (class_3218 world : server.method_3738()) {
            this.checkAndRemoveBrokenLands(world);
            SiegeManager.tick(world);
        }
    }

    private void processClaimTasks() {
        ClaimWorker current = CLAIM_TASKS.peek();
        if (current != null && current.tick()) {
            CLAIM_TASKS.poll();
        }
    }

    private void updatePlayerTick(class_3222 player) {
        boolean isDead = player.method_6032() <= 0.0f;
        WeightUtil.setCachedWeight((class_1309)player);
        ModifiersUtil.updatePlayerReachAttributes(player);
        StaminaUtil.startStaminaTrack((class_1309)player);
        if (!isDead) {
            if (AccessoriesCapability.getOptionally((class_1309)player).isPresent()) {
                for (SlotEntryReference equipped : AccessoriesCapability.get((class_1309)player).getAllEquipped()) {
                    class_1799 equippedStack = equipped.stack();
                    if (!equippedStack.method_31573(class_3489.field_28041)) continue;
                    player.method_32317(0);
                    class_1324 entityAttributeInstance = player.method_5996(class_5134.field_23719);
                    if (entityAttributeInstance == null || entityAttributeInstance.method_6199(POWDER_SNOW_SLOW_ID) == null) break;
                    entityAttributeInstance.method_6200(POWDER_SNOW_SLOW_ID);
                    break;
                }
            }
            if (StoneyCore.getConfig().combatOptions.getParry()) {
                MechanicsUtil.handleParry(player);
            }
            MechanicsUtil.handlePlayerReload(player);
            ArmorUtil.startArmorCheck(player);
            SwallowTailArrowUtil.startSwallowTailTickTrack((class_1657)player);
            LandTracker.trackPlayerLandMovement(player);
        } else {
            UUID playerId = player.method_5667();
            SiegeManager.getPlayerSiege(player.method_51469(), playerId).ifPresent(siege -> siege.disablePlayer(playerId, player.method_51469()));
        }
        OutlineClaimRenderer.renderOutlineClaim(player);
    }

    private void checkAndRemoveBrokenLands(class_3218 world) {
        LandState state = LandState.get(world);
        ArrayList<Land> toRemove = new ArrayList<Land>();
        for (Land land : state.getAllLands()) {
            if (world.method_8320(land.getCorePos()).method_26204() == land.getLandType().coreBlock()) continue;
            toRemove.add(land);
        }
        for (Land land : toRemove) {
            state.removeLand(land);
            for (class_3222 player : world.method_18456()) {
                if (player.method_7325()) continue;
                player.method_7353((class_2561)class_2561.method_43469((String)("text.land." + land.getLandType().id().method_12836() + ".fall"), (Object[])new Object[]{land.getLandTitle(world).getString()}), true);
            }
        }
    }
}

