/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.lands.util;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.event.StartTickHandler;
import banduty.stoneycore.lands.LandType;
import banduty.stoneycore.lands.LandTypeRegistry;
import banduty.stoneycore.lands.util.ClaimWorker;
import banduty.stoneycore.lands.util.LandColors;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.networking.ModMessages;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.data.playerdata.IEntityDataSaver;
import banduty.stoneycore.util.data.playerdata.PDKeys;
import banduty.streq.StrEq;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class Land {
    private UUID owner;
    private int radius;
    private final class_2338 corePos;
    private String name;
    private final int maxAllies;
    private long expandItemStored = 0L;
    private final LandType landType;
    private final Set<UUID> allies = new HashSet<UUID>();
    private final LongSet claimed = new LongOpenHashSet();

    public Land(UUID owner, class_2338 coreBlock, int radius, LandType landType, String name, int maxAllies) {
        this.owner = owner;
        this.corePos = coreBlock;
        this.radius = radius;
        this.landType = landType;
        this.name = name;
        this.maxAllies = maxAllies;
    }

    public void initializeClaim(class_3218 world, int radius, Queue<ClaimWorker> taskQueue) {
        long coreX = this.corePos.method_10263();
        long coreZ = this.corePos.method_10260();
        long limit2 = (long)radius * (long)radius;
        LandState state = LandState.get(world);
        ArrayList<class_2338> candidates = new ArrayList<class_2338>((int)(Math.PI * (double)radius * (double)radius));
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                class_2338 pos;
                if ((long)dx * (long)dx + (long)dz * (long)dz > limit2 || !state.getLandAt(pos = new class_2338((int)(coreX + (long)dx), 0, (int)(coreZ + (long)dz))).map(l -> l.owner.equals(this.owner)).orElse(true).booleanValue()) continue;
                candidates.add(pos);
            }
        }
        ClaimWorker worker = this.getClaimWorker(world, candidates, radius);
        this.radius = radius;
        taskQueue.add(worker);
    }

    @NotNull
    private ClaimWorker getClaimWorker(class_3218 world, List<class_2338> candidates, int radius) {
        return new ClaimWorker(world, this, candidates, radius, success -> {});
    }

    public void depositExpandItem(class_1657 player, class_3218 world, int amount) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayerEntity = (class_3222)player;
        LandState state = LandState.get(world);
        this.expandItemStored += (long)amount;
        int radiusToIncrease = 0;
        long totalCost = 0L;
        double testRadius = this.radius;
        int maxRadius = StoneyCore.getConfig().technicalOptions.maxLandExpandRadius();
        double maxAllowedRadius = maxRadius < 0 ? Double.MAX_VALUE : (double)(maxRadius + this.landType.baseRadius());
        HashMap<String, Double> vars = new HashMap<String, Double>(1);
        String formula = this.landType.expandFormula();
        while (testRadius < maxAllowedRadius) {
            vars.put("radius", testRadius);
            int cost = Math.max(0, (int)StrEq.evaluate((String)formula, vars));
            if (totalCost + (long)cost > this.expandItemStored) break;
            totalCost += (long)cost;
            testRadius += 1.0;
            ++radiusToIncrease;
        }
        if (radiusToIncrease <= 0) {
            player.method_7353((class_2561)class_2561.method_43469((String)("text.land." + this.landType.id().method_12836() + ".stored"), (Object[])new Object[]{this.expandItemStored}), true);
            return;
        }
        this.expandItemStored -= totalCost;
        Land newLand = this.copy();
        newLand.initializeClaim(world, this.radius + radiusToIncrease, StartTickHandler.CLAIM_TASKS);
        state.removeLand(this);
        state.addLand(newLand);
        Land.sendTitle(serverPlayerEntity, (class_2561)class_2561.method_43469((String)"text.land.stoneycore.expansion.increased", (Object[])new Object[]{this.radius, this.radius + radiusToIncrease}));
        NBTDataHelper.set((IEntityDataSaver)player, PDKeys.LAND_EXPANDED, Boolean.valueOf(true));
    }

    public Land copy() {
        Land copy = new Land(this.owner, this.corePos, this.radius, this.landType, this.name, this.maxAllies);
        copy.expandItemStored = this.expandItemStored;
        copy.allies.addAll(this.allies);
        return copy;
    }

    private static void sendTitle(class_3222 player, class_2561 mainTitle) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10805(mainTitle);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.LAND_TITLE_PACKET_ID, (class_2540)buffer);
    }

    public long getNeededExpandItemAmount() {
        String formula = this.landType.expandFormula();
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("radius", Double.valueOf(this.radius));
        return Math.max(1, (int)StrEq.evaluate((String)formula, variables));
    }

    public class_2338 getCorePos() {
        return this.corePos;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius, class_3218 world) {
        int actualRadius = this.radius;
        this.radius = radius;
        if (actualRadius > radius) {
            this.removeClaimsOutsideRadius(world);
        }
    }

    public void removeClaimsOutsideRadius(class_3218 world) {
        if (this.claimed.isEmpty()) {
            return;
        }
        long coreX = this.corePos.method_10263();
        long coreZ = this.corePos.method_10260();
        long limit2 = (long)this.radius * (long)this.radius;
        ArrayList<Long> toRemove = new ArrayList<Long>();
        Object object = this.claimed.iterator();
        while (object.hasNext()) {
            long dz;
            long posKey = (Long)object.next();
            class_2338 pos = class_2338.method_10092((long)posKey);
            long dx = (long)pos.method_10263() - coreX;
            if (dx * dx + (dz = (long)pos.method_10260() - coreZ) * dz <= limit2) continue;
            toRemove.add(posKey);
        }
        if (!toRemove.isEmpty()) {
            object = toRemove.iterator();
            while (object.hasNext()) {
                long key = (Long)object.next();
                this.claimed.remove(key);
            }
            LandState.get(world).unmarkClaimed(toRemove);
        }
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwnerUUID(UUID owner) {
        this.owner = owner;
    }

    public static String getOwnerName(class_3218 world, UUID uuid) {
        class_3222 player = world.method_8503().method_3760().method_14602(uuid);
        if (player != null) {
            return player.method_7334().getName();
        }
        if (world.method_8503().method_3793() == null) {
            return "Unknown";
        }
        GameProfile profile = world.method_8503().method_3793().method_14512(uuid).orElse(null);
        return profile != null ? profile.getName() : "Unknown";
    }

    public long getExpandItemStored() {
        return this.expandItemStored;
    }

    public boolean isAlreadyClaimed(long key) {
        return this.claimed.contains(key);
    }

    public void addClaims(Collection<Long> keys) {
        this.claimed.addAll(keys);
    }

    public Set<class_2338> getClaimed() {
        HashSet set = new HashSet(this.claimed.size());
        this.claimed.forEach(posKey -> set.add(class_2338.method_10092((long)posKey)));
        return Collections.unmodifiableSet(set);
    }

    public Set<UUID> getAllies() {
        return Collections.unmodifiableSet(this.allies);
    }

    public void addAlly(UUID playerUuid) {
        this.allies.add(playerUuid);
    }

    public void removeAlly(UUID playerUuid) {
        this.allies.remove(playerUuid);
    }

    public boolean isAlly(UUID playerUuid) {
        return this.allies.contains(playerUuid);
    }

    public LandType getLandType() {
        return this.landType;
    }

    public class_2561 getLandTitle(class_3218 serverWorld) {
        if (!this.getName().isBlank()) {
            return class_2561.method_43470((String)this.getName());
        }
        return class_2561.method_43469((String)("text.land." + this.getLandType().id().method_12836() + ".land_name"), (Object[])new Object[]{Land.getOwnerName(serverWorld, this.getOwnerUUID())});
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = !name.isBlank() ? name : this.name;
    }

    public class_5250 getLandTag(class_3218 serverWorld) {
        return class_2561.method_43470((String)"[").method_10852(this.getLandTitle(serverWorld)).method_27693("]").method_10862(class_2583.field_24360.method_10977(LandColors.getColorForLand(this)));
    }

    public int getMaxAllies() {
        return this.maxAllies;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_25927("Owner", this.owner);
        nbt.method_10569("Radius", this.radius);
        nbt.method_10582("CustomName", this.name);
        nbt.method_10544("CorePos", this.corePos.method_10063());
        nbt.method_10544("ExpandItemStored", this.expandItemStored);
        nbt.method_10569("MaxAllies", this.maxAllies);
        class_2499 claims = new class_2499();
        LongIterator longIterator = this.claimed.iterator();
        while (longIterator.hasNext()) {
            long posKey = (Long)longIterator.next();
            claims.add((Object)class_2503.method_23251((long)posKey));
        }
        nbt.method_10566("Claims", (class_2520)claims);
        class_2499 alliesList = new class_2499();
        for (UUID ally : this.allies) {
            alliesList.add((Object)class_2519.method_23256((String)ally.toString()));
        }
        nbt.method_10566("Allies", (class_2520)alliesList);
        nbt.method_10582("LandType", this.landType.id().toString());
        return nbt;
    }

    public static Land fromNbt(class_2487 nbt) {
        UUID owner = nbt.method_25926("Owner");
        int radius = nbt.method_10550("Radius");
        String name = nbt.method_10558("CustomName");
        class_2338 corePos = class_2338.method_10092((long)nbt.method_10537("CorePos"));
        class_2960 landTypeId = new class_2960(nbt.method_10558("LandType"));
        int maxAllies = nbt.method_10550("MaxAllies");
        LandType landType = LandTypeRegistry.getById(landTypeId).orElseThrow(() -> new IllegalStateException("Unknown LandType: " + String.valueOf(landTypeId)));
        Land k = new Land(owner, corePos, radius, landType, name, maxAllies);
        k.expandItemStored = nbt.method_10537("ExpandItemStored");
        class_2499 claims = nbt.method_10554("Claims", 4);
        for (class_2520 claim : claims) {
            long posKey = ((class_2503)claim).method_10699();
            k.claimed.add(posKey);
        }
        if (nbt.method_10573("Allies", 9)) {
            class_2499 alliesList = nbt.method_10554("Allies", 8);
            for (class_2520 element : alliesList) {
                try {
                    UUID allyUuid = UUID.fromString(element.method_10714());
                    k.allies.add(allyUuid);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return k;
    }
}

