/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.lands.util;

import banduty.stoneycore.lands.util.Land;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class LandState
extends class_18 {
    private final Map<class_2338, Land> landMap = new HashMap<class_2338, Land>();
    private final Map<class_2338, Land> claimedChunks = new HashMap<class_2338, Land>();
    private final Map<UUID, Land> ownerMap = new HashMap<UUID, Land>();

    private static class_2338 toColumn(class_2338 pos) {
        return new class_2338(pos.method_10263(), 0, pos.method_10260());
    }

    public static LandState get(class_3218 world) {
        return (LandState)world.method_17983().method_17924(LandState::fromNbt, LandState::new, "lands");
    }

    public void addLand(Land land) {
        this.landMap.put(land.getCorePos(), land);
        this.ownerMap.put(land.getOwnerUUID(), land);
        for (class_2338 pos : land.getClaimed()) {
            this.claimedChunks.put(pos, land);
        }
        this.method_80();
    }

    public void removeLand(Land land) {
        this.landMap.remove(land.getCorePos());
        this.ownerMap.remove(land.getOwnerUUID());
        for (class_2338 pos : land.getClaimed()) {
            this.claimedChunks.remove(pos);
        }
        this.method_80();
    }

    public Optional<Land> getLandByOwner(UUID owner) {
        return Optional.ofNullable(this.ownerMap.get(owner));
    }

    public Optional<Land> getLandByPlayer(UUID playerUUID) {
        Land land = this.ownerMap.get(playerUUID);
        if (land != null) {
            return Optional.of(land);
        }
        for (Land l : this.landMap.values()) {
            if (!l.isAlly(playerUUID)) continue;
            return Optional.of(l);
        }
        return Optional.empty();
    }

    public Collection<Land> getAllLands() {
        return Collections.unmodifiableCollection(this.landMap.values());
    }

    public boolean isLandRegistered(Land land) {
        return this.landMap.containsKey(land.getCorePos());
    }

    public boolean isClaimed(class_2338 pos) {
        return this.getLandAt(pos).isPresent();
    }

    public boolean isOwner(class_2338 pos, UUID uuid) {
        return this.getLandAt(pos).map(k -> k.getOwnerUUID().equals(uuid)).orElse(false);
    }

    public boolean isAllay(class_2338 pos, UUID uuid) {
        return this.getLandAt(pos).map(k -> k.isAlly(uuid)).orElse(false);
    }

    public Optional<Land> getLandAt(class_2338 pos) {
        class_2338 column = LandState.toColumn(pos);
        return Optional.ofNullable(this.claimedChunks.get(column));
    }

    public Optional<Land> getLandAtCorePos(class_2338 blockPos) {
        return Optional.ofNullable(this.landMap.get(blockPos));
    }

    public void markClaimed(Collection<Long> keys, Land land) {
        for (long key : keys) {
            class_2338 pos = class_2338.method_10092((long)key);
            this.claimedChunks.put(pos, land);
        }
        this.method_80();
    }

    public void unmarkClaimed(Collection<Long> keys) {
        for (long key : keys) {
            class_2338 pos = class_2338.method_10092((long)key);
            this.claimedChunks.remove(pos);
        }
        this.method_80();
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (Land land : this.landMap.values()) {
            list.add((Object)land.toNbt());
        }
        nbt.method_10566("Lands", (class_2520)list);
        return nbt;
    }

    public static LandState fromNbt(class_2487 nbt) {
        LandState state = new LandState();
        class_2499 list = nbt.method_10554("Lands", 10);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Land land = Land.fromNbt(list.method_10602(i));
            state.landMap.put(land.getCorePos(), land);
            state.ownerMap.put(land.getOwnerUUID(), land);
            for (class_2338 pos : land.getClaimed()) {
                state.claimedChunks.put(pos, land);
            }
        }
        return state;
    }
}

