/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.mixin;

import banduty.stoneycore.combat.range.RangedWeaponHandlers;
import banduty.stoneycore.items.armor.SCAccessoryItem;
import banduty.stoneycore.util.SCDamageCalculator;
import banduty.stoneycore.util.data.itemdata.INBTKeys;
import banduty.stoneycore.util.data.itemdata.SCTags;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.data.playerdata.IEntityDataSaver;
import banduty.stoneycore.util.data.playerdata.StaminaData;
import banduty.stoneycore.util.definitionsloader.WeaponDefinitionsLoader;
import banduty.stoneycore.util.patterns.PatternHelper;
import banduty.stoneycore.util.weaponutil.SCRangeWeaponUtil;
import banduty.stoneycore.util.weaponutil.SCWeaponUtil;
import banduty.stoneycore.util.weaponutil.TooltipClientSide;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1792.class})
public abstract class ItemMixin {
    @Shadow
    public abstract class_1839 method_7853(class_1799 var1);

    @Inject(method={"getUseAction"}, at={@At(value="HEAD")}, cancellable=true)
    public void stoneycore$getUseAction(class_1799 stack, CallbackInfoReturnable<class_1839> cir) {
        if (WeaponDefinitionsLoader.isMelee(stack)) {
            boolean isShield = stack.method_31573(SCTags.WEAPONS_SHIELD.getTag());
            cir.setReturnValue((Object)(isShield ? class_1839.field_8949 : class_1839.field_8952));
            return;
        }
        if (WeaponDefinitionsLoader.isRanged(stack)) {
            class_1839 configured = WeaponDefinitionsLoader.getData(stack).ranged().useAction();
            cir.setReturnValue((Object)(configured == class_1839.field_8953 ? class_1839.field_8953 : class_1839.field_8952));
        }
    }

    @Inject(method={"getMaxUseTime"}, at={@At(value="HEAD")}, cancellable=true)
    public void stoneycore$getMaxUseTime(class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        if (WeaponDefinitionsLoader.isRanged(stack)) {
            cir.setReturnValue((Object)WeaponDefinitionsLoader.getData(stack).ranged().maxUseTime());
            return;
        }
        if (WeaponDefinitionsLoader.isMelee(stack) && stack.method_31573(SCTags.WEAPONS_SHIELD.getTag())) {
            cir.setReturnValue((Object)72000);
        }
    }

    @Inject(method={"usageTick"}, at={@At(value="HEAD")})
    public void stoneycore$usageTick(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks, CallbackInfo ci) {
        class_1657 playerEntity;
        IEntityDataSaver dataSaver;
        if (user instanceof class_1657 && StaminaData.isStaminaBlocked(dataSaver = (IEntityDataSaver)(playerEntity = (class_1657)user))) {
            playerEntity.method_6021();
        }
        if (world.field_9236) {
            return;
        }
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        if (!WeaponDefinitionsLoader.isRanged(stack)) {
            return;
        }
        int useTime = WeaponDefinitionsLoader.getData(stack).ranged().maxUseTime() - remainingUseTicks;
        if (RangedWeaponHandlers.get(WeaponDefinitionsLoader.getData(stack).ranged().id()).isPresent()) {
            RangedWeaponHandlers.get(WeaponDefinitionsLoader.getData(stack).ranged().id()).get().handleUsageTick(world, stack, player, useTime);
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void stoneycore$use(class_1937 world, class_1657 user, class_1268 hand, CallbackInfoReturnable<class_1271<class_1799>> cir) {
        class_1799 stack = user.method_5998(hand);
        if (this.method_7853(stack) == class_1839.field_8946 || this.method_7853(stack) == class_1839.field_8950) {
            Optional.ofNullable(AccessoriesCapability.getOptionally((class_1309)user)).filter(Optional::isPresent).ifPresent(o -> {
                for (SlotEntryReference equipped : AccessoriesCapability.get((class_1309)user).getAllEquipped()) {
                    class_1799 itemStack = equipped.stack();
                    if (user.method_7337()) break;
                    if (NBTDataHelper.get(itemStack, INBTKeys.VISOR_OPEN, Boolean.valueOf(false)).booleanValue() || !itemStack.method_31573(SCTags.VISORED_HELMET.getTag())) continue;
                    user.method_7353((class_2561)class_2561.method_43471((String)"text.tooltip.stoneycore.openVisorEatDrink"), true);
                    cir.setReturnValue((Object)class_1271.method_22431((Object)stack));
                    return;
                }
            });
        }
        if (hand == class_1268.field_5808 && !user.method_6079().method_7960() && WeaponDefinitionsLoader.isMelee(stack)) {
            cir.setReturnValue((Object)class_1271.method_22431((Object)stack));
            return;
        }
        if (hand == class_1268.field_5810) {
            return;
        }
        if (WeaponDefinitionsLoader.isMelee(stack)) {
            this.handleWeaponUse(world, user, hand, stack, cir);
        } else if (WeaponDefinitionsLoader.isRanged(stack)) {
            this.handleRangeWeaponUse(world, user, hand, stack, cir);
        }
    }

    @Unique
    private void handleWeaponUse(class_1937 world, class_1657 user, class_1268 hand, class_1799 stack, CallbackInfoReturnable<class_1271<class_1799>> cir) {
        if (!world.field_9236 && user.method_5715() && this.isBludgeoningWeapon(stack.method_7909())) {
            this.toggleBludgeoningMode(stack);
            cir.setReturnValue((Object)class_1271.method_22427((Object)stack));
            return;
        }
        IEntityDataSaver dataSaver = (IEntityDataSaver)user;
        if (StaminaData.isStaminaBlocked(dataSaver)) {
            user.method_6021();
            cir.setReturnValue((Object)class_1271.method_22431((Object)stack));
            return;
        }
        if (stack.method_31573(SCTags.WEAPONS_SHIELD.getTag())) {
            user.method_6019(hand);
            cir.setReturnValue((Object)class_1271.method_22428((Object)stack));
            return;
        }
        cir.setReturnValue((Object)class_1271.method_22431((Object)stack));
    }

    @Unique
    private boolean isBludgeoningWeapon(class_1792 item) {
        return SCWeaponUtil.getDamageValues(SCDamageCalculator.DamageType.BLUDGEONING, item) > 0.0;
    }

    @Unique
    private void toggleBludgeoningMode(class_1799 stack) {
        boolean current = NBTDataHelper.get(stack, INBTKeys.BLUDGEONING, Boolean.valueOf(false));
        NBTDataHelper.set(stack, INBTKeys.BLUDGEONING, Boolean.valueOf(!current));
    }

    @Unique
    private void handleRangeWeaponUse(class_1937 world, class_1657 user, class_1268 hand, class_1799 stack, CallbackInfoReturnable<class_1271<class_1799>> cir) {
        if (world.field_9236) {
            return;
        }
        if (SCRangeWeaponUtil.getAmmoRequirement(stack) != null) {
            this.handleAmmoBasedWeapon(world, user, hand, stack, cir);
        } else {
            this.handleProjectileWeapon(hand, user, stack, cir);
        }
    }

    @Unique
    private void handleAmmoBasedWeapon(class_1937 world, class_1657 user, class_1268 hand, class_1799 stack, CallbackInfoReturnable<class_1271<class_1799>> cir) {
        SCRangeWeaponUtil.WeaponState weaponState = SCRangeWeaponUtil.getWeaponState(stack);
        if (!weaponState.isCharged()) {
            cir.setReturnValue((Object)class_1271.method_22431((Object)stack));
            return;
        }
        class_1799 offHandStack = user.method_6079();
        boolean needsFAS = WeaponDefinitionsLoader.getData(stack).ranged().needsFlintAndSteel();
        if (needsFAS && offHandStack.method_7909() != class_1802.field_8884 && !user.method_7337()) {
            cir.setReturnValue((Object)class_1271.method_22431((Object)stack));
            return;
        }
        user.method_6019(hand);
        SCRangeWeaponUtil.handleShoot(world, user, stack);
        SCRangeWeaponUtil.setWeaponState(stack, new SCRangeWeaponUtil.WeaponState(weaponState.isReloading(), false, true));
        if (!user.method_31549().field_7477 && needsFAS && user instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)user;
            offHandStack.method_7956(1, (class_1309)serverPlayer, p -> p.method_20236(hand));
        }
        cir.setReturnValue((Object)class_1271.method_22428((Object)stack));
    }

    @Unique
    private void handleProjectileWeapon(class_1268 hand, class_1657 user, class_1799 stack, CallbackInfoReturnable<class_1271<class_1799>> cir) {
        boolean hasAmmo = SCRangeWeaponUtil.getArrowFromInventory(user).isPresent();
        if (!hasAmmo) {
            cir.setReturnValue((Object)class_1271.method_22431((Object)stack));
            return;
        }
        user.method_6019(hand);
        if (WeaponDefinitionsLoader.getData(stack).ranged().useAction() == class_1839.field_8947) {
            cir.setReturnValue(SCRangeWeaponUtil.handleCrossbowUse(user.method_37908(), user, hand, stack));
        } else {
            cir.setReturnValue((Object)class_1271.method_22428((Object)stack));
        }
    }

    @Inject(method={"onStoppedUsing"}, at={@At(value="HEAD")})
    public void stoneycore$onStoppedUsing(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks, CallbackInfo ci) {
        if (world.field_9236) {
            return;
        }
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        if (!WeaponDefinitionsLoader.isRanged(stack)) {
            return;
        }
        WeaponDefinitionsLoader.DefinitionData def = WeaponDefinitionsLoader.getData(stack);
        if (def == null || def.ranged() == null) {
            return;
        }
        String type = def.ranged().id();
        int useTime = WeaponDefinitionsLoader.getData(stack).ranged().maxUseTime() - remainingUseTicks;
        SCRangeWeaponUtil.getArrowFromInventory(player).ifPresent(arrowStack -> RangedWeaponHandlers.get(type).ifPresent(h -> h.handleRelease(stack, world, player, useTime, (class_1799)arrowStack)));
    }

    @Inject(method={"appendTooltip"}, at={@At(value="HEAD")})
    public void stoneycore$appendTooltip(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context, CallbackInfo ci) {
        if (world == null) {
            return;
        }
        class_1792 item = stack.method_7909();
        if (WeaponDefinitionsLoader.isMelee(stack)) {
            double slashing = SCWeaponUtil.getDamageValues(SCDamageCalculator.DamageType.SLASHING, item);
            double piercing = SCWeaponUtil.getDamageValues(SCDamageCalculator.DamageType.PIERCING, item);
            double bludgeoning = SCWeaponUtil.getDamageValues(SCDamageCalculator.DamageType.BLUDGEONING, item);
            if (slashing > 0.0 && bludgeoning > 0.0) {
                tooltip.add((class_2561)class_2561.method_43471((String)"text.tooltip.stoneycore.shift-right_click-bludgeoning"));
            }
            if (slashing == 0.0 && bludgeoning > 0.0 && piercing > 0.0) {
                tooltip.add((class_2561)class_2561.method_43471((String)"text.tooltip.stoneycore.shift-right_click-bludgeoning-piercing"));
            }
            if (stack.method_31573(SCTags.WEAPONS_HARVEST.getTag())) {
                tooltip.add((class_2561)class_2561.method_43471((String)"text.tooltip.stoneycore.right_click-replant"));
            }
            if (slashing != 0.0) {
                tooltip.add((class_2561)class_2561.method_43469((String)"text.tooltip.stoneycore.slashingDamage", (Object[])new Object[]{slashing}).method_27692(class_124.field_1060));
            }
            if (bludgeoning != 0.0) {
                tooltip.add((class_2561)class_2561.method_43469((String)"text.tooltip.stoneycore.bludgeoningDamage", (Object[])new Object[]{bludgeoning}).method_27692(class_124.field_1060));
            }
            if (piercing != 0.0) {
                tooltip.add((class_2561)class_2561.method_43469((String)"text.tooltip.stoneycore.piercingDamage", (Object[])new Object[]{piercing}).method_27692(class_124.field_1060));
            }
        }
        if (world.method_8608()) {
            TooltipClientSide.setTooltip(tooltip, stack);
        }
    }

    @Inject(method={"useOnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void stoneycore$useOnBlock(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
        class_1799 stack = context.method_8041();
        if (!WeaponDefinitionsLoader.isMelee(stack) || !stack.method_31573(SCTags.WEAPONS_HARVEST.getTag())) {
            return;
        }
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_2680 state = world.method_8320(pos);
        if (!world.field_9236 && player != null) {
            this.handleCropHarvest(world, pos, state, player, stack, context.method_20287(), cir);
        }
    }

    @Unique
    private void handleCropHarvest(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_1799 stack, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_2302 crop;
        class_2248 block = state.method_26204();
        if (block instanceof class_2302 && (crop = (class_2302)block).method_9825(state) && world.method_8651(pos, true, (class_1297)player)) {
            SCWeaponUtil.replantCrop(world, pos, crop, player, stack, hand);
            cir.setReturnValue((Object)class_1269.field_5812);
        }
    }

    @Inject(method={"onCraft"}, at={@At(value="TAIL")})
    public void onCraft(class_1799 stack, class_1937 world, class_1657 player, CallbackInfo ci) {
        if (!(stack.method_7909() instanceof SCAccessoryItem)) {
            return;
        }
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof class_1714) {
            class_1714 craftingInventory = (class_1714)class_17032;
            this.applyCraftingModifiers(stack, craftingInventory.method_7658(), arg_0 -> ((class_1714)craftingInventory).method_7611(arg_0));
        } else {
            class_17032 = player.field_7512;
            if (class_17032 instanceof class_1723) {
                class_1723 playerInventory = (class_1723)class_17032;
                this.applyCraftingModifiers(stack, 4, arg_0 -> ((class_1723)playerInventory).method_7611(arg_0));
            }
        }
    }

    @Unique
    private void applyCraftingModifiers(class_1799 resultStack, int slotCount, IntFunction<class_1735> slotSupplier) {
        class_1799 bannerStack = class_1799.field_8037;
        for (int i = 0; i < slotCount; ++i) {
            class_1799 ingredient = slotSupplier.apply(i).method_7677();
            if (!(ingredient.method_7909() instanceof class_1746)) continue;
            bannerStack = ingredient;
            break;
        }
        if (bannerStack.method_7960() || !(resultStack.method_7909() instanceof SCAccessoryItem) || !resultStack.method_31573(SCTags.BANNER_COMPATIBLE.getTag())) {
            return;
        }
        List<class_3545<class_2960, class_1767>> bannerPatterns = ItemMixin.getBannerPatterns(bannerStack, resultStack.method_7909());
        PatternHelper.setBannerPatterns(resultStack, bannerPatterns);
        PatternHelper.setBannerDyeColor(resultStack, ((class_1746)bannerStack.method_7909()).method_7706());
    }

    @Unique
    private static List<class_3545<class_2960, class_1767>> getBannerPatterns(class_1799 bannerStack, class_1792 armor) {
        ArrayList<class_3545<class_2960, class_1767>> patterns = new ArrayList<class_3545<class_2960, class_1767>>();
        if (bannerStack.method_7960() || !(bannerStack.method_7909() instanceof class_1746)) {
            return patterns;
        }
        class_2487 nbt = bannerStack.method_7969();
        if (nbt == null || !nbt.method_10545("BlockEntityTag")) {
            return patterns;
        }
        class_2487 blockEntityTag = nbt.method_10562("BlockEntityTag");
        if (!blockEntityTag.method_10545("Patterns")) {
            return patterns;
        }
        class_2499 patternList = blockEntityTag.method_10554("Patterns", 10);
        class_2960 itemId = class_7923.field_41178.method_10221((Object)armor);
        for (int i = 0; i < patternList.size(); ++i) {
            class_2487 patternTag = patternList.method_10602(i);
            String pattern = NBTDataHelper.get(patternTag, INBTKeys.PATTERN, "");
            int colorId = NBTDataHelper.get(patternTag, INBTKeys.COLOR, Integer.valueOf(0));
            class_1767 color = class_1767.method_7791((int)colorId);
            class_2960 patternId = new class_2960(itemId.method_12836(), "textures/banner_pattern/" + itemId.method_12832() + "/" + pattern + ".png");
            patterns.add((class_3545<class_2960, class_1767>)new class_3545((Object)patternId, (Object)color));
        }
        return patterns;
    }
}

