/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.mixin;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.mixin.LivingEntityAccessor;
import banduty.stoneycore.siege.SiegeManager;
import banduty.stoneycore.util.DeflectChanceHelper;
import banduty.stoneycore.util.EntityDamageUtil;
import banduty.stoneycore.util.SCDamageCalculator;
import banduty.stoneycore.util.WeightUtil;
import banduty.stoneycore.util.data.itemdata.SCTags;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.data.playerdata.IEntityDataSaver;
import banduty.stoneycore.util.data.playerdata.PDKeys;
import banduty.stoneycore.util.data.playerdata.SCAttributes;
import banduty.stoneycore.util.data.playerdata.StaminaData;
import banduty.stoneycore.util.definitionsloader.AccessoriesDefinitionsLoader;
import banduty.stoneycore.util.definitionsloader.ArmorDefinitionsLoader;
import banduty.stoneycore.util.definitionsloader.WeaponDefinitionsLoader;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.Optional;
import net.bettercombat.api.AttackHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.minecraft.class_1268;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements IEntityDataSaver {
    @Unique
    private class_2487 persistentData;
    @Unique
    private boolean blockShield = true;
    @Unique
    private class_1282 stoneycore$currentDamageSource;
    @Unique
    private static final int PARRY_WINDOW_TICKS = 10;
    @Unique
    private static final float PARRY_KNOCKBACK_STRENGTH = 0.5f;

    @Shadow
    protected abstract void method_5623(double var1, boolean var3, class_2680 var4, class_2338 var5);

    LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public class_2487 stoneycore$getPersistentData() {
        if (this.persistentData == null) {
            this.persistentData = new class_2487();
        }
        return this.persistentData;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="HEAD")})
    protected void stoneycore$injectWriteMethod(class_2487 nbt, CallbackInfo ci) {
        if (this.persistentData != null) {
            nbt.method_10566("stoneycore.data", (class_2520)this.persistentData);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    protected void stoneycore$injectReadMethod(class_2487 nbt, CallbackInfo info) {
        if (nbt.method_10573("stoneycore.data", 10)) {
            this.persistentData = nbt.method_10562("stoneycore.data");
        }
    }

    @Inject(method={"createLivingAttributes()Lnet/minecraft/entity/attribute/DefaultAttributeContainer$Builder;"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void addAttributes(CallbackInfoReturnable<class_5132.class_5133> info) {
        ((class_5132.class_5133)info.getReturnValue()).method_26867(SCAttributes.HUNGER_DRAIN_MULTIPLIER).method_26867(SCAttributes.STAMINA).method_26867(SCAttributes.MAX_STAMINA);
    }

    @Inject(method={"jump"}, at={@At(value="HEAD")}, cancellable=true)
    private void stoneycore$onJump(CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        if (this.isStaminaBlocked(livingEntity)) {
            ci.cancel();
        }
    }

    @Inject(method={"setSprinting"}, at={@At(value="HEAD")}, cancellable=true)
    private void stoneycore$onSprinting(CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        if (this.isStaminaBlocked(livingEntity)) {
            ci.cancel();
        }
    }

    @Inject(method={"setCurrentHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void stoneycore$onSetCurrentHand(class_1268 hand, CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        if (this.isStaminaBlocked(livingEntity)) {
            ci.cancel();
        }
    }

    @Inject(method={"disablesShield"}, at={@At(value="HEAD")}, cancellable=true)
    public void stoneycore$disablesShield(CallbackInfoReturnable<Boolean> cir) {
        class_1799 mainStack = ((class_1309)this).method_6047();
        boolean isWeaponOrInTag = mainStack.method_7909() instanceof class_1743 || mainStack.method_31573(SCTags.WEAPONS_DISABLE_SHIELD.getTag());
        cir.setReturnValue((Object)isWeaponOrInTag);
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void stoneycore$injectDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 livingEntity;
        class_1309 attacker;
        if (this.method_37908().method_8608()) {
            return;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309 && (attacker = (class_1309)class_12972).method_6047().method_31573(SCTags.WEAPONS_BYPASS_BLOCK.getTag())) {
            this.blockShield = false;
        }
        if ((livingEntity = (class_1309)this).method_6030().method_31573(SCTags.WEAPONS_SHIELD.getTag()) && source.method_5526() instanceof class_1665) {
            this.blockShield = false;
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void stoneycore$captureDamageSource(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1799 handStack;
        class_3222 playerEntity;
        class_1657 player;
        class_1297 class_12972;
        LandState stateManager;
        Optional<Land> maybeLand;
        class_1799 weaponStack;
        this.stoneycore$currentDamageSource = source;
        class_1309 livingEntity = (class_1309)this;
        class_1937 class_19372 = livingEntity.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (source.method_5529() == null) {
            return;
        }
        if (LivingEntityMixin.handleParry(livingEntity, source)) {
            cir.cancel();
        }
        if (DeflectChanceHelper.shouldDeflect(livingEntity, weaponStack = this.getWeaponStack(source.method_5529()))) {
            cir.cancel();
        }
        if ((maybeLand = (stateManager = LandState.get(serverWorld)).getLandAt(source.method_5529().method_24515())).isPresent() && (class_12972 = source.method_5529()) instanceof class_1657 && SiegeManager.isPlayerInLandUnderSiege(serverWorld, player = (class_1657)class_12972) && !SiegeManager.getPlayerSiege(serverWorld, source.method_5529().method_5667()).map(siege -> !siege.disabledPlayers.contains(source.method_5529().method_5667())).orElse(false).booleanValue()) {
            cir.cancel();
        }
        if (livingEntity instanceof class_3222 && StaminaData.isStaminaBlocked((IEntityDataSaver)(playerEntity = (class_3222)livingEntity)) && StoneyCore.getConfig().combatOptions.getRealisticCombat() && !(handStack = playerEntity.method_6047()).method_7960()) {
            playerEntity.method_7329(handStack, false, true);
            playerEntity.method_6122(playerEntity.method_6058(), class_1799.field_8037);
        }
    }

    @Unique
    private static boolean handleParry(class_1309 target, class_1282 source) {
        if (!StoneyCore.getConfig().combatOptions.getParry() || !(target instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)target;
        if (!player.method_6039()) {
            return false;
        }
        if (source.method_5526() instanceof class_1665) {
            return false;
        }
        long blockStartTick = NBTDataHelper.get((IEntityDataSaver)player, PDKeys.BLOCK_START_TICK, Long.valueOf(0L));
        long currentTick = player.method_37908().method_8510();
        if (currentTick - blockStartTick > 10L) {
            return false;
        }
        if (source.method_5526() == null) {
            return false;
        }
        LivingEntityMixin.performParryEffects(player, source.method_5526());
        StaminaData.removeStamina((class_1309)player, StoneyCore.getConfig().combatOptions.onParryStaminaConstant() * WeightUtil.getCachedWeight((class_1309)player));
        return true;
    }

    @Unique
    private static void performParryEffects(class_1657 player, class_1297 source) {
        if (source instanceof class_1309) {
            class_1309 livingEntity = (class_1309)source;
            class_243 playerPos = player.method_19538();
            class_243 attackerPos = source.method_19538();
            class_243 knockbackDirection = playerPos.method_1020(attackerPos).method_1029();
            livingEntity.method_6005(0.5, knockbackDirection.field_1352, knockbackDirection.field_1350);
        }
        player.method_37908().method_43128(null, source.method_23317(), source.method_23318(), source.method_23321(), class_3417.field_14670, class_3419.field_15248, 1.0f, 1.5f);
    }

    @Inject(method={"takeKnockback"}, at={@At(value="HEAD")}, cancellable=true)
    private void stoneycore$takeKnockback(double strength, double x, double z, CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        LivingEntityAccessor accessor = (LivingEntityAccessor)livingEntity;
        if (this.stoneycore$currentDamageSource == null) {
            return;
        }
        class_1297 attacker = this.stoneycore$currentDamageSource.method_5529();
        class_1799 weaponStack = this.getWeaponStack(attacker);
        if (!(attacker instanceof class_1309) || weaponStack.method_7960() || !WeaponDefinitionsLoader.isMelee(weaponStack)) {
            return;
        }
        float damageAmount = accessor.getLastDamageTaken();
        strength *= (double)damageAmount / 15.0;
        strength = Math.max(strength, 0.1);
        if (EntityDamageUtil.damageType == SCDamageCalculator.DamageType.BLUDGEONING) {
            strength += (double)0.3f;
        }
        strength += WeaponDefinitionsLoader.getData(weaponStack).melee().bonusKnockback();
        if (!((strength *= 1.0 - livingEntity.method_26825(class_5134.field_23718)) <= 0.0)) {
            livingEntity.field_6007 = true;
            class_243 vec3d = livingEntity.method_18798();
            class_243 vec3d2 = new class_243(x, 0.0, z).method_1029().method_1021(strength);
            livingEntity.method_18800(vec3d.field_1352 / 2.0 - vec3d2.field_1352, livingEntity.method_24828() ? vec3d.field_1351 / 2.0 + strength : vec3d.field_1351, vec3d.field_1350 / 2.0 - vec3d2.field_1350);
        }
        ci.cancel();
    }

    @Unique
    private class_1799 getWeaponStack(class_1297 attacker) {
        class_1657 player;
        AttackHand hand = null;
        if (attacker instanceof class_1657 && (player = (class_1657)attacker) instanceof PlayerAttackProperties) {
            PlayerAttackProperties props = (PlayerAttackProperties)player;
            hand = PlayerAttackHelper.getCurrentAttack((class_1657)player, (int)props.getComboCount());
        }
        class_1799 itemStack = class_1799.field_8037;
        if (hand != null) {
            itemStack = hand.itemStack();
        }
        return itemStack;
    }

    @Inject(method={"applyArmorToDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void stoneycore$applyArmorToDamage(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        class_1309 livingEntity = (class_1309)this;
        amount = class_1280.method_5496((float)amount, (float)livingEntity.method_6096(), (float)((float)livingEntity.method_26825(class_5134.field_23725)));
        for (class_1799 armorStack : livingEntity.method_5661()) {
            if (armorStack.method_7960()) continue;
            class_1304 slot = class_1309.method_32326((class_1799)armorStack);
            boolean slotProtected = false;
            if (AccessoriesCapability.getOptionally((class_1309)livingEntity).isPresent()) {
                for (SlotEntryReference equipped : AccessoriesCapability.get((class_1309)livingEntity).getAllEquipped()) {
                    String slotFromJson;
                    if (equipped.stack().method_7960() || !AccessoriesDefinitionsLoader.containsItem(equipped.stack()) || (slotFromJson = AccessoriesDefinitionsLoader.getData(equipped.stack().method_7909()).armorSlot()).isBlank() || !slotFromJson.equalsIgnoreCase(slot.method_5923())) continue;
                    slotProtected = true;
                    equipped.stack().method_7956((int)amount, livingEntity, entity -> entity.method_20235(class_1304.field_6173));
                }
            }
            if (slotProtected) continue;
            armorStack.method_7956((int)amount, livingEntity, entity -> entity.method_20235(slot));
        }
        cir.setReturnValue((Object)Float.valueOf(amount));
        cir.cancel();
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void stoneycore$cancelZeroDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (amount <= 0.0f) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="TAIL")})
    private void stoneycore$sendDamage(class_1282 source, float amount, CallbackInfo ci) {
        class_1657 player;
        class_1799 mainHandStack;
        class_1297 class_12972;
        if (StoneyCore.getConfig().visualOptions.getDamageIndicator() && (class_12972 = source.method_5529()) instanceof class_1657 && WeaponDefinitionsLoader.isMelee((mainHandStack = (player = (class_1657)class_12972).method_6047()).method_7909()) && !player.method_6059(class_1294.field_5911)) {
            if (amount <= 0.0f) {
                amount = 0.0f;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)("Damage: " + (int)amount)), true);
        }
    }

    @Inject(method={"jump"}, at={@At(value="HEAD")})
    private void stoneycore$jump(CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1309) {
            class_1309 livingEntity = (class_1309)livingEntityMixin;
            IEntityDataSaver dataSaver = (IEntityDataSaver)livingEntity;
            boolean staminaBlocked = StaminaData.isStaminaBlocked(dataSaver);
            boolean wearingSCArmor = this.isWearingSCArmor(livingEntity);
            if (!staminaBlocked && wearingSCArmor) {
                StaminaData.removeStamina(livingEntity, StoneyCore.getConfig().combatOptions.jumpingStaminaConstant() * WeightUtil.getCachedWeight(livingEntity));
            }
        }
    }

    @Inject(method={"blockedByShield"}, at={@At(value="HEAD")}, cancellable=true)
    private void stoneycore$blockedByShield(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_37908().method_8608()) {
            return;
        }
        if (!this.blockShield) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Unique
    private boolean isStaminaBlocked(class_1309 livingEntity) {
        return StaminaData.isStaminaBlocked((IEntityDataSaver)livingEntity);
    }

    @Unique
    private boolean isWearingSCArmor(class_1309 livingEntity) {
        for (class_1799 armorStack : livingEntity.method_5661()) {
            if (!ArmorDefinitionsLoader.containsItem(armorStack.method_7909())) continue;
            return true;
        }
        return false;
    }
}

