/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util;

import banduty.stoneycore.StoneyCore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class BlockDamageTracker {
    private static final Map<class_2338, Float> blockDamageMap = new HashMap<class_2338, Float>();

    private BlockDamageTracker() {
    }

    public static void damageBlock(class_3218 world, class_2338 pos, float damageFactor, float hardness) {
        if (hardness < 0.0f || world.method_8320(pos).method_26215()) {
            return;
        }
        float prev = blockDamageMap.getOrDefault(pos, Float.valueOf(0.0f)).floatValue();
        float next = prev + damageFactor / hardness;
        if (next >= 1.0f) {
            world.method_22352(pos, !StoneyCore.getConfig().technicalOptions.breakOrRemoveSiegeDestroy());
            blockDamageMap.remove(pos);
            BlockDamageTracker.clearProgress(world, pos);
        } else {
            blockDamageMap.put(pos, Float.valueOf(next));
            BlockDamageTracker.sendProgress(world, pos, next);
        }
    }

    public static void clean(class_3218 world) {
        Iterator<Map.Entry<class_2338, Float>> it = blockDamageMap.entrySet().iterator();
        while (it.hasNext()) {
            class_2338 pos = it.next().getKey();
            if (!world.method_8320(pos).method_26215()) continue;
            BlockDamageTracker.clearProgress(world, pos);
            it.remove();
        }
    }

    private static void sendProgress(class_3218 world, class_2338 pos, float progress) {
        int stage = Math.min(9, (int)(progress * 10.0f));
        int visualId = BlockDamageTracker.getVisualId(pos);
        for (class_3222 player : world.method_18456()) {
            player.field_13987.method_14364((class_2596)new class_2620(visualId, pos, stage));
        }
    }

    private static void clearProgress(class_3218 world, class_2338 pos) {
        int visualId = BlockDamageTracker.getVisualId(pos);
        for (class_3222 player : world.method_18456()) {
            player.field_13987.method_14364((class_2596)new class_2620(visualId, pos, -1));
        }
    }

    private static int getVisualId(class_2338 pos) {
        return Long.hashCode(pos.method_10063());
    }
}

