/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util;

import banduty.stoneycore.util.data.itemdata.SCTags;
import banduty.stoneycore.util.definitionsloader.ArmorDefinitionsLoader;
import banduty.stoneycore.util.weaponutil.SCArmorUtil;
import com.mojang.serialization.Codec;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;

public class SCDamageCalculator {
    public static double getSCDamage(class_1309 livingEntity, double initialDamage, DamageType damageType) {
        for (class_1799 armorStack : livingEntity.method_5661()) {
            if (!ArmorDefinitionsLoader.containsItem(armorStack.method_7909())) continue;
            double resistance = SCDamageCalculator.getResistance(armorStack.method_7909(), damageType);
            initialDamage *= Math.max(1.0 - resistance, 0.0);
        }
        return initialDamage;
    }

    protected static double getResistance(class_1792 item, DamageType damageType) {
        if (damageType == null) {
            System.err.println("[SCDamageCalculator] Error: DamageType is null for item " + item.method_7848().getString() + ", changing to default Bludgeoning");
            return SCArmorUtil.getResistance(DamageType.BLUDGEONING, item);
        }
        return switch (damageType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> SCArmorUtil.getResistance(DamageType.SLASHING, item);
            case 1 -> SCArmorUtil.getResistance(DamageType.PIERCING, item);
            case 2 -> SCArmorUtil.getResistance(DamageType.BLUDGEONING, item);
        };
    }

    public static void applyDamage(class_1309 target, class_1297 attacker, class_1799 stack, double damage) {
        if (attacker == null) {
            return;
        }
        float enchantmentBonusDamage = class_1890.method_8218((class_1799)stack, (class_1310)target.method_6046());
        damage += (double)enchantmentBonusDamage;
        if (stack.method_31573(SCTags.WEAPONS_IGNORES_ARMOR.getTag()) && (double)target.method_6032() - damage > 0.0) {
            target.method_6033((float)((double)target.method_6032() - damage));
        } else if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            target.method_5643(attacker.method_37908().method_48963().method_48802(player), (float)damage);
        } else if (attacker instanceof class_1309) {
            class_1309 livingEntity = (class_1309)attacker;
            target.method_5643(attacker.method_37908().method_48963().method_48812(livingEntity), (float)damage);
        } else if (attacker instanceof class_1665) {
            class_1665 persistentProjectileEntity = (class_1665)attacker;
            target.method_5643(attacker.method_37908().method_48963().method_48803(persistentProjectileEntity, persistentProjectileEntity.method_24921()), (float)damage);
        }
    }

    public static enum DamageType {
        SLASHING,
        PIERCING,
        BLUDGEONING;

        public static final Codec<DamageType> CODEC;

        static {
            CODEC = Codec.STRING.xmap(str -> DamageType.valueOf(str.toUpperCase()), Enum::name);
        }
    }
}

