/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.data.playerdata;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.networking.ModMessages;
import banduty.stoneycore.util.ModifiersHelper;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.data.playerdata.IEntityDataSaver;
import banduty.stoneycore.util.data.playerdata.PDKeys;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class StaminaData {
    private static final UUID GENERIC_STAMINA_MODIFIER_ID = UUID.randomUUID();

    public static void setStamina(class_1309 livingEntity, double stamina) {
        ModifiersHelper.updateModifier(livingEntity.method_5996((class_1320)StoneyCore.STAMINA.get()), new class_1322(GENERIC_STAMINA_MODIFIER_ID, "stoneycore:stamina", StaminaData.clampStamina(livingEntity, stamina), class_1322.class_1323.field_6328));
    }

    public static void addStamina(class_1309 livingEntity, double amount) {
        StaminaData.setStamina(livingEntity, StaminaData.clampStamina(livingEntity, livingEntity.method_26825((class_1320)StoneyCore.STAMINA.get()) + amount));
    }

    public static void removeStamina(class_1309 livingEntity, double amount) {
        StaminaData.setStamina(livingEntity, StaminaData.clampStamina(livingEntity, livingEntity.method_26825((class_1320)StoneyCore.STAMINA.get()) - amount));
    }

    public static double getStamina(class_1309 livingEntity) {
        return livingEntity.method_26825((class_1320)StoneyCore.STAMINA.get());
    }

    private static double clampStamina(class_1309 livingEntity, double value) {
        return Math.max(0.0, Math.min(value, livingEntity.method_26825((class_1320)StoneyCore.MAX_STAMINA.get())));
    }

    public static void setStaminaBlocked(IEntityDataSaver livingEntity, boolean blocked) {
        NBTDataHelper.set(livingEntity, PDKeys.STAMINA_BLOCKED, Boolean.valueOf(blocked));
        StaminaData.syncStaminaBlocked(blocked, (class_3222)livingEntity);
    }

    public static boolean isStaminaBlocked(IEntityDataSaver livingEntity) {
        return NBTDataHelper.get(livingEntity, PDKeys.STAMINA_BLOCKED, Boolean.valueOf(false));
    }

    public static void setStaminaUseTime(IEntityDataSaver livingEntity, int time) {
        NBTDataHelper.set(livingEntity, PDKeys.STAMINA_USE_TIME, Integer.valueOf(time));
    }

    public static int getStaminaUseTime(IEntityDataSaver player) {
        return NBTDataHelper.get(player, PDKeys.STAMINA_USE_TIME, Integer.valueOf(0));
    }

    public static void syncStaminaBlocked(boolean blocked, class_3222 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.writeBoolean(blocked);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.STAMINA_BLOCKED_ID, (class_2540)buffer);
    }

    public static void saveStamina(IEntityDataSaver livingEntity, double stamina) {
        NBTDataHelper.set(livingEntity, PDKeys.STAMINA_VALUE_SAVED, Double.valueOf(stamina));
    }

    public static void loadStamina(class_1309 livingEntity) {
        if (!(livingEntity instanceof IEntityDataSaver)) {
            return;
        }
        IEntityDataSaver iEntityDataSaver = (IEntityDataSaver)livingEntity;
        NBTDataHelper.set(iEntityDataSaver, PDKeys.STAMINA_VALUE_SAVED, NBTDataHelper.get(iEntityDataSaver, PDKeys.STAMINA_VALUE_SAVED, Double.valueOf(livingEntity.method_26825((class_1320)StoneyCore.MAX_STAMINA.get()))));
    }
}

