/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.definitionsloader;

import banduty.stoneycore.StoneyCore;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class ArmorDefinitionsLoader
implements IdentifiableResourceReloadListener {
    private static final Map<class_2960, DefinitionData> DEFINITIONS = new ConcurrentHashMap<class_2960, DefinitionData>();
    private static final class_2960 RELOAD_LISTENER_ID = new class_2960("stoneycore", "armor_definitions_loader");

    public class_2960 getFabricId() {
        return RELOAD_LISTENER_ID;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 resourceManager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {
            DEFINITIONS.clear();
            Map resources = resourceManager.method_14488("definitions/armor", id -> id.method_12832().endsWith(".json"));
            resources.forEach((id, resource) -> {
                try (InputStream stream = resource.method_14482();){
                    JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(stream));
                    DataResult result = DefinitionData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                    result.resultOrPartial(arg_0 -> ((Logger)StoneyCore.LOGGER).error(arg_0)).ifPresent(def -> {
                        class_2960 attributeId = class_2960.method_43902((String)id.method_12836(), (String)id.method_12832().substring("definitions/armor/".length(), id.method_12832().length() - 5));
                        DEFINITIONS.put(attributeId, (DefinitionData)def);
                    });
                }
                catch (Exception e) {
                    StoneyCore.LOGGER.error("Failed to load armor definition from {}: {}", new Object[]{id, e.getMessage(), e});
                }
            });
        }, prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenRunAsync(() -> {}, applyExecutor);
    }

    public static DefinitionData getData(class_1799 itemStack) {
        if (itemStack == null) {
            itemStack = class_1799.field_8037;
        }
        return ArmorDefinitionsLoader.getData(itemStack.method_7909());
    }

    public static DefinitionData getData(class_1792 item) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        class_2960 definitionId = class_2960.method_43902((String)itemId.method_12836(), (String)itemId.method_12832());
        return DEFINITIONS.getOrDefault(definitionId, new DefinitionData(Map.of(), Map.of(), 0.0));
    }

    public static boolean containsItem(class_1799 itemStack) {
        if (itemStack == null) {
            itemStack = class_1799.field_8037;
        }
        return ArmorDefinitionsLoader.containsItem(itemStack.method_7909());
    }

    public static boolean containsItem(class_1792 item) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        class_2960 definitionId = class_2960.method_43902((String)itemId.method_12836(), (String)itemId.method_12832());
        return DEFINITIONS.containsKey(definitionId);
    }

    public record DefinitionData(Map<String, Double> damageResistance, Map<String, Double> deflectChance, double weight) {
        public static final Codec<DefinitionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING.xmap(String::toUpperCase, s -> s), (Codec)Codec.DOUBLE).optionalFieldOf("damageResistance", Map.of()).forGetter(DefinitionData::damageResistance), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE).optionalFieldOf("deflectChance", Map.of()).forGetter(DefinitionData::deflectChance), (App)Codec.DOUBLE.optionalFieldOf("weight", (Object)0.0).forGetter(DefinitionData::weight)).apply((Applicative)instance, DefinitionData::new));
    }
}

