/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.definitionsloader;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.lands.LandTypeRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class LandDefinitionsLoader
implements IdentifiableResourceReloadListener {
    private static final class_2960 RELOAD_LISTENER_ID = new class_2960("stoneycore", "land_definitions_loader");

    public class_2960 getFabricId() {
        return RELOAD_LISTENER_ID;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 resourceManager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {
            LandTypeRegistry.clearOverrides();
            Map resources = resourceManager.method_14488("definitions/lands", id -> id.method_12832().endsWith(".json"));
            resources.forEach((id, resource) -> {
                try (InputStream stream = resource.method_14482();){
                    JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(stream));
                    DataResult result = LandValues.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                    result.resultOrPartial(arg_0 -> ((Logger)StoneyCore.LOGGER).error(arg_0)).ifPresent(def -> {
                        class_2960 landId = new class_2960(id.method_12836(), id.method_12832().substring("definitions/lands/".length(), id.method_12832().length() - 5));
                        LandTypeRegistry.applyOverride(landId, def);
                    });
                }
                catch (Exception e) {
                    StoneyCore.LOGGER.error("Failed to load land definition from {}: {}", new Object[]{id, e.getMessage(), e});
                }
            });
        }, prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenRunAsync(() -> {}, applyExecutor);
    }

    public record LandValues(int baseRadius, Map<class_1792, Integer> itemsToExpand, String expandFormula, int maxAllies) {
        public static final Codec<LandValues> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("base_radius", (Object)0).forGetter(LandValues::baseRadius), (App)Codec.unboundedMap((Codec)class_2960.field_25139.xmap(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0), arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)), (Codec)Codec.INT).optionalFieldOf("items_to_expand", Map.of()).forGetter(LandValues::itemsToExpand), (App)Codec.STRING.optionalFieldOf("expand_formula", (Object)"").forGetter(LandValues::expandFormula), (App)Codec.INT.optionalFieldOf("maxAllies", (Object)-1).forGetter(LandValues::maxAllies)).apply((Applicative)instance, LandValues::new));
    }
}

