/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.definitionsloader;

import banduty.stoneycore.StoneyCore;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class SiegeEngineDefinitionsLoader
implements IdentifiableResourceReloadListener {
    private static final Map<class_2960, SiegeEngineDefinitionData> DEFINITIONS = new ConcurrentHashMap<class_2960, SiegeEngineDefinitionData>();
    private static final class_2960 RELOAD_LISTENER_ID = new class_2960("stoneycore", "siege_engine_definitions_loader");

    public class_2960 getFabricId() {
        return RELOAD_LISTENER_ID;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 resourceManager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {
            DEFINITIONS.clear();
            Map resources = resourceManager.method_14488("definitions/siege_engines", id -> id.method_12832().endsWith(".json"));
            resources.forEach((id, resource) -> {
                try (InputStream stream = resource.method_14482();){
                    JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(stream));
                    DataResult result = SiegeEngineDefinitionData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                    result.resultOrPartial(arg_0 -> ((Logger)StoneyCore.LOGGER).error(arg_0)).ifPresent(def -> {
                        class_2960 siegeEngineId = class_2960.method_43902((String)id.method_12836(), (String)id.method_12832().substring("definitions/siege_engines/".length(), id.method_12832().length() - 5));
                        DEFINITIONS.put(siegeEngineId, (SiegeEngineDefinitionData)def);
                    });
                }
                catch (Exception e) {
                    StoneyCore.LOGGER.error("Failed to load siege engine definition from {}: {}", new Object[]{id, e.getMessage(), e});
                }
            });
        }, prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenRunAsync(() -> StoneyCore.LOGGER.info("Loaded {} siege engine definitions", (Object)DEFINITIONS.size()), applyExecutor);
    }

    public static SiegeEngineDefinitionData getData(class_1299<?> entityType) {
        class_2960 entityId = class_7923.field_41177.method_10221(entityType);
        class_2960 definitionId = class_2960.method_43902((String)entityId.method_12836(), (String)entityId.method_12832());
        return DEFINITIONS.getOrDefault(definitionId, SiegeEngineDefinitionData.DEFAULT);
    }

    public static boolean containsEntity(class_1299<?> entityType) {
        class_2960 entityId = class_7923.field_41177.method_10221(entityType);
        class_2960 definitionId = class_2960.method_43902((String)entityId.method_12836(), (String)entityId.method_12832());
        return DEFINITIONS.containsKey(definitionId);
    }

    public record SiegeEngineDefinitionData(double playerSpeed, double horseSpeed, double knockback, double baseDamage, int baseReload, float projectileSpeed, float accuracyMultiplier) {
        public static final SiegeEngineDefinitionData DEFAULT = new SiegeEngineDefinitionData(0.05, 0.1, 265.0, 25.0, 90, 140.0f, 1.0f);
        public static final Codec<SiegeEngineDefinitionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("playerSpeed", (Object)0.05).forGetter(SiegeEngineDefinitionData::playerSpeed), (App)Codec.DOUBLE.optionalFieldOf("horseSpeed", (Object)0.1).forGetter(SiegeEngineDefinitionData::horseSpeed), (App)Codec.DOUBLE.optionalFieldOf("knockback", (Object)0.0).forGetter(SiegeEngineDefinitionData::knockback), (App)Codec.DOUBLE.optionalFieldOf("baseDamage", (Object)25.0).forGetter(SiegeEngineDefinitionData::baseDamage), (App)Codec.INT.optionalFieldOf("baseReload", (Object)90).forGetter(SiegeEngineDefinitionData::baseReload), (App)Codec.FLOAT.optionalFieldOf("projectileSpeed", (Object)Float.valueOf(140.0f)).forGetter(SiegeEngineDefinitionData::projectileSpeed), (App)Codec.FLOAT.optionalFieldOf("accuracyMultiplier", (Object)Float.valueOf(1.2f)).forGetter(SiegeEngineDefinitionData::accuracyMultiplier)).apply((Applicative)instance, SiegeEngineDefinitionData::new));
    }
}

