/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.servertick;

import banduty.stoneycore.util.SCInventoryItemFinder;
import banduty.stoneycore.util.data.itemdata.SCTags;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.data.playerdata.IEntityDataSaver;
import banduty.stoneycore.util.data.playerdata.PDKeys;
import banduty.stoneycore.util.definitionsloader.WeaponDefinitionsLoader;
import banduty.stoneycore.util.weaponutil.SCRangeWeaponUtil;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class MechanicsUtil {
    private static final Map<class_1309, class_1799> LAST_ITEMSTACK_MAP = Collections.synchronizedMap(new WeakHashMap());

    public static void handleParry(class_3222 player) {
        if (NBTDataHelper.get((IEntityDataSaver)player, PDKeys.BLOCK_START_TICK, Long.valueOf(0L)) > 0L) {
            return;
        }
        class_1799 activeItem = player.method_6030();
        boolean isBlocking = player.method_6039();
        boolean usingCustomShield = activeItem.method_31573(SCTags.WEAPONS_SHIELD.getTag());
        if (isBlocking && usingCustomShield) {
            NBTDataHelper.set((IEntityDataSaver)player, PDKeys.BLOCK_START_TICK, Long.valueOf(player.method_37908().method_8510()));
        } else {
            NBTDataHelper.set((IEntityDataSaver)player, PDKeys.BLOCK_START_TICK, Long.valueOf(0L));
        }
    }

    public static void handlePlayerReload(class_3222 player) {
        class_1799 lastItem;
        class_1799 currentItem = player.method_6047();
        class_2487 nbt = currentItem.method_7969();
        if (SCRangeWeaponUtil.getAmmoRequirement(currentItem) == null) {
            return;
        }
        SCRangeWeaponUtil.WeaponState weaponState = SCRangeWeaponUtil.getWeaponState(currentItem);
        if (weaponState.isReloading()) {
            player.method_18800(0.0, player.method_18798().field_1351, 0.0);
            player.field_6007 = true;
        }
        if (currentItem != (lastItem = LAST_ITEMSTACK_MAP.get(player))) {
            if (lastItem != null && lastItem.method_7969() != null && WeaponDefinitionsLoader.isRanged(lastItem)) {
                SCRangeWeaponUtil.setWeaponState(currentItem, new SCRangeWeaponUtil.WeaponState(false, weaponState.isCharged(), false));
                MechanicsUtil.resetWeaponState(player, lastItem);
            }
            LAST_ITEMSTACK_MAP.put((class_1309)player, currentItem);
            return;
        }
        if (nbt == null || !SCRangeWeaponUtil.getWeaponState(currentItem).isReloading() || !WeaponDefinitionsLoader.isRanged(currentItem)) {
            MechanicsUtil.resetRechargeTime((class_1657)player);
            return;
        }
        if (player.method_7337()) {
            MechanicsUtil.completeReload(player, currentItem);
            return;
        }
        if (player.method_7357().method_7904(currentItem.method_7909()) || weaponState.isCharged()) {
            return;
        }
        if (weaponState.isReloading()) {
            MechanicsUtil.incrementRechargeTime((class_1657)player);
        } else if (MechanicsUtil.hasRequiredAmmo(player, currentItem)) {
            MechanicsUtil.startReload(player, currentItem);
        } else {
            SCRangeWeaponUtil.setWeaponState(currentItem, new SCRangeWeaponUtil.WeaponState(false, false, false));
        }
        int requiredTicks = WeaponDefinitionsLoader.getData(currentItem).ranged().rechargeTime() * 20;
        if (MechanicsUtil.getRechargeTime((class_1657)player) >= requiredTicks) {
            MechanicsUtil.completeReload(player, currentItem);
        }
    }

    private static boolean hasRequiredAmmo(class_3222 player, class_1799 itemStack) {
        SCRangeWeaponUtil.AmmoRequirement ammoReq = SCRangeWeaponUtil.getAmmoRequirement(itemStack);
        class_1799[] foundItems = new class_1799[]{SCInventoryItemFinder.getItemFromInventory(player, ammoReq.firstItem(), ammoReq.firstItem2nOption()), SCInventoryItemFinder.getItemFromInventory(player, ammoReq.secondItem(), ammoReq.secondItem2nOption()), SCInventoryItemFinder.getItemFromInventory(player, ammoReq.thirdItem(), ammoReq.thirdItem2nOption())};
        int[] requiredAmounts = new int[]{ammoReq.amountFirstItem(), ammoReq.amountSecondItem(), ammoReq.amountThirdItem()};
        return SCInventoryItemFinder.areItemsInInventory(foundItems, requiredAmounts);
    }

    private static void startReload(class_3222 player, class_1799 itemStack) {
        SCRangeWeaponUtil.WeaponState state = SCRangeWeaponUtil.getWeaponState(itemStack);
        SCRangeWeaponUtil.setWeaponState(itemStack, new SCRangeWeaponUtil.WeaponState(true, state.isCharged(), false));
        MechanicsUtil.incrementRechargeTime((class_1657)player);
    }

    private static void completeReload(class_3222 player, class_1799 itemStack) {
        if (!player.method_7337()) {
            class_1799[] ammoItems;
            SCRangeWeaponUtil.AmmoRequirement ammoReq = SCRangeWeaponUtil.getAmmoRequirement(itemStack);
            for (class_1799 ammoItem : ammoItems = new class_1799[]{SCInventoryItemFinder.getItemFromInventory(player, ammoReq.firstItem(), ammoReq.firstItem2nOption()), SCInventoryItemFinder.getItemFromInventory(player, ammoReq.secondItem(), ammoReq.secondItem2nOption()), SCInventoryItemFinder.getItemFromInventory(player, ammoReq.thirdItem(), ammoReq.thirdItem2nOption())}) {
                player.method_31548().method_5434(SCInventoryItemFinder.getItemSlot(player, ammoItem), 1);
            }
        }
        SCRangeWeaponUtil.setWeaponState(itemStack, new SCRangeWeaponUtil.WeaponState(false, true, false));
        MechanicsUtil.setRechargeTime((class_1657)player, 0);
    }

    private static void resetWeaponState(class_3222 player, class_1799 itemStack) {
        SCRangeWeaponUtil.WeaponState state = SCRangeWeaponUtil.getWeaponState(itemStack);
        SCRangeWeaponUtil.setWeaponState(itemStack, new SCRangeWeaponUtil.WeaponState(false, state.isCharged(), false));
        MechanicsUtil.setRechargeTime((class_1657)player, 0);
    }

    private static void resetRechargeTime(class_1657 player) {
        MechanicsUtil.setRechargeTime(player, 0);
    }

    private static void incrementRechargeTime(class_1657 player) {
        MechanicsUtil.setRechargeTime(player, MechanicsUtil.getRechargeTime(player) + 1);
    }

    private static int getRechargeTime(class_1657 player) {
        return NBTDataHelper.get((IEntityDataSaver)player, PDKeys.RECHARGE_TIME, Integer.valueOf(0));
    }

    private static void setRechargeTime(class_1657 player, int time) {
        NBTDataHelper.set((IEntityDataSaver)player, PDKeys.RECHARGE_TIME, Integer.valueOf(time));
    }
}

