/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.weaponutil;

import banduty.stoneycore.combat.range.RangedWeaponHandlers;
import banduty.stoneycore.entity.custom.SCArrowEntity;
import banduty.stoneycore.entity.custom.SCBulletEntity;
import banduty.stoneycore.particle.ModParticles;
import banduty.stoneycore.util.data.itemdata.INBTKeys;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.definitionsloader.WeaponDefinitionsLoader;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1744;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public final class SCRangeWeaponUtil {
    private static final String KEY_RELOAD = "reload";
    private static final String KEY_CHARGED = "charged";
    private static final String KEY_SHOOT = "shoot";

    private SCRangeWeaponUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static WeaponState getWeaponState(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null ? WeaponState.fromNbt(nbt) : new WeaponState(false, false, false);
    }

    public static void setWeaponState(class_1799 stack, WeaponState state) {
        class_2487 nbt = stack.method_7948();
        state.applyToNbt(nbt);
    }

    public static void handleShoot(class_1937 world, class_1657 player, class_1799 weapon) {
        WeaponDefinitionsLoader.DefinitionData def = WeaponDefinitionsLoader.getData(weapon);
        if (def == null || def.ranged() == null) {
            return;
        }
        String type = def.ranged().id();
        RangedWeaponHandlers.get(type).ifPresentOrElse(handler -> {
            if (handler.canShoot(weapon)) {
                handler.shoot(world, player, weapon);
            }
        }, () -> SCRangeWeaponUtil.shootBullet(world, weapon, player));
    }

    public static void handleReload(class_1937 world, class_1657 player, class_1799 weapon) {
        WeaponDefinitionsLoader.DefinitionData def = WeaponDefinitionsLoader.getData(weapon);
        if (def == null || def.ranged() == null) {
            return;
        }
        String type = def.ranged().id();
        RangedWeaponHandlers.get(type).ifPresent(h -> h.reload(world, player, weapon));
    }

    public static void shootArrow(class_1937 world, class_1799 stack, class_1657 player, class_1799 arrowStack, float pullProgress) {
        if (world == null || player == null || arrowStack == null || arrowStack.method_7960()) {
            return;
        }
        class_1792 class_17922 = arrowStack.method_7909();
        if (!(class_17922 instanceof class_1744)) {
            return;
        }
        class_1744 arrowItem = (class_1744)class_17922;
        NBTDataHelper.set(arrowStack, INBTKeys.FROM_RANGED_WEAPON, Boolean.valueOf(true));
        class_1665 arrowEntity = arrowItem.method_7702(world, arrowStack, (class_1309)player);
        arrowEntity.method_7438((double)(WeaponDefinitionsLoader.getData(stack).ranged().baseDamage() / WeaponDefinitionsLoader.getData(stack).ranged().speed()));
        if (arrowEntity instanceof SCArrowEntity) {
            SCArrowEntity scArrowEntity = (SCArrowEntity)arrowEntity;
            scArrowEntity.setDamageType(WeaponDefinitionsLoader.getData(stack).ranged().damageType());
        }
        arrowEntity.method_7432((class_1297)player);
        if (NBTDataHelper.get(arrowStack, INBTKeys.IGNITED, Boolean.valueOf(false)).booleanValue()) {
            arrowEntity.method_33572(true);
            arrowEntity.method_20803(1000);
        }
        arrowEntity.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, pullProgress * WeaponDefinitionsLoader.getData(stack).ranged().speed(), WeaponDefinitionsLoader.getData(stack).ranged().divergence());
        if (player.method_7337()) {
            arrowEntity.field_7572 = class_1665.class_1666.field_7594;
        } else {
            stack.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
        }
        world.method_8649((class_1297)arrowEntity);
        SCRangeWeaponUtil.playSoundForPlayers(world, stack, player);
    }

    public static void shootBullet(class_1937 world, class_1799 stack, class_1657 player) {
        SCBulletEntity bulletEntity = new SCBulletEntity((class_1309)player, world);
        bulletEntity.setDamageAmount(WeaponDefinitionsLoader.getData(stack).ranged().baseDamage());
        bulletEntity.setDamageType(WeaponDefinitionsLoader.getData(stack).ranged().damageType());
        bulletEntity.method_7432((class_1297)player);
        bulletEntity.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, WeaponDefinitionsLoader.getData(stack).ranged().speed(), WeaponDefinitionsLoader.getData(stack).ranged().divergence());
        world.method_8649((class_1297)bulletEntity);
        SCRangeWeaponUtil.playSoundForPlayers(world, stack, player);
        if (!player.method_7337()) {
            stack.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            SCRangeWeaponUtil.spawnParticleTrail(serverWorld, player, player.method_6058(), (class_2394)ModParticles.MUZZLES_SMOKE_PARTICLE.get(), 100, 0.2f, 5.0E-4f, 5);
            SCRangeWeaponUtil.spawnParticleTrail(serverWorld, player, player.method_6058(), (class_2394)ModParticles.MUZZLES_FLASH_PARTICLE.get(), 1, 0.0f, 0.1f, 6);
        }
    }

    private static void playSoundForPlayers(class_1937 world, class_1799 stack, class_1657 player) {
        if (world == null) {
            return;
        }
        WeaponDefinitionsLoader.DefinitionData definitionData = WeaponDefinitionsLoader.getData(stack);
        if (definitionData == null || definitionData.ranged() == null || definitionData.ranged().soundEvent() == null) {
            return;
        }
        for (class_1657 playerEntity : world.method_18456()) {
            if (playerEntity == null) continue;
            class_243 hearPos = playerEntity.method_19538();
            double distance = player.method_19538().method_1022(hearPos);
            float volume = (float)Math.max(0.0, 1.0 - distance * 0.01);
            if (!(volume > 0.0f)) continue;
            playerEntity.method_17356(definitionData.ranged().soundEvent(), class_3419.field_15245, volume, 1.0f);
        }
    }

    private static void spawnParticleTrail(class_3218 world, class_1657 player, class_1268 hand, class_2394 particle, int count, float delta, float spread, int distance) {
        class_243 handPos = SCRangeWeaponUtil.getHandPosition(player, hand);
        class_243 lookDir = player.method_5828(1.0f);
        for (int i = 0; i < distance; ++i) {
            class_243 pos = handPos.method_1019(lookDir.method_1021((double)i));
            world.method_14199(particle, pos.field_1352, pos.field_1351, pos.field_1350, count, (double)delta, (double)delta, (double)delta, (double)spread);
        }
    }

    private static class_243 getHandPosition(class_1657 player, class_1268 hand) {
        boolean isMainHand = hand == class_1268.field_5808;
        double xOffset = isMainHand ? 0.1 : -0.1;
        double yOffset = 1.5;
        double zOffset = 1.5;
        class_243 basePos = player.method_19538().method_1031(0.0, yOffset, 0.0);
        class_243 sideOffset = player.method_5828(1.0f).method_1036(new class_243(0.0, 1.0, 0.0)).method_1021(xOffset);
        return basePos.method_1019(sideOffset).method_1019(player.method_5828(1.0f).method_1021(zOffset));
    }

    public static Optional<class_1799> getArrowFromInventory(class_1657 player) {
        return player.method_31548().field_7547.stream().filter(stack -> !stack.method_7960() && stack.method_7909() instanceof class_1744).findFirst();
    }

    public static int getArrowSlot(class_1657 player) {
        class_2371 main = player.method_31548().field_7547;
        for (int i = 0; i < main.size(); ++i) {
            class_1799 s = (class_1799)main.get(i);
            if (s.method_7960() || !(s.method_7909() instanceof class_1744)) continue;
            return i;
        }
        return -1;
    }

    public static float getBowPullProgress(int useTicks) {
        float pull = (float)useTicks / 20.0f;
        pull = (pull * pull + pull * 2.0f) / 3.0f;
        return Math.min(pull, 1.0f);
    }

    public static float getCrossbowPullProgress(int useTicks, class_1799 itemStack) {
        if (WeaponDefinitionsLoader.getData(itemStack).ranged() == null) {
            return 0.0f;
        }
        int chargeTime = WeaponDefinitionsLoader.getData(itemStack).ranged().rechargeTime() * 20;
        float progress = (float)useTicks / (float)chargeTime;
        return Math.min(progress, 1.0f);
    }

    public static void loadAndPlayCrossbowSound(class_1937 world, class_1799 stack, class_1657 player) {
        if (world.field_9236) {
            return;
        }
        world.method_8396(null, player.method_24515(), class_3417.field_14626, class_3419.field_15248, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.5f + 1.0f));
        SCRangeWeaponUtil.setWeaponState(stack, new WeaponState(false, true, false));
    }

    public static class_1271<class_1799> handleCrossbowUse(class_1937 world, class_1657 player, class_1268 hand, class_1799 stack) {
        WeaponState state = SCRangeWeaponUtil.getWeaponState(stack);
        if (state.isCharged()) {
            Optional<class_1799> arrowOpt = SCRangeWeaponUtil.getArrowFromInventory(player);
            if (arrowOpt.isPresent()) {
                SCRangeWeaponUtil.shootArrow(world, stack, player, arrowOpt.get(), 1.0f);
                SCRangeWeaponUtil.setWeaponState(stack, new WeaponState(false, false, true));
                return class_1271.method_22428((Object)stack);
            }
            return class_1271.method_22431((Object)stack);
        }
        player.method_6019(hand);
        return class_1271.method_22428((Object)stack);
    }

    public static AmmoRequirement getAmmoRequirement(class_1799 itemStack) {
        WeaponDefinitionsLoader.DefinitionData definitionData = WeaponDefinitionsLoader.getData(itemStack);
        if (definitionData.ranged() == null) {
            return null;
        }
        Map<String, WeaponDefinitionsLoader.AmmoRequirementData> ammoRequirementMap = definitionData.ranged().ammoRequirement();
        int amountFirstItem = 0;
        class_1792[] firstItems = null;
        int amountSecondItem = 0;
        class_1792[] secondItems = null;
        int amountThirdItem = 0;
        class_1792[] thirdItems = null;
        if (ammoRequirementMap.containsKey("item1")) {
            WeaponDefinitionsLoader.AmmoRequirementData item1Data = ammoRequirementMap.get("item1");
            amountFirstItem = item1Data.amount();
            firstItems = SCRangeWeaponUtil.getItemsFromIds(item1Data.itemIds());
        }
        if (ammoRequirementMap.containsKey("item2")) {
            WeaponDefinitionsLoader.AmmoRequirementData item2Data = ammoRequirementMap.get("item2");
            amountSecondItem = item2Data.amount();
            secondItems = SCRangeWeaponUtil.getItemsFromIds(item2Data.itemIds());
        }
        if (ammoRequirementMap.containsKey("item3")) {
            WeaponDefinitionsLoader.AmmoRequirementData item3Data = ammoRequirementMap.get("item3");
            amountThirdItem = item3Data.amount();
            thirdItems = SCRangeWeaponUtil.getItemsFromIds(item3Data.itemIds());
        }
        return amountFirstItem >= 1 ? new AmmoRequirement(amountFirstItem, firstItems[0], firstItems.length > 1 ? firstItems[1] : null, amountSecondItem, secondItems != null ? secondItems[0] : null, secondItems != null && secondItems.length > 1 ? secondItems[1] : null, amountThirdItem, thirdItems != null ? thirdItems[0] : null, thirdItems != null && thirdItems.length > 1 ? thirdItems[1] : null) : null;
    }

    private static class_1792[] getItemsFromIds(Set<String> itemIds) {
        return (class_1792[])itemIds.stream().map(class_2960::new).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).toArray(class_1792[]::new);
    }

    public record WeaponState(boolean isReloading, boolean isCharged, boolean isShooting) {
        public static WeaponState fromNbt(class_2487 nbt) {
            if (nbt == null) {
                return new WeaponState(false, false, false);
            }
            return new WeaponState(nbt.method_10577(SCRangeWeaponUtil.KEY_RELOAD), nbt.method_10577(SCRangeWeaponUtil.KEY_CHARGED), nbt.method_10577(SCRangeWeaponUtil.KEY_SHOOT));
        }

        public void applyToNbt(class_2487 nbt) {
            if (nbt == null) {
                return;
            }
            nbt.method_10556(SCRangeWeaponUtil.KEY_RELOAD, this.isReloading);
            nbt.method_10556(SCRangeWeaponUtil.KEY_CHARGED, this.isCharged);
            nbt.method_10556(SCRangeWeaponUtil.KEY_SHOOT, this.isShooting);
        }
    }

    public record AmmoRequirement(int amountFirstItem, class_1792 firstItem, class_1792 firstItem2nOption, int amountSecondItem, class_1792 secondItem, class_1792 secondItem2nOption, int amountThirdItem, class_1792 thirdItem, class_1792 thirdItem2nOption) {
    }
}

