/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore;

import banduty.stoneycore.commands.SCCommandsHandler;
import banduty.stoneycore.config.StoneyCoreConfig;
import banduty.stoneycore.datagen.ModItemTagProvider;
import banduty.stoneycore.datagen.ModModelProvider;
import banduty.stoneycore.datagen.ModRecipeProvider;
import banduty.stoneycore.entity.ModEntities;
import banduty.stoneycore.event.AdjustAttributeModifierEvent;
import banduty.stoneycore.event.CraftingPreviewHandler;
import banduty.stoneycore.event.PlayerAttackHitHandler;
import banduty.stoneycore.event.PlayerBlockBreakAfterHandler;
import banduty.stoneycore.event.PlayerBlockBreakBeforeHandler;
import banduty.stoneycore.event.PlayerNameTagHandler;
import banduty.stoneycore.event.StartTickHandler;
import banduty.stoneycore.event.UseBlockHandler;
import banduty.stoneycore.event.UseEntityHandler;
import banduty.stoneycore.event.custom.CraftingPreviewCallback;
import banduty.stoneycore.event.custom.PlayerNameTagEvents;
import banduty.stoneycore.items.SCItems;
import banduty.stoneycore.networking.ModMessages;
import banduty.stoneycore.particle.ModParticles;
import banduty.stoneycore.screen.ModScreenHandlers;
import banduty.stoneycore.sounds.ModSounds;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.data.playerdata.IEntityDataSaver;
import banduty.stoneycore.util.data.playerdata.PDKeys;
import banduty.stoneycore.util.data.playerdata.SCAttributes;
import banduty.stoneycore.util.data.playerdata.StaminaData;
import banduty.stoneycore.util.definitionsloader.AccessoriesDefinitionsLoader;
import banduty.stoneycore.util.definitionsloader.ArmorDefinitionsLoader;
import banduty.stoneycore.util.definitionsloader.LandDefinitionsLoader;
import banduty.stoneycore.util.definitionsloader.SiegeEngineDefinitionsLoader;
import banduty.stoneycore.util.definitionsloader.WeaponDefinitionsLoader;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import io.wispforest.accessories.api.events.AdjustAttributeModifierCallback;
import net.bettercombat.api.client.BetterCombatClientEvents;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoneyCore
implements ModInitializer,
DataGeneratorEntrypoint {
    public static final String MOD_ID = "stoneycore";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"stoneycore");
    private static final StoneyCoreConfig CONFIG = StoneyCoreConfig.createAndLoad();
    public static final DeferredRegister<class_1320> ATTRIBUTES = DeferredRegister.create((String)"stoneycore", (class_5321)class_7924.field_41251);
    public static final RegistrySupplier<class_1320> HUNGER_DRAIN_MULTIPLIER = ATTRIBUTES.register("hunger_drain_multiplier", () -> SCAttributes.HUNGER_DRAIN_MULTIPLIER);
    public static final RegistrySupplier<class_1320> STAMINA = ATTRIBUTES.register("stamina", () -> SCAttributes.STAMINA);
    public static final RegistrySupplier<class_1320> MAX_STAMINA = ATTRIBUTES.register("max_stamina", () -> SCAttributes.MAX_STAMINA);

    public void onInitialize() {
        ATTRIBUTES.register();
        ModSounds.registerSounds();
        SCItems.registerItems();
        ModEntities.registerEntities();
        ModMessages.registerC2SPackets();
        ModScreenHandlers.registerScreenHandlers();
        ServerTickEvents.START_SERVER_TICK.register((Object)new StartTickHandler());
        PlayerBlockBreakEvents.AFTER.register((Object)new PlayerBlockBreakAfterHandler());
        PlayerBlockBreakEvents.BEFORE.register((Object)new PlayerBlockBreakBeforeHandler());
        UseBlockCallback.EVENT.register((Object)new UseBlockHandler());
        BetterCombatClientEvents.ATTACK_HIT.register((Object)new PlayerAttackHitHandler());
        AdjustAttributeModifierCallback.EVENT.register((Object)new AdjustAttributeModifierEvent());
        UseEntityCallback.EVENT.register((Object)new UseEntityHandler());
        PlayerNameTagEvents.EVENT.register((Object)new PlayerNameTagHandler());
        CraftingPreviewCallback.EVENT.register((Object)new CraftingPreviewHandler());
        ModParticles.registerParticles();
        CommandRegistrationCallback.EVENT.register((Object)new SCCommandsHandler());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new WeaponDefinitionsLoader());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ArmorDefinitionsLoader());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new AccessoriesDefinitionsLoader());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new LandDefinitionsLoader());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SiegeEngineDefinitionsLoader());
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();
            if (player != null) {
                double currentStamina = StaminaData.getStamina((class_1309)player);
                StaminaData.saveStamina((IEntityDataSaver)player, currentStamina);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            if (player != null) {
                if (NBTDataHelper.get((IEntityDataSaver)player, PDKeys.FIRST_JOIN, Boolean.valueOf(false)).booleanValue()) {
                    StaminaData.loadStamina((class_1309)player);
                    return;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a74StoneyCore \u00a7radds an overlay that makes a noise effect.\nIf you have \u00a74epilepsy \u00a7rit is \u00a7lhighly recommended \u00a7rto \u00a74disable Noise Effect.\n"), false);
                NBTDataHelper.set((IEntityDataSaver)player, PDKeys.FIRST_JOIN, Boolean.valueOf(true));
                StaminaData.setStamina((class_1309)player, player.method_26825((class_1320)MAX_STAMINA.get()));
            }
        });
    }

    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ModModelProvider::new);
        pack.addProvider(ModRecipeProvider::new);
        pack.addProvider(ModItemTagProvider::new);
    }

    public static StoneyCoreConfig getConfig() {
        return CONFIG;
    }
}

