/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.commands.land;

import banduty.stoneycore.commands.SCCommandsHandler;
import banduty.stoneycore.event.StartTickHandler;
import banduty.stoneycore.lands.LandType;
import banduty.stoneycore.lands.LandTypeRegistry;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandState;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class Create {
    public static LiteralArgumentBuilder<class_2168> registerCreate() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"landType", (ArgumentType)class_2232.method_9441()).suggests((ctx, builder) -> {
            for (LandType type : LandTypeRegistry.getAll()) {
                builder.suggest(type.id().toString());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"owner", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            for (class_3222 player : ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571()) {
                UUID uuid = player.method_5667();
                if (!LandState.get(world).getLandByOwner(uuid).isPresent()) continue;
                builder.suggest(player.method_7334().getName());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"x", (ArgumentType)IntegerArgumentType.integer()).suggests((ctx, builder) -> {
            builder.suggest(((class_2168)ctx.getSource()).method_44023().method_24515().method_10263());
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"y", (ArgumentType)IntegerArgumentType.integer()).suggests((ctx, builder) -> {
            builder.suggest(((class_2168)ctx.getSource()).method_44023().method_24515().method_10264());
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"z", (ArgumentType)IntegerArgumentType.integer()).suggests((ctx, builder) -> {
            builder.suggest(((class_2168)ctx.getSource()).method_44023().method_24515().method_10260());
            return builder.buildFuture();
        }).executes(ctx -> Create.createLand((class_2168)ctx.getSource(), class_2232.method_9443((CommandContext)ctx, (String)"landType"), StringArgumentType.getString((CommandContext)ctx, (String)"owner"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"x"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"y"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"z"))))))));
    }

    private static int createLand(class_2168 src, class_2960 typeId, String ownerName, int x, int y, int z) {
        Optional<LandType> typeOpt = LandTypeRegistry.getById(typeId);
        if (typeOpt.isEmpty()) {
            return SCCommandsHandler.error(src, String.valueOf(typeId) + " isn\u2019t a correct LandType");
        }
        UUID ownerUUID = SCCommandsHandler.getUUID(src, ownerName);
        if (ownerUUID == null) {
            return SCCommandsHandler.error(src, "Unknown owner " + ownerName);
        }
        class_3218 world = src.method_9225();
        LandState state = LandState.get(world);
        if (state.getLandByOwner(ownerUUID).isPresent()) {
            return SCCommandsHandler.error(src, ownerName + " already own a Land");
        }
        class_2338 pos = new class_2338(x, y, z);
        if (state.getLandAt(pos).isPresent()) {
            return SCCommandsHandler.error(src, "This block pos is occupied by another Land");
        }
        Land land = new Land(ownerUUID, pos, typeOpt.get().baseRadius(), typeOpt.get(), "", typeOpt.get().maxAllies());
        land.initializeClaim(world, typeOpt.get().baseRadius(), StartTickHandler.CLAIM_TASKS);
        world.method_8501(pos, typeOpt.get().coreBlock().method_9564());
        state.addLand(land);
        src.method_9226(() -> class_2561.method_43470((String)("Land created for " + ownerName)), true);
        return 1;
    }
}

