/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.mixin;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.StoneyCoreClient;
import banduty.stoneycore.event.KeyInputHandler;
import banduty.stoneycore.mixin.GameRendererAccessor;
import banduty.stoneycore.util.data.itemdata.INBTKeys;
import banduty.stoneycore.util.data.itemdata.SCTags;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.data.playerdata.IEntityDataSaver;
import banduty.stoneycore.util.data.playerdata.StaminaData;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.owo.shader.BlurProgram;
import net.minecraft.class_1041;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4599;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_757.class})
public class GameRendererMixin {
    @Unique
    private static final class_2960 VISOR_HELMET = new class_2960("stoneycore", "textures/overlay/visor_helmet.png");
    @Unique
    private static final BlurProgram BLUR = new BlurProgram();
    @Unique
    private class_2960[] noiseTextures;
    @Unique
    private int currentNoiseTexture = 0;
    @Unique
    private int currentNoiseTextureTime = 0;
    @Unique
    private static final class_2960 VISOR_PROGRESS_BACKGROUND = new class_2960("stoneycore", "textures/overlay/visor_progress_background.png");
    @Unique
    private static final class_2960 VISOR_PROGRESS_BAR = new class_2960("stoneycore", "textures/overlay/visor_progress_bar.png");
    @Unique
    private float lastRenderedProgress = 0.0f;

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/DiffuseLighting;enableGuiDepthLighting()V", shift=At.Shift.AFTER)})
    private void renderSCThings(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        class_757 gameRenderer = (class_757)this;
        if (!tick || gameRenderer.method_35772().field_1687 == null) {
            return;
        }
        class_4599 buffers = ((GameRendererAccessor)gameRenderer).getBuffers();
        class_332 context = new class_332(gameRenderer.method_35772(), buffers.method_23000());
        class_1041 window = gameRenderer.method_35772().method_22683();
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.method_4489() / window.method_4495()), (float)((double)window.method_4506() / window.method_4495()), 0.0f, 1000.0f, 21000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_34426();
        matrixStack.method_46416(0.0f, 0.0f, -11000.0f);
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        this.dontMessItNow(context, tickDelta);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        context.method_51452();
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    @Unique
    private void dontMessItNow(class_332 context, float tickDelta) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null || player.method_7325()) {
            return;
        }
        int width = context.method_51421();
        int height = context.method_51443();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (AccessoriesCapability.getOptionally((class_1309)player).isPresent()) {
            for (SlotEntryReference equipped : AccessoriesCapability.get((class_1309)player).getAllEquipped()) {
                class_1799 itemStack = equipped.stack();
                if (NBTDataHelper.get(itemStack, INBTKeys.VISOR_OPEN, Boolean.valueOf(false)).booleanValue() || !itemStack.method_31573(SCTags.VISORED_HELMET.getTag()) || !StoneyCore.getConfig().visualOptions.getVisoredHelmet()) continue;
                RenderSystem.setShaderTexture((int)0, (class_2960)VISOR_HELMET);
                context.method_51422(1.0f, 1.0f, 1.0f, player.method_7337() ? StoneyCore.getConfig().visualOptions.getVisoredHelmetAlpha() : 1.0f);
                context.method_25290(VISOR_HELMET, 0, 0, 0.0f, 0.0f, width, height, width, height);
                break;
            }
        }
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        double stamina = StaminaData.getStamina((class_1309)player);
        double secondLevel = player.method_26826((class_1320)StoneyCore.MAX_STAMINA.get()) * 0.15;
        if (!player.method_7337() && StaminaData.isStaminaBlocked((IEntityDataSaver)player) && StoneyCore.getConfig().visualOptions.getLowStaminaIndicator()) {
            double staminaPercentage = stamina / secondLevel;
            if (StoneyCore.getConfig().combatOptions.getRealisticCombat()) {
                if (this.noiseTextures == null) {
                    this.initNoiseTextures();
                }
                this.renderBlurEffect(context, width, height, staminaPercentage);
            } else {
                int opacity = (int)(Math.max(0.0, (double)0.4f - staminaPercentage) * 255.0);
                int green = StaminaData.isStaminaBlocked((IEntityDataSaver)player) ? 0 : (int)(stamina / secondLevel);
                int gradientColorEnd = opacity << 24 | green | 0xFF0000;
                context.method_25296(0, 0, width, height, 0xFFFFFF, gradientColorEnd);
            }
        }
        this.renderVisorToggleProgress(context, tickDelta);
        StoneyCoreClient.LAND_TITLE_RENDERER.render(context);
    }

    @Unique
    private void initNoiseTextures() {
        this.noiseTextures = new class_2960[12];
        for (int i = 0; i < this.noiseTextures.length; ++i) {
            this.noiseTextures[i] = new class_2960("stoneycore", "textures/overlay/noise/noise_" + i + ".png");
        }
    }

    @Unique
    private void renderBlurEffect(class_332 context, int width, int height, double staminaPercentage) {
        this.renderBlur(context, width, height, staminaPercentage);
        this.renderTunnelVision(context, width, height, staminaPercentage);
        if (StoneyCore.getConfig().visualOptions.getNoiseEffect()) {
            this.renderNoise(context, width, height, staminaPercentage);
        }
    }

    @Unique
    private void renderBlur(class_332 context, int width, int height, double staminaPercentage) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        buffer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_1344();
        buffer.method_22918(matrix, 0.0f, (float)height, 0.0f).method_1344();
        buffer.method_22918(matrix, (float)width, (float)height, 0.0f).method_1344();
        buffer.method_22918(matrix, (float)width, 0.0f, 0.0f).method_1344();
        float blur = (float)(Math.max((double)0.1f, 1.0 - staminaPercentage) * 12.0);
        BLUR.setParameters(16, 12.0f, blur);
        BLUR.use();
        tessellator.method_1350();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    @Unique
    private void renderNoise(class_332 context, int width, int height, double staminaPercentage) {
        class_2960 noiseTexture = this.noiseTextures[this.currentNoiseTexture];
        float alpha = (float)((double)(-0.001f * (float)this.currentNoiseTextureTime * (float)(this.currentNoiseTextureTime - 10)) + Math.max(0.0, 1.0 - staminaPercentage) * (double)0.2f);
        if (this.currentNoiseTextureTime-- <= 0 && !class_310.method_1551().method_1493()) {
            this.currentNoiseTexture = (this.currentNoiseTexture + 1) % this.noiseTextures.length;
            this.currentNoiseTextureTime = 10;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.5f, (float)alpha);
        context.method_25290(noiseTexture, 0, 0, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    @Unique
    private void renderTunnelVision(class_332 context, int width, int height, double staminaPercentage) {
        int opacity = (int)(Math.max(0.0, (double)0.2f - staminaPercentage) * 255.0);
        int gradientColor = opacity << 24;
        int opacity2 = (int)(Math.max(0.0, (double)0.6f - staminaPercentage) * 255.0);
        int gradientColor2 = opacity2 << 24;
        context.method_25296(0, 0, width, height, gradientColor, gradientColor2);
    }

    @Unique
    private void renderVisorToggleProgress(class_332 context, float tickDelta) {
        float smoothProgress;
        if (StoneyCore.getConfig().combatOptions.getToggleVisorTime() == 0 || !KeyInputHandler.isTogglingVisor || KeyInputHandler.visorToggled || (float)KeyInputHandler.toggleVisorTicks <= 0.0f) {
            this.lastRenderedProgress = 0.0f;
            return;
        }
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        int yOffset = 50;
        int bgWidth = 128;
        int bgHeight = 16;
        int barWidth = 124;
        int barHeight = 12;
        float targetProgress = KeyInputHandler.toggleProgress;
        float interpolationSpeed = 20.0f;
        this.lastRenderedProgress = smoothProgress = this.lastRenderedProgress + (targetProgress - this.lastRenderedProgress) * Math.min(1.0f, interpolationSpeed * tickDelta);
        int progressWidth = (int)((float)barWidth * smoothProgress);
        int bgX = centerX - bgWidth / 2;
        int bgY = centerY + yOffset - bgHeight / 2;
        context.method_25290(VISOR_PROGRESS_BACKGROUND, bgX, bgY, 0.0f, 0.0f, bgWidth, bgHeight, bgWidth, bgHeight);
        if (progressWidth > 0) {
            int barX = centerX - barWidth / 2;
            int barY = centerY + yOffset - barHeight / 2;
            context.method_25290(VISOR_PROGRESS_BAR, barX, barY, 0.0f, 0.0f, progressWidth, barHeight, barWidth, barHeight);
        }
    }
}

