/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.siege;

import banduty.stoneycore.StoneyCore;
import banduty.stoneycore.lands.util.Land;
import banduty.stoneycore.lands.util.LandManager;
import banduty.stoneycore.lands.util.LandState;
import banduty.stoneycore.networking.ModMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1259;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;

public class SiegeManager {
    private static final Map<class_3218, List<Siege>> sieges = new HashMap<class_3218, List<Siege>>();

    public static Optional<Siege> getPlayerSiege(class_3218 world, UUID playerId) {
        List<Siege> worldSieges = sieges.get(world);
        if (worldSieges == null) {
            return Optional.empty();
        }
        return worldSieges.stream().filter(siege -> siege.isParticipant(playerId)).findFirst();
    }

    public static boolean isPlayerInLandUnderSiege(class_3218 world, class_1657 player) {
        Optional<Land> land = LandManager.getLandByPosition(world, player.method_24515());
        return land.isPresent() && SiegeManager.isLandDefenseSiege(world, land.get());
    }

    public static boolean isLandDefenseSiege(class_3218 world, Land land) {
        List worldSieges = sieges.getOrDefault(world, Collections.emptyList());
        return worldSieges.stream().anyMatch(siege -> siege.defendingLand.equals(land));
    }

    public static boolean isLandAttackingSiege(class_3218 world, Land land) {
        List worldSieges = sieges.getOrDefault(world, Collections.emptyList());
        return worldSieges.stream().anyMatch(siege -> siege.attackingLand.equals(land));
    }

    public static void tick(class_3218 world) {
        List<Siege> worldSieges = sieges.get(world);
        if (worldSieges == null) {
            return;
        }
        LandState landState = LandState.get(world);
        class_3324 playerManager = world.method_8503().method_3760();
        Iterator<Siege> iterator = worldSieges.iterator();
        while (iterator.hasNext()) {
            Siege siege = iterator.next();
            Set onlineAttackers = siege.attackers.stream().filter(uuid -> !siege.disabledPlayers.contains(uuid)).filter(uuid -> world.method_8503().method_3760().method_14602(uuid) != null).collect(Collectors.toSet());
            int aliveAttackers = onlineAttackers.size();
            boolean defendingExists = landState.isLandRegistered(siege.defendingLand);
            boolean attackingExists = landState.isLandRegistered(siege.attackingLand);
            if (!defendingExists || !attackingExists || aliveAttackers == 0) {
                boolean attackersWon = !defendingExists;
                Land winner = attackersWon ? siege.attackingLand : siege.defendingLand;
                Land loser = attackersWon ? siege.defendingLand : siege.attackingLand;
                Set<UUID> winners = attackersWon ? siege.attackers : siege.defenders;
                Set<UUID> losers = attackersWon ? siege.defenders : siege.attackers;
                SiegeManager.sendVictoryTitles(winners, playerManager, winner, true);
                SiegeManager.sendVictoryTitles(losers, playerManager, loser, false);
                siege.clearBossBars();
                iterator.remove();
                continue;
            }
            siege.updateBossBar(world);
        }
    }

    private static void sendVictoryTitles(Set<UUID> players, class_3324 playerManager, Land land, boolean won) {
        for (UUID uuid : players) {
            class_3222 player = playerManager.method_14602(uuid);
            if (player == null) continue;
            String namespace = land.getLandType().id().method_12836();
            class_5250 victoryLoseKey = class_2561.method_43471((String)("text.land." + namespace + (won ? ".winner" : ".loser")));
            class_2540 buffer = PacketByteBufs.create();
            buffer.method_10805((class_2561)victoryLoseKey);
            ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.LAND_TITLE_PACKET_ID, (class_2540)buffer);
        }
    }

    public static void startSiege(class_3218 world, UUID attacker, UUID defender) {
        List worldSieges = sieges.computeIfAbsent(world, k -> new ArrayList());
        LandState stateManager = LandState.get(world);
        Optional<Land> maybeAttackingLand = stateManager.getLandByOwner(attacker);
        Optional<Land> maybeDefenderLand = stateManager.getLandByOwner(defender);
        if (maybeAttackingLand.isEmpty() || maybeDefenderLand.isEmpty()) {
            return;
        }
        Land attackingLand = maybeAttackingLand.get();
        Land defendingLand = maybeDefenderLand.get();
        for (Siege siege : worldSieges) {
            if (siege.attackingLand == null || siege.defendingLand == null || !siege.attackingLand.equals(attackingLand) || !siege.defendingLand.equals(defendingLand)) continue;
            return;
        }
        Siege newSiege = new Siege(attacker, defender, world, attackingLand, defendingLand);
        newSiege.attackers.add(attackingLand.getOwnerUUID());
        newSiege.attackers.addAll(attackingLand.getAllies());
        newSiege.defenders.add(defendingLand.getOwnerUUID());
        newSiege.defenders.addAll(defendingLand.getAllies());
        worldSieges.add(newSiege);
    }

    public static Set<class_3222> getAllAttackingPlayers(class_3218 world) {
        class_3324 playerManager = world.method_8503().method_3760();
        List worldSieges = sieges.getOrDefault(world, Collections.emptyList());
        return worldSieges.stream().flatMap(siege -> siege.attackers.stream()).map(arg_0 -> ((class_3324)playerManager).method_14602(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<class_3222> getAllDefendingPlayers(class_3218 world) {
        class_3324 playerManager = world.method_8503().method_3760();
        List worldSieges = sieges.getOrDefault(world, Collections.emptyList());
        return worldSieges.stream().flatMap(siege -> siege.defenders.stream()).map(arg_0 -> ((class_3324)playerManager).method_14602(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<class_3222> getAllParticipants(class_3218 world) {
        HashSet<class_3222> participants = new HashSet<class_3222>();
        participants.addAll(SiegeManager.getAllAttackingPlayers(world));
        participants.addAll(SiegeManager.getAllDefendingPlayers(world));
        return participants;
    }

    public static class_1269 surrender(class_3218 serverWorld, class_1657 player, Land land) {
        LandState stateManager = LandState.get(serverWorld);
        for (class_3222 serverPlayerEntity : SiegeManager.getAllParticipants(serverWorld)) {
            SiegeManager.sendTitle(serverPlayerEntity, (class_2561)class_2561.method_43469((String)("text.land." + land.getLandType().id().method_12836() + ".surrender"), (Object[])new Object[]{land.getLandTitle(serverWorld).getString()}));
        }
        stateManager.removeLand(land);
        player.method_6047().method_7934(1);
        return class_1269.field_5812;
    }

    public static void sendTitle(class_3222 player, class_2561 mainTitle) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10805(mainTitle);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.LAND_TITLE_PACKET_ID, (class_2540)buffer);
    }

    public static List<Siege> getSiegesForWorld(class_3218 world) {
        return sieges.computeIfAbsent(world, k -> new ArrayList());
    }

    public static class Siege {
        public final Land attackingLand;
        public final Land defendingLand;
        private final int initialRadius;
        public final Set<UUID> attackers = new HashSet<UUID>();
        public final Set<UUID> defenders = new HashSet<UUID>();
        public final Set<UUID> disabledPlayers = new HashSet<UUID>();
        private final class_3213 attackerBar;
        private final class_3213 defenderBar;

        public Siege(UUID attacker, UUID defender, class_3218 world, Land attackingLand, Land defendingLand) {
            this.attackingLand = attackingLand;
            this.defendingLand = defendingLand;
            this.initialRadius = defendingLand.getRadius();
            String attackerName = LandManager.getLandName(world, attacker).getString();
            String defenderName = LandManager.getLandName(world, defender).getString();
            this.attackerBar = new class_3213((class_2561)class_2561.method_43470((String)("Defenders Remaining: " + defenderName)), class_1259.class_1260.field_5780, class_1259.class_1261.field_5791);
            this.attackerBar.method_5408(1.0f);
            this.defenderBar = new class_3213((class_2561)class_2561.method_43470((String)("Attackers Remaining: " + attackerName)), class_1259.class_1260.field_5784, class_1259.class_1261.field_5791);
            this.defenderBar.method_5408(1.0f);
        }

        public boolean isParticipant(UUID playerId) {
            return this.attackers.contains(playerId) || this.defenders.contains(playerId);
        }

        public boolean isDisabled(UUID playerId) {
            return this.disabledPlayers.contains(playerId);
        }

        public void disablePlayer(UUID playerId, class_3218 world) {
            this.disabledPlayers.add(playerId);
            if (StoneyCore.getConfig().landOptions.removeClaimedSiege()) {
                this.updateDefendingLandRadius(world);
            }
        }

        private void updateDefendingLandRadius(class_3218 world) {
            int totalDefenders = this.defenders.size();
            if (totalDefenders == 0) {
                return;
            }
            long deadDefenders = this.defenders.stream().filter(this.disabledPlayers::contains).count();
            int blocksPerDefender = Math.max(this.initialRadius / totalDefenders, 1);
            int previousRadius = this.defendingLand.getRadius();
            int newRadius = this.initialRadius - (int)(deadDefenders * (long)blocksPerDefender);
            if ((newRadius = Math.max(newRadius, 3)) != previousRadius) {
                this.defendingLand.setRadius(newRadius, world);
                for (UUID uuid : this.defenders) {
                    class_3222 player = world.method_8503().method_3760().method_14602(uuid);
                    if (player == null) continue;
                    SiegeManager.sendTitle(player, (class_2561)class_2561.method_43470((String)(previousRadius + " \u279d " + newRadius)));
                }
            }
        }

        public boolean isActive() {
            return !this.attackers.isEmpty() || !this.defenders.isEmpty();
        }

        public void updateBossBar(class_3218 world) {
            class_3222 player;
            int totalAttackers = this.attackers.size();
            int totalDefenders = this.defenders.size();
            Set onlineAttackers = this.attackers.stream().filter(uuid -> !this.disabledPlayers.contains(uuid)).filter(uuid -> world.method_8503().method_3760().method_14602(uuid) != null).collect(Collectors.toSet());
            Set onlineDefenders = this.defenders.stream().filter(uuid -> !this.disabledPlayers.contains(uuid)).filter(uuid -> world.method_8503().method_3760().method_14602(uuid) != null).collect(Collectors.toSet());
            int aliveAttackers = onlineAttackers.size();
            int aliveDefenders = onlineDefenders.size();
            float defendersRatio = totalDefenders == 0 ? 0.0f : (float)aliveDefenders / (float)totalDefenders;
            float attackersRatio = totalAttackers == 0 ? 0.0f : (float)aliveAttackers / (float)totalAttackers;
            this.attackerBar.method_5413((class_2561)class_2561.method_43469((String)("text.land." + this.attackingLand.getLandType().id().method_12836() + ".defenders_remaining"), (Object[])new Object[]{this.attackingLand.getLandTitle(world).getString(), this.defendingLand.getLandTitle(world).getString(), aliveDefenders, totalDefenders}));
            this.defenderBar.method_5413((class_2561)class_2561.method_43469((String)("text.land." + this.defendingLand.getLandType().id().method_12836() + ".attackers_remaining"), (Object[])new Object[]{this.attackingLand.getLandTitle(world).getString(), this.defendingLand.getLandTitle(world).getString(), aliveAttackers, totalAttackers}));
            this.attackerBar.method_5408(defendersRatio);
            this.defenderBar.method_5408(attackersRatio);
            this.attackerBar.method_14094();
            this.defenderBar.method_14094();
            for (UUID uuid2 : this.attackers) {
                player = world.method_8503().method_3760().method_14602(uuid2);
                if (player == null) continue;
                this.attackerBar.method_14088(player);
            }
            for (UUID uuid2 : this.defenders) {
                player = world.method_8503().method_3760().method_14602(uuid2);
                if (player == null) continue;
                this.defenderBar.method_14088(player);
            }
        }

        public void clearBossBars() {
            this.attackerBar.method_14094();
            this.defenderBar.method_14094();
        }
    }
}

