/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.data.keys;

import banduty.stoneycore.util.data.keys.SCKey;
import banduty.stoneycore.util.data.playerdata.IEntityDataSaver;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.CheckReturnValue;

public class NBTDataHelper {
    public static <T> void set(IEntityDataSaver entity, SCKey<T> key, T value) {
        NBTDataHelper.set(entity.stoneycore$getPersistentData(), key, value);
    }

    @CheckReturnValue
    public static <T> T get(IEntityDataSaver entity, SCKey<T> key, T defaultValue) {
        return NBTDataHelper.get(entity.stoneycore$getPersistentData(), key, defaultValue);
    }

    public static <T> void set(class_1799 stack, SCKey<T> key, T value) {
        NBTDataHelper.set(stack.method_7948(), key, value);
    }

    @CheckReturnValue
    public static <T> T get(class_1799 stack, SCKey<T> key, T defaultValue) {
        return NBTDataHelper.get(stack.method_7969(), key, defaultValue);
    }

    public static <T> void set(class_2487 nbt, SCKey<T> key, T value) {
        if (nbt == null) {
            return;
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            nbt.method_10556(key.name(), b.booleanValue());
        } else if (value instanceof Integer) {
            Integer i = (Integer)value;
            nbt.method_10569(key.name(), i.intValue());
        } else if (value instanceof Long) {
            Long l = (Long)value;
            nbt.method_10544(key.name(), l.longValue());
        } else if (value instanceof Double) {
            Double d = (Double)value;
            nbt.method_10549(key.name(), d.doubleValue());
        } else if (value instanceof String) {
            String s = (String)value;
            nbt.method_10582(key.name(), s);
        } else if (value instanceof Float) {
            Float f = (Float)value;
            nbt.method_10548(key.name(), f.floatValue());
        } else {
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(key.type()));
        }
    }

    public static <T> T get(class_2487 nbt, SCKey<T> key, T defaultValue) {
        if (nbt == null || !nbt.method_10545(key.name())) {
            return defaultValue;
        }
        Class<T> type = key.type();
        if (type == Float.class) {
            return (T)Float.valueOf(nbt.method_10583(key.name()));
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(nbt.method_10577(key.name()));
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(nbt.method_10550(key.name()));
        }
        if (type == Long.class) {
            return (T)Long.valueOf(nbt.method_10537(key.name()));
        }
        if (type == Double.class) {
            return (T)Double.valueOf(nbt.method_10574(key.name()));
        }
        if (type == String.class) {
            return (T)nbt.method_10558(key.name());
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }
}

