/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.patterns;

import banduty.stoneycore.structure.StructureSpawnRegistry;
import banduty.stoneycore.structure.StructureSpawner;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_174;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2697;
import net.minecraft.class_2700;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;

public class StructureHelper {
    @Unique
    private static Map<class_2248, List<StructureSpawner>> blockToSpawners = null;
    @Unique
    private static final Map<StructureSpawner, EnumMap<class_2350, class_2700>> patternCache = new IdentityHashMap<StructureSpawner, EnumMap<class_2350, class_2700>>();

    public static void trySpawnEntity(class_1937 world, class_2338 pos, class_2680 state) {
        class_2248 block;
        List<StructureSpawner> spawners;
        if (state == null) {
            return;
        }
        if (blockToSpawners == null) {
            blockToSpawners = new HashMap<class_2248, List<StructureSpawner>>();
            for (StructureSpawner spawner : StructureSpawnRegistry.getAll()) {
                for (class_2248 block2 : spawner.getBlockFinders()) {
                    blockToSpawners.computeIfAbsent(block2, b -> new ArrayList()).add(spawner);
                }
            }
        }
        if ((spawners = blockToSpawners.get(block = state.method_26204())) == null || spawners.isEmpty()) {
            return;
        }
        for (StructureSpawner spawner : spawners) {
            String[][] baseAisle = spawner.getBaseAisles();
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                MatchResult match;
                class_2700 pattern = StructureHelper.getPattern(spawner, baseAisle, dir);
                if (pattern == null || (match = StructureHelper.searchAround((class_4538)world, pos, pattern, dir)) == null) continue;
                class_2700.class_2702 result = match.result();
                class_1297 entity = spawner.createEntity(world);
                if (entity == null) continue;
                StructureHelper.spawnEntity(world, result, entity);
                return;
            }
        }
    }

    @Nullable
    public static MatchResult searchAround(class_4538 world, class_2338 pos, class_2700 pattern, class_2350 forward) {
        int i = Math.max(Math.max(pattern.method_11710(), pattern.method_11713()), pattern.method_11712());
        class_2338 start = pos.method_10059((class_2382)new class_2338(i, i, i));
        class_2338 end = pos.method_10069(i, i, i);
        for (class_2338 blockPos : class_2338.method_10097((class_2338)start, (class_2338)end)) {
            for (class_2350 up : class_2350.class_2353.field_11064) {
                class_2700.class_2702 result;
                if (up == forward || up == forward.method_10153() || (result = pattern.method_35300(world, blockPos, forward, up)) == null) continue;
                return new MatchResult(result, forward);
            }
        }
        return null;
    }

    private static void spawnEntity(class_1937 world, class_2700.class_2702 patternResult, class_1297 entity) {
        StructureHelper.breakPatternBlocks(world, patternResult);
        int centerX = patternResult.method_35302() / 2;
        int centerY = patternResult.method_35303() / 2;
        int centerZ = patternResult.method_35304() / 2;
        class_2338 centerPos = patternResult.method_11717(centerX, centerY, centerZ).method_11683();
        entity.method_5814((double)centerPos.method_10263() + 0.5, (double)centerPos.method_10084().method_10264() + 0.5, (double)centerPos.method_10260() + 0.5);
        world.method_8649(entity);
        for (class_3222 player : world.method_18467(class_3222.class, entity.method_5829().method_1014(5.0))) {
            class_174.field_1182.method_9124(player, entity);
        }
        world.method_8408(centerPos, class_2246.field_10124);
    }

    private static void breakPatternBlocks(class_1937 world, class_2700.class_2702 result) {
        for (int i = 0; i < result.method_35302(); ++i) {
            for (int j = 0; j < result.method_35303(); ++j) {
                for (int k = 0; k < result.method_35304(); ++k) {
                    class_2694 pos = result.method_11717(i, j, k);
                    world.method_8652(pos.method_11683(), class_2246.field_10124.method_9564(), 2);
                    world.method_20290(2001, pos.method_11683(), class_2248.method_9507((class_2680)pos.method_11681()));
                }
            }
        }
    }

    private static class_2700 getPattern(StructureSpawner spawner, String[][] baseAisle, class_2350 dir) {
        EnumMap patterns = patternCache.computeIfAbsent(spawner, k -> new EnumMap(class_2350.class));
        if (patterns.containsKey(dir)) {
            return (class_2700)patterns.get(dir);
        }
        String[][] rotated = switch (dir) {
            case class_2350.field_11035 -> baseAisle;
            case class_2350.field_11039 -> StructureHelper.rotateAislesY90(baseAisle);
            case class_2350.field_11043 -> StructureHelper.rotateAislesY90(StructureHelper.rotateAislesY90(baseAisle));
            case class_2350.field_11034 -> StructureHelper.rotateAislesY90(StructureHelper.rotateAislesY90(StructureHelper.rotateAislesY90(baseAisle)));
            default -> baseAisle;
        };
        class_2697 builder = class_2697.method_11701();
        for (String[] layer : rotated) {
            builder.method_11702(layer);
        }
        spawner.applyKeyMatcher(builder, dir);
        class_2700 pattern = builder.method_11704();
        patterns.put(dir, pattern);
        return pattern;
    }

    private static String[][] rotateAislesY90(String[][] layers) {
        int depth = layers.length;
        int height = layers[0].length;
        int width = layers[0][0].length();
        String[][] rotated = new String[depth][height];
        for (int z = 0; z < depth; ++z) {
            String[] newLayer = new String[height];
            for (int y = 0; y < height; ++y) {
                StringBuilder newRow = new StringBuilder();
                for (int x = 0; x < width; ++x) {
                    newRow.append(layers[z][height - 1 - y].charAt(x));
                }
                newLayer[y] = newRow.reverse().toString();
            }
            rotated[z] = newLayer;
        }
        return rotated;
    }

    public record MatchResult(class_2700.class_2702 result, class_2350 forward) {
    }
}

