/*
 * Decompiled with CFR 0.152.
 */
package banduty.stoneycore.util.weaponutil;

import banduty.stoneycore.entity.custom.SCArrowEntity;
import banduty.stoneycore.entity.custom.SCBulletEntity;
import banduty.stoneycore.particle.ModParticles;
import banduty.stoneycore.util.data.itemdata.INBTKeys;
import banduty.stoneycore.util.data.keys.NBTDataHelper;
import banduty.stoneycore.util.definitionsloader.WeaponDefinitionsLoader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1744;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public final class SCRangeWeaponUtil {
    private SCRangeWeaponUtil() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static class_1271<class_1799> handleCrossbowUse(class_1937 world, class_1657 user, class_1268 hand, class_1799 itemStack) {
        class_1792 class_17922;
        if (world == null || user == null || itemStack == null) {
            return class_1271.method_22431((Object)class_1799.field_8037);
        }
        Optional<class_1799> arrowStackOpt = SCRangeWeaponUtil.getArrowFromInventory(user);
        if (arrowStackOpt.isPresent() && (class_17922 = arrowStackOpt.get().method_7909()) instanceof class_1744) {
            class_1744 arrowItem = (class_1744)class_17922;
            class_1665 arrowEntity = arrowItem.method_7702(world, arrowStackOpt.get(), (class_1309)user);
            WeaponState weaponState = SCRangeWeaponUtil.getWeaponState(itemStack);
            class_2487 nbt = itemStack.method_7948();
            Projectiles projectiles = Projectiles.fromNbt(nbt, arrowEntity);
            if (weaponState.isCharged()) {
                SCRangeWeaponUtil.setWeaponState(itemStack, new WeaponState(false, false, true));
                projectiles = projectiles.unloadProjectile();
                projectiles.applyToNbt(nbt);
                SCRangeWeaponUtil.shootArrow(world, itemStack, user, arrowStackOpt.get(), 1.0f);
                return class_1271.method_22428((Object)itemStack);
            }
            if (projectiles.getArrowCount() < 1) {
                SCRangeWeaponUtil.setWeaponState(itemStack, new WeaponState(true, false, false));
                user.method_6019(hand);
                return class_1271.method_22428((Object)itemStack);
            }
            return class_1271.method_22431((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public static void shootArrow(class_1937 world, class_1799 stack, class_1657 player, class_1799 arrowStack, float pullProgress) {
        class_1792 class_17922 = arrowStack.method_7909();
        if (!(class_17922 instanceof class_1744)) {
            return;
        }
        class_1744 arrowItem = (class_1744)class_17922;
        class_1665 arrowEntity = arrowItem.method_7702(world, arrowStack, (class_1309)player);
        arrowEntity.method_7438((double)WeaponDefinitionsLoader.getData(stack).ranged().baseDamage());
        if (arrowEntity instanceof SCArrowEntity) {
            SCArrowEntity scArrowEntity = (SCArrowEntity)arrowEntity;
            scArrowEntity.setDamageType(WeaponDefinitionsLoader.getData(stack).ranged().damageType());
        }
        arrowEntity.method_7432((class_1297)player);
        if (NBTDataHelper.get(arrowStack, INBTKeys.IGNITED, Boolean.valueOf(false)).booleanValue()) {
            arrowEntity.method_33572(true);
            arrowEntity.method_20803(1000);
        }
        arrowEntity.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, pullProgress * WeaponDefinitionsLoader.getData(stack).ranged().speed(), WeaponDefinitionsLoader.getData(stack).ranged().divergence());
        if (player.method_7337()) {
            arrowEntity.field_7572 = class_1665.class_1666.field_7594;
        } else {
            stack.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
            player.method_31548().method_5434(SCRangeWeaponUtil.getArrowSlot(player), 1);
        }
        world.method_8649((class_1297)arrowEntity);
        SCRangeWeaponUtil.playSoundForPlayers(world, stack, player);
    }

    public static void shootBullet(class_1937 world, class_1799 stack, class_1657 player) {
        SCBulletEntity bulletEntity = new SCBulletEntity((class_1309)player, world);
        bulletEntity.setDamageAmount(WeaponDefinitionsLoader.getData(stack).ranged().baseDamage());
        bulletEntity.setDamageType(WeaponDefinitionsLoader.getData(stack).ranged().damageType());
        bulletEntity.method_7432((class_1297)player);
        bulletEntity.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, WeaponDefinitionsLoader.getData(stack).ranged().speed(), WeaponDefinitionsLoader.getData(stack).ranged().divergence());
        world.method_8649((class_1297)bulletEntity);
        SCRangeWeaponUtil.playSoundForPlayers(world, stack, player);
        if (!player.method_7337()) {
            stack.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            SCRangeWeaponUtil.spawnParticleTrail(serverWorld, player, player.method_6058(), (class_2394)ModParticles.MUZZLES_SMOKE_PARTICLE.get(), 100, 0.2f, 5.0E-4f, 5);
            SCRangeWeaponUtil.spawnParticleTrail(serverWorld, player, player.method_6058(), (class_2394)ModParticles.MUZZLES_FLASH_PARTICLE.get(), 1, 0.0f, 0.1f, 6);
        }
    }

    private static void playSoundForPlayers(class_1937 world, class_1799 stack, class_1657 player) {
        for (class_1657 playerEntity : world.method_18456()) {
            WeaponDefinitionsLoader.DefinitionData definitionData;
            class_243 hearPos;
            class_243 playerPos;
            double distance;
            float volume;
            if (playerEntity == null || (volume = (float)Math.max(0.0, 1.0 - (distance = (playerPos = player.method_19538()).method_1022(hearPos = playerEntity.method_19538())) * 0.01)) == 0.0f || (definitionData = WeaponDefinitionsLoader.getData(stack)).ranged().soundEvent() == null) continue;
            player.method_17356(definitionData.ranged().soundEvent(), class_3419.field_15245, volume, 1.0f);
        }
    }

    private static void spawnParticleTrail(class_3218 world, class_1657 player, class_1268 hand, class_2394 particle, int count, float delta, float spread, int distance) {
        class_243 handPos = SCRangeWeaponUtil.getHandPosition(player, hand);
        class_243 lookDir = player.method_5828(1.0f);
        ArrayList<class_243> trailPositions = new ArrayList<class_243>();
        for (int i = 0; i < distance; ++i) {
            trailPositions.add(handPos.method_1019(lookDir.method_1021((double)i)));
        }
        for (class_243 pos : trailPositions) {
            world.method_14199(particle, pos.field_1352, pos.field_1351, pos.field_1350, count, (double)delta, (double)delta, (double)delta, (double)spread);
        }
    }

    private static class_243 getHandPosition(class_1657 player, class_1268 hand) {
        boolean isMainHand = hand == class_1268.field_5808;
        double xOffset = isMainHand ? 0.1 : -0.1;
        double yOffset = 1.5;
        double zOffset = 1.5;
        class_243 basePos = player.method_19538().method_1031(0.0, yOffset, 0.0);
        class_243 sideOffset = player.method_5828(1.0f).method_1036(new class_243(0.0, 1.0, 0.0)).method_1021(xOffset);
        return basePos.method_1019(sideOffset).method_1019(player.method_5828(1.0f).method_1021(zOffset));
    }

    public static void loadAndPlayCrossbowSound(class_1937 world, class_1799 stack, class_1657 player, class_1665 arrowEntity) {
        Projectiles.fromNbt(stack.method_7948(), arrowEntity).loadProjectile();
        SCRangeWeaponUtil.setWeaponState(stack, new WeaponState(false, true, SCRangeWeaponUtil.getWeaponState(stack).isShooting()));
        class_3419 soundCategory = player instanceof class_1657 ? class_3419.field_15248 : class_3419.field_15251;
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14626, soundCategory, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f);
        if (!player.method_31549().field_7477) {
            stack.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
        }
    }

    public static Optional<class_1799> getArrowFromInventory(class_1657 player) {
        return player.method_31548().field_7547.stream().filter(stack -> stack.method_7909() instanceof class_1744).findFirst();
    }

    private static int getArrowSlot(class_1657 player) {
        return player.method_31548().field_7547.stream().filter(stack -> stack.method_7909() instanceof class_1744).map(arg_0 -> player.method_31548().field_7547.indexOf(arg_0)).findFirst().orElse(-1);
    }

    public static float getBowPullProgress(int useTicks) {
        float progress = (float)useTicks / 20.0f;
        return Math.min((progress * progress + progress * 2.0f) / 3.0f, 1.0f);
    }

    public static float getCrossbowPullProgress(int useTicks, class_1792 item) {
        return Math.min((float)useTicks / (float)(WeaponDefinitionsLoader.getData(item).ranged().rechargeTime() * 20), 1.0f);
    }

    public static WeaponState getWeaponState(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null ? WeaponState.fromNbt(nbt) : new WeaponState(false, false, false);
    }

    public static void setWeaponState(class_1799 stack, WeaponState state) {
        class_2487 nbt = stack.method_7948();
        state.applyToNbt(nbt);
    }

    private static class_1792[] getItemsFromIds(Set<String> itemIds) {
        return (class_1792[])itemIds.stream().map(class_2960::new).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).toArray(class_1792[]::new);
    }

    public static AmmoRequirement getAmmoRequirement(class_1799 itemStack) {
        WeaponDefinitionsLoader.DefinitionData definitionData = WeaponDefinitionsLoader.getData(itemStack);
        Map<String, WeaponDefinitionsLoader.AmmoRequirementData> ammoRequirementMap = definitionData.ranged().ammoRequirement();
        int amountFirstItem = 0;
        class_1792[] firstItems = null;
        int amountSecondItem = 0;
        class_1792[] secondItems = null;
        int amountThirdItem = 0;
        class_1792[] thirdItems = null;
        if (ammoRequirementMap.containsKey("item1")) {
            WeaponDefinitionsLoader.AmmoRequirementData item1Data = ammoRequirementMap.get("item1");
            amountFirstItem = item1Data.amount();
            firstItems = SCRangeWeaponUtil.getItemsFromIds(item1Data.itemIds());
        }
        if (ammoRequirementMap.containsKey("item2")) {
            WeaponDefinitionsLoader.AmmoRequirementData item2Data = ammoRequirementMap.get("item2");
            amountSecondItem = item2Data.amount();
            secondItems = SCRangeWeaponUtil.getItemsFromIds(item2Data.itemIds());
        }
        if (ammoRequirementMap.containsKey("item3")) {
            WeaponDefinitionsLoader.AmmoRequirementData item3Data = ammoRequirementMap.get("item3");
            amountThirdItem = item3Data.amount();
            thirdItems = SCRangeWeaponUtil.getItemsFromIds(item3Data.itemIds());
        }
        return amountFirstItem >= 1 ? new AmmoRequirement(amountFirstItem, firstItems[0], firstItems.length > 1 ? firstItems[1] : null, amountSecondItem, secondItems != null ? secondItems[0] : null, secondItems != null && secondItems.length > 1 ? secondItems[1] : null, amountThirdItem, thirdItems != null ? thirdItems[0] : null, thirdItems != null && thirdItems.length > 1 ? thirdItems[1] : null) : null;
    }

    public record WeaponState(boolean isReloading, boolean isCharged, boolean isShooting) {
        public static WeaponState fromNbt(class_2487 nbt) {
            return new WeaponState(nbt.method_10577("reload"), nbt.method_10577("charged"), nbt.method_10577("shoot"));
        }

        public void applyToNbt(class_2487 nbt) {
            nbt.method_10556("reload", this.isReloading);
            nbt.method_10556("charged", this.isCharged);
            nbt.method_10556("shoot", this.isShooting);
        }
    }

    public record Projectiles(class_1665 persistentProjectileEntity, int arrowCount) {
        public static Projectiles fromNbt(class_2487 nbt, class_1665 persistentProjectileEntity) {
            int count = nbt.method_10545(persistentProjectileEntity.method_5820()) ? nbt.method_10550(persistentProjectileEntity.method_5820()) : 0;
            return new Projectiles(persistentProjectileEntity, count);
        }

        public void loadProjectile() {
            new Projectiles(this.persistentProjectileEntity, this.arrowCount + 1);
        }

        public Projectiles unloadProjectile() {
            return new Projectiles(this.persistentProjectileEntity, Math.max(this.arrowCount - 1, 0));
        }

        public void applyToNbt(class_2487 nbt) {
            nbt.method_10569(this.persistentProjectileEntity.method_5820(), this.arrowCount);
        }

        public int getArrowCount() {
            return this.arrowCount;
        }
    }

    public record AmmoRequirement(int amountFirstItem, class_1792 firstItem, class_1792 firstItem2nOption, int amountSecondItem, class_1792 secondItem, class_1792 secondItem2nOption, int amountThirdItem, class_1792 thirdItem, class_1792 thirdItem2nOption) {
    }
}

