/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighttowns.commands;

import com.knightgost.knighttowns.KnightTowns;
import com.knightgost.knighttowns.data.Town;
import com.knightgost.knighttowns.data.TownManager;
import com.knightgost.knighttowns.data.TownRank;
import com.knightgost.knighttowns.utils.BorderUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class TownCommand
implements CommandExecutor {
    private final KnightTowns plugin;
    private final Map<String, Town> towns = new HashMap<String, Town>();

    public TownCommand(KnightTowns plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendUsage(player);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "help": {
                this.handleHelp((CommandSender)player);
                break;
            }
            case "create": {
                this.handleCreate(player, args);
                break;
            }
            case "delete": {
                this.handleDelete(player, args);
                break;
            }
            case "list": {
                this.handleList((CommandSender)player);
                break;
            }
            case "showborder": {
                this.handleShowBorder(player, args);
                break;
            }
            case "claim": {
                this.handleClaim(player);
                break;
            }
            case "addmember": {
                this.handleAddMember(player, args);
                break;
            }
            case "removemember": {
                this.handleRemoveMember(player, args);
                break;
            }
            case "setrank": {
                this.handleSetRank(player, args);
                break;
            }
            default: {
                this.sendUsage(player);
            }
        }
        return true;
    }

    private void sendUsage(Player player) {
        player.sendMessage("\u00a7eUsage: /town help \u00a77- Show list of commands");
    }

    private void handleHelp(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== Town Commands ===");
        sender.sendMessage("\u00a7e/town create <name> \u00a77- Create a new town (TownMaster only)");
        sender.sendMessage("\u00a7e/town list \u00a77- List all towns with Mayor info");
        sender.sendMessage("\u00a7e/town delete <name> \u00a77- Delete a town (TownMaster only)");
        sender.sendMessage("\u00a7e/town showborder \u00a77- Show the border of your town for a few seconds");
        sender.sendMessage("\u00a7e/town claim \u00a77- Claim the chunk you are standing on for your town");
        sender.sendMessage("\u00a7e/town addmember <player> <rank> \u00a77- Add a player to your town (Mayor/TownMaster only)");
        sender.sendMessage("\u00a7e/town removemember <player> \u00a77- Remove a player from your town (Mayor/TownMaster only)");
    }

    private void handleCreate(Player player, String[] args) {
        YamlConfiguration config;
        if (args.length < 2) {
            player.sendMessage("\u00a7eUsage: /town create <name>");
            return;
        }
        if (!player.isOp()) {
            player.sendMessage("\u00a7cOnly OPs can create a town!");
            return;
        }
        String townName = args[1].toLowerCase();
        if (this.towns.containsKey(townName)) {
            player.sendMessage("\u00a7cA town with that name already exists!");
            return;
        }
        File file = new File(this.plugin.getDataFolder(), "towns.yml");
        if (file.exists() && (config = YamlConfiguration.loadConfiguration((File)file)).contains(townName)) {
            player.sendMessage("\u00a7cA town with that name already exists in file!");
            return;
        }
        Town town = new Town(townName, player.getUniqueId());
        town.addMember(player.getUniqueId(), TownRank.TOWNMASTER);
        Chunk currentChunk = player.getLocation().getChunk();
        town.addClaimedChunk(currentChunk);
        this.towns.put(townName, town);
        TownManager.addTown(town);
        TownManager.saveTownToFile(this.plugin, town);
        player.sendMessage("\u00a7a\u2705 Town \u00a76" + townName + "\u00a7a created and claimed your current chunk!");
        BorderUtils.showTownBorder(this.plugin, player, town, 30);
    }

    private void handleDelete(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage("\u00a7eUsage: /town delete <name>");
            return;
        }
        String townName = args[1].toLowerCase();
        File file = new File(this.plugin.getDataFolder(), "towns.yml");
        if (!file.exists()) {
            player.sendMessage("\u00a7cNo towns exist to delete.");
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (!config.contains(townName)) {
            player.sendMessage("\u00a7cThat town does not exist.");
            return;
        }
        Town town = TownManager.getTown(townName);
        if (town == null) {
            player.sendMessage("\u00a7cTown data is missing in memory!");
            return;
        }
        TownRank playerRank = town.getRank(player.getUniqueId());
        if (playerRank != TownRank.TOWNMASTER && !player.isOp()) {
            player.sendMessage("\u00a7cOnly the TownMaster or an OP can delete a town!");
            return;
        }
        config.set(townName, null);
        try {
            config.save(file);
            TownManager.removeTown(townName);
            player.sendMessage("\u00a7a\ud83c\udfd9 Town '" + townName + "' has been deleted.");
        }
        catch (IOException e) {
            player.sendMessage("\u00a7cFailed to delete town. Check console for details.");
            e.printStackTrace();
        }
    }

    private void handleList(CommandSender sender) {
        File file = new File(this.plugin.getDataFolder(), "towns.yml");
        if (!file.exists()) {
            sender.sendMessage("\u00a7cNo towns have been created yet!");
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        Set townNames = config.getKeys(false);
        if (townNames.isEmpty()) {
            sender.sendMessage("\u00a77There are currently no towns created.");
            return;
        }
        sender.sendMessage("\u00a76\ud83c\udfd9 Towns List:");
        for (String townName : townNames) {
            String mayorName = "Unknown";
            Town town = TownManager.getTown(townName);
            if (town != null) {
                for (Map.Entry<UUID, TownRank> entry : town.getMembers().entrySet()) {
                    if (entry.getValue() != TownRank.MAYOR) continue;
                    OfflinePlayer mayor = Bukkit.getOfflinePlayer((UUID)entry.getKey());
                    if (mayor != null && mayor.getName() != null) {
                        mayorName = mayor.getName();
                        break;
                    }
                    mayorName = entry.getKey().toString().substring(0, 8);
                    break;
                }
            }
            sender.sendMessage("\u00a7e- \u00a7a" + townName + " \u00a77(\u00a76Mayor:\u00a7f " + mayorName + "\u00a77)");
        }
    }

    private void handleShowBorder(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage("\u00a7eUsage: /town showborder <town>");
            return;
        }
        String townName = args[1].toLowerCase();
        Town town = TownManager.getTown(townName);
        if (town == null) {
            player.sendMessage("\u00a7c\u26a0 Town '" + townName + "' not found!");
            return;
        }
        if (town.getClaimedChunks().isEmpty()) {
            player.sendMessage("\u00a7cThis town has no claimed chunks!");
            return;
        }
        BorderUtils.showTownBorder(this.plugin, player, town, 30);
        player.sendMessage("\u00a7a\ud83c\udfd9 Showing borders for town \u00a7e" + town.getName() + " \u00a7a!");
    }

    private void handleClaim(Player player) {
        UUID playerUUID = player.getUniqueId();
        Town town = TownManager.getPlayerTown(playerUUID);
        if (town == null) {
            player.sendMessage("\u00a7cYou are not part of any town!");
            return;
        }
        TownRank rank = town.getRank(playerUUID);
        if (rank != TownRank.MAYOR) {
            player.sendMessage("\u00a7cOnly the mayor can claim new chunks!");
            return;
        }
        Chunk currentChunk = player.getLocation().getChunk();
        String chunkKey = currentChunk.getWorld().getName() + "," + currentChunk.getX() + "," + currentChunk.getZ();
        if (town.getClaimedChunks().contains(chunkKey)) {
            player.sendMessage("\u00a7eThis chunk is already claimed by your town!");
            return;
        }
        Town existingOwner = TownManager.getTownByChunk(currentChunk);
        if (existingOwner != null) {
            player.sendMessage("\u00a7cThis chunk is already claimed by another town: \u00a7e" + existingOwner.getName());
            return;
        }
        town.addClaimedChunk(currentChunk);
        try {
            TownManager.saveTownToFile(this.plugin, town);
        }
        catch (Exception e) {
            player.sendMessage("\u00a7cFailed to save town data! Contact an admin.");
            e.printStackTrace();
            return;
        }
        player.sendMessage("\u00a7a\u2705 You have claimed this chunk for your town!");
        BorderUtils.showTownBorder(this.plugin, player, town, 30);
    }

    private void handleAddMember(Player player, String[] args) {
        TownRank rank;
        if (args.length < 3) {
            player.sendMessage("\u00a7eUsage: /town addmember <player> <rank>");
            return;
        }
        Town town = TownManager.getTownByPlayer(player.getUniqueId());
        if (town == null) {
            player.sendMessage("\u00a7cYou are not a member of any town.");
            return;
        }
        TownRank playerRank = town.getRank(player.getUniqueId());
        if (playerRank == null) {
            player.sendMessage("\u00a7cYou have no rank in this town!");
            return;
        }
        String targetName = args[1];
        OfflinePlayer offline = Bukkit.getOfflinePlayer((String)targetName);
        if (offline == null || offline.getUniqueId() == null) {
            player.sendMessage("\u00a7cCould not find that player (try exact name).");
            return;
        }
        UUID targetUUID = offline.getUniqueId();
        if (town.isMember(targetUUID)) {
            player.sendMessage("\u00a7eThat player is already a member of your town!");
            return;
        }
        try {
            rank = TownRank.valueOf(args[2].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            player.sendMessage("\u00a7cInvalid rank. Use: TOWNMASTER, MAYOR, ASSISTANT, MEMBER, VISITOR");
            return;
        }
        if (playerRank != TownRank.TOWNMASTER) {
            if (playerRank == TownRank.MAYOR) {
                if (rank == TownRank.TOWNMASTER || rank == TownRank.MAYOR) {
                    player.sendMessage("\u00a7cYou cannot add someone as TownMaster or Mayor!");
                    return;
                }
            } else {
                player.sendMessage("\u00a7cYou do not have permission to add members!");
                return;
            }
        }
        town.addMember(targetUUID, rank);
        TownManager.saveTownToFile(this.plugin, town);
        TownManager.addTown(town);
        player.sendMessage("\u00a7aAdded \u00a7e" + offline.getName() + " \u00a7ato town as \u00a7b" + rank.name());
        if (offline.isOnline()) {
            ((Player)offline).sendMessage("\u00a7aYou have been added to \u00a7e" + town.getName() + " \u00a7aas \u00a7b" + rank.name());
        }
    }

    private void handleSetRank(Player player, String[] args) {
        TownRank newRank;
        if (args.length < 3) {
            player.sendMessage("\u00a7eUsage: /town setrank <player> <rank>");
            return;
        }
        Town town = TownManager.getTownByPlayer(player.getUniqueId());
        if (town == null) {
            player.sendMessage("\u00a7cYou are not a member of any town.");
            return;
        }
        TownRank playerRank = town.getRank(player.getUniqueId());
        if (playerRank == null) {
            player.sendMessage("\u00a7cYou have no rank in this town!");
            return;
        }
        String targetName = args[1];
        OfflinePlayer offline = Bukkit.getOfflinePlayer((String)targetName);
        if (offline == null || offline.getUniqueId() == null) {
            player.sendMessage("\u00a7cCould not find that player (try exact name).");
            return;
        }
        UUID targetUUID = offline.getUniqueId();
        if (!town.isMember(targetUUID)) {
            player.sendMessage("\u00a7cThat player is not a member of your town!");
            return;
        }
        try {
            newRank = TownRank.valueOf(args[2].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            player.sendMessage("\u00a7cInvalid rank. Use: TOWNMASTER, MAYOR, ASSISTANT, MEMBER, VISITOR");
            return;
        }
        TownRank targetRank = town.getRank(targetUUID);
        if (playerRank != TownRank.TOWNMASTER) {
            if (playerRank == TownRank.MAYOR) {
                if (targetRank == TownRank.TOWNMASTER || targetRank == TownRank.MAYOR) {
                    player.sendMessage("\u00a7cYou cannot change the rank of a TownMaster or Mayor!");
                    return;
                }
                if (newRank == TownRank.TOWNMASTER || newRank == TownRank.MAYOR) {
                    player.sendMessage("\u00a7cYou cannot promote someone to Mayor or TownMaster!");
                    return;
                }
            } else {
                player.sendMessage("\u00a7cYou do not have permission to set ranks!");
                return;
            }
        }
        town.addMember(targetUUID, newRank);
        TownManager.saveTownToFile(this.plugin, town);
        TownManager.addTown(town);
        player.sendMessage("\u00a7aChanged \u00a7e" + offline.getName() + "\u00a7a's rank to \u00a7b" + newRank.name());
        if (offline.isOnline()) {
            ((Player)offline).sendMessage("\u00a7aYour rank in \u00a7e" + town.getName() + " \u00a7ais now \u00a7b" + newRank.name());
        }
    }

    private void handleRemoveMember(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage("\u00a7eUsage: /town removemember <player>");
            return;
        }
        Town town = TownManager.getTownByPlayer(player.getUniqueId());
        if (town == null) {
            player.sendMessage("\u00a7cYou are not a member of any town.");
            return;
        }
        TownRank playerRank = town.getRank(player.getUniqueId());
        if (playerRank == null) {
            player.sendMessage("\u00a7cYou have no rank in this town!");
            return;
        }
        String targetName = args[1];
        OfflinePlayer offline = Bukkit.getOfflinePlayer((String)targetName);
        if (offline == null || offline.getUniqueId() == null) {
            player.sendMessage("\u00a7cCould not find that player (try exact name).");
            return;
        }
        UUID targetUUID = offline.getUniqueId();
        if (!town.isMember(targetUUID)) {
            player.sendMessage("\u00a7cThat player is not a member of your town!");
            return;
        }
        TownRank targetRank = town.getRank(targetUUID);
        if (playerRank != TownRank.TOWNMASTER) {
            if (playerRank == TownRank.MAYOR) {
                if (targetRank == TownRank.TOWNMASTER || targetRank == TownRank.MAYOR) {
                    player.sendMessage("\u00a7cYou cannot remove a TownMaster or another Mayor!");
                    return;
                }
            } else {
                player.sendMessage("\u00a7cYou do not have permission to remove members!");
                return;
            }
        }
        if (player.getUniqueId().equals(targetUUID)) {
            player.sendMessage("\u00a7cYou cannot remove yourself from the town!");
            return;
        }
        town.removeMember(targetUUID);
        TownManager.saveTownToFile(this.plugin, town);
        TownManager.addTown(town);
        player.sendMessage("\u00a7aRemoved \u00a7e" + offline.getName() + " \u00a7afrom your town.");
        if (offline.isOnline()) {
            ((Player)offline).sendMessage("\u00a7cYou have been removed from \u00a7e" + town.getName() + "\u00a7c.");
        }
    }
}

