/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighttowns.data;

import com.knightgost.knighttowns.data.TownPermission;
import com.knightgost.knighttowns.data.TownRank;
import com.knightgost.knighttowns.utils.TownPerms;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Town {
    private final String name;
    private final UUID mayor;
    private Set<String> claimedChunks = new HashSet<String>();
    private Map<UUID, TownRank> members = new HashMap<UUID, TownRank>();

    public void addMember(UUID uuid, TownRank rank) {
        if (uuid == null || rank == null) {
            return;
        }
        this.members.put(uuid, rank);
    }

    public void removeMember(UUID uuid) {
        if (uuid == null) {
            return;
        }
        this.members.remove(uuid);
    }

    public boolean isMember(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return this.members.containsKey(uuid);
    }

    public TownRank getRank(UUID uuid) {
        return this.members.getOrDefault(uuid, TownRank.VISITOR);
    }

    public boolean hasPermission(UUID uuid, TownPermission perm) {
        return TownPerms.hasPermission(this.getRank(uuid), perm);
    }

    public Map<UUID, TownRank> getMembers() {
        return this.members;
    }

    public Town(String name, UUID mayor) {
        this.name = name;
        this.mayor = mayor;
    }

    public String getName() {
        return this.name;
    }

    public UUID getMayorUUID() {
        return this.mayor;
    }

    public Player getMayorPlayer() {
        return this.mayor == null ? null : Bukkit.getPlayer((UUID)this.mayor);
    }

    public UUID getTownMasterUUID() {
        for (Map.Entry<UUID, TownRank> entry : this.members.entrySet()) {
            if (entry.getValue() != TownRank.TOWNMASTER) continue;
            return entry.getKey();
        }
        return null;
    }

    public void addClaimedChunk(Chunk chunk) {
        String key = chunk.getWorld().getName() + "," + chunk.getX() + "," + chunk.getZ();
        this.claimedChunks.add(key);
    }

    public void removeClaimedChunk(Chunk chunk) {
        String key = chunk.getWorld().getName() + "," + chunk.getX() + "," + chunk.getZ();
        this.claimedChunks.remove(key);
    }

    public Set<String> getClaimedChunks() {
        return this.claimedChunks;
    }

    public void setClaimedChunks(Set<String> claimedChunks) {
        this.claimedChunks = claimedChunks;
    }

    public Set<Chunk> getClaimedChunksAsObjects() {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        for (String key : this.claimedChunks) {
            World world;
            String[] parts = key.split(",");
            if (parts.length != 3 || (world = Bukkit.getWorld((String)parts[0])) == null) continue;
            int x = Integer.parseInt(parts[1]);
            int z = Integer.parseInt(parts[2]);
            chunks.add(world.getChunkAt(x, z));
        }
        return chunks;
    }

    public boolean isInsideTown(Location loc) {
        for (Chunk chunk : this.getClaimedChunksAsObjects()) {
            int x1 = chunk.getX() << 4;
            int z1 = chunk.getZ() << 4;
            int x2 = x1 + 15;
            int z2 = z1 + 15;
            int lx = loc.getBlockX();
            int lz = loc.getBlockZ();
            if (lx < x1 || lx > x2 || lz < z1 || lz > z2) continue;
            return true;
        }
        return false;
    }

    public Set<Vector> getClaimedChunkPositions() {
        HashSet<Vector> positions = new HashSet<Vector>();
        for (String key : this.claimedChunks) {
            String[] parts = key.split(",");
            if (parts.length != 3) continue;
            int x = Integer.parseInt(parts[1]);
            int z = Integer.parseInt(parts[2]);
            positions.add(new Vector(x, 0, z));
        }
        return positions;
    }

    public void showChunkBorders(Player player) {
        Set<Vector> positions = this.getClaimedChunkPositions();
        for (Vector pos : positions) {
            World world = player.getWorld();
            int y = player.getLocation().getBlockY();
            int startX = pos.getBlockX() << 4;
            int startZ = pos.getBlockZ() << 4;
            int endX = startX + 15;
            int endZ = startZ + 15;
            this.setTempBlock(world, startX, y, startZ, Material.GLOWSTONE);
            this.setTempBlock(world, endX, y, startZ, Material.GLOWSTONE);
            this.setTempBlock(world, startX, y, endZ, Material.GLOWSTONE);
            this.setTempBlock(world, endX, y, endZ, Material.GLOWSTONE);
            for (int x = startX; x <= endX; ++x) {
                this.setTempBlock(world, x, y, startZ, Material.GLOWSTONE);
                this.setTempBlock(world, x, y, endZ, Material.GLOWSTONE);
            }
            for (int z = startZ; z <= endZ; ++z) {
                this.setTempBlock(world, startX, y, z, Material.GLOWSTONE);
                this.setTempBlock(world, endX, y, z, Material.GLOWSTONE);
            }
        }
    }

    private void setTempBlock(World world, int x, int y, int z, Material material) {
        Block block = world.getBlockAt(x, y, z);
        block.setType(material);
    }
}

