/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighttowns.listeners;

import com.knightgost.knighttowns.data.Town;
import com.knightgost.knighttowns.data.TownManager;
import com.knightgost.knighttowns.data.TownRank;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class TownProtectionListener
implements Listener {
    private final JavaPlugin plugin;

    public TownProtectionListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    private boolean canModify(Player player, Location loc) {
        if (player.isOp()) {
            return true;
        }
        if (player.hasPermission("knighttowns.bypass")) {
            return true;
        }
        Town town = TownManager.getTownByLocation(loc);
        if (town == null) {
            return true;
        }
        UUID playerUUID = player.getUniqueId();
        TownRank rank = town.getRank(playerUUID);
        if (rank == null) {
            rank = TownRank.VISITOR;
        }
        return rank != TownRank.VISITOR;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Location loc;
        Player player = event.getPlayer();
        if (!this.canModify(player, loc = event.getBlock().getLocation())) {
            player.sendMessage("\u00a7cVisitors cannot break blocks in another town!");
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Location loc;
        Player player = event.getPlayer();
        if (!this.canModify(player, loc = event.getBlock().getLocation())) {
            player.sendMessage("\u00a7cVisitors cannot place blocks in another town!");
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getClickedBlock() == null) {
            return;
        }
        Material type = event.getClickedBlock().getType();
        if (!type.isInteractable()) {
            return;
        }
        Location loc = event.getClickedBlock().getLocation();
        if (!this.canModify(player, loc)) {
            player.sendMessage("\u00a7cVisitors cannot interact with blocks in another town!");
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onExplosion(EntityExplodeEvent event) {
        ArrayList<Block> toRemove = new ArrayList<Block>();
        for (Block block : event.blockList()) {
            Town town = TownManager.getTownByLocation(block.getLocation());
            if (town == null) continue;
            toRemove.add(block);
        }
        event.blockList().removeAll(toRemove);
    }
}

