/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighttowns.player;

import com.knightgost.knighttowns.data.PlayerXPManager;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerXPListener
implements Listener {
    private final JavaPlugin plugin;

    public PlayerXPListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        int xp;
        Player player = e.getPlayer();
        Material block = e.getBlock().getType();
        switch (block) {
            case EMERALD_ORE: 
            case DEEPSLATE_EMERALD_ORE: {
                int n = 30;
                break;
            }
            case DIAMOND_ORE: 
            case DEEPSLATE_DIAMOND_ORE: {
                int n = 20;
                break;
            }
            case IRON_ORE: 
            case DEEPSLATE_IRON_ORE: 
            case GOLD_ORE: 
            case DEEPSLATE_GOLD_ORE: {
                int n = 10;
                break;
            }
            case COPPER_ORE: {
                int n = 3;
                break;
            }
            case OAK_LOG: 
            case SPRUCE_LOG: 
            case BIRCH_LOG: 
            case JUNGLE_LOG: 
            case ACACIA_LOG: 
            case DARK_OAK_LOG: 
            case CHERRY_LOG: {
                int n = 2;
                break;
            }
            case STONE: {
                int n = 1;
                break;
            }
            default: {
                int n = xp = 0;
            }
        }
        if (xp > 0) {
            UUID uuid = player.getUniqueId();
            int oldLevel = PlayerXPManager.getLevel(uuid);
            PlayerXPManager.addXP(uuid, xp);
            int newLevel = PlayerXPManager.getLevel(uuid);
            player.sendActionBar("\u00a7a+" + xp + " XP \u00a77| Level " + newLevel);
            if (newLevel > oldLevel) {
                player.sendMessage("\u00a76\u00a7lLEVEL UP! \u00a7eYou are now Level " + newLevel + "!");
            }
        }
    }

    @EventHandler
    public void onPlayerKill(PlayerDeathEvent e) {
        if (e.getEntity().getKiller() != null) {
            Player killer = e.getEntity().getKiller();
            UUID uuid = killer.getUniqueId();
            int oldLevel = PlayerXPManager.getLevel(uuid);
            PlayerXPManager.addXP(uuid, 50);
            int newLevel = PlayerXPManager.getLevel(uuid);
            killer.sendActionBar("\u00a7a+50 XP \u00a77(Kill) | Level " + newLevel);
            if (newLevel > oldLevel) {
                killer.sendMessage("\u00a76\u00a7lLEVEL UP! \u00a7eYou are now Level " + newLevel + "!");
            }
        }
    }
}

